/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2;

import java.util.ArrayList;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v20.common.IDType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.AttachmentLevelType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.AttributeType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ComponentsType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.DimensionType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.KeyFamilyType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.TimeDimensionType;
import org.sdmxsource.sdmx.api.builder.Builder;
import org.sdmxsource.sdmx.api.constants.ATTRIBUTE_ATTACHMENT_LEVEL;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.CrossSectionalDataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.CrossSectionalMeasureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.GroupBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.AbstractBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.AttributeXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.CrossSectionalMeasureXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.DimensionXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.GroupXmlBeansBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.PrimaryMeasureXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.TimeDimensionXmlBeanBuilder;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dataStructureXmlBeanBuilderV2")
public class DataStructureXmlBeanBuilder
extends AbstractBuilder
implements Builder<KeyFamilyType, DataStructureBean> {
    @Autowired
    private DimensionXmlBeanBuilder dimensionXmlBeanBuilder;
    @Autowired
    private CrossSectionalMeasureXmlBeanBuilder crossSectionalXmlBeanBuilder;
    @Autowired
    private TimeDimensionXmlBeanBuilder timeDimensionXmlBeanBuilder;
    @Autowired
    private GroupXmlBeansBuilder groupXmlBeansBuilder;
    @Autowired
    private PrimaryMeasureXmlBeanBuilder primaryMeasureXmlBeanBuilder;
    @Autowired
    private AttributeXmlBeanBuilder attributeXmlBeanBuilder;

    @Override
    public KeyFamilyType build(DataStructureBean buildFrom) throws SdmxException {
        KeyFamilyType builtObj = KeyFamilyType.Factory.newInstance();
        if (this.validString(buildFrom.getAgencyId())) {
            builtObj.setAgencyID(buildFrom.getAgencyId());
        }
        if (this.validString(buildFrom.getId())) {
            builtObj.setId(buildFrom.getId());
        }
        if (buildFrom.getUri() != null) {
            builtObj.setUri(buildFrom.getUri().toString());
        } else if (buildFrom.getStructureURL() != null) {
            builtObj.setUri(buildFrom.getStructureURL().toString());
        } else if (buildFrom.getServiceURL() != null) {
            builtObj.setUri(buildFrom.getStructureURL().toString());
        }
        if (this.validString(buildFrom.getUrn())) {
            builtObj.setUrn(buildFrom.getUrn());
        }
        if (this.validString(buildFrom.getVersion())) {
            builtObj.setVersion(buildFrom.getVersion());
        }
        if (buildFrom.getStartDate() != null) {
            builtObj.setValidFrom(buildFrom.getStartDate().getDate());
        }
        if (buildFrom.getEndDate() != null) {
            builtObj.setValidTo(buildFrom.getEndDate().getDate());
        }
        if (this.validCollection(buildFrom.getNames())) {
            builtObj.setNameArray(this.getTextType(buildFrom.getNames()));
        }
        if (this.validCollection(buildFrom.getDescriptions())) {
            builtObj.setDescriptionArray(this.getTextType(buildFrom.getDescriptions()));
        }
        if (this.hasAnnotations(buildFrom)) {
            builtObj.setAnnotations(this.getAnnotationsType(buildFrom));
        }
        if (buildFrom.isExternalReference().isSet()) {
            builtObj.setIsExternalReference(buildFrom.isExternalReference().isTrue());
        }
        if (buildFrom.isFinal().isSet()) {
            builtObj.setIsFinal(buildFrom.isFinal().isTrue());
        }
        ComponentsType componentsType = null;
        List<Object> crossSectionalAttachDataSet = new ArrayList();
        List<Object> crossSectionalAttachGroup = new ArrayList();
        List<Object> crossSectionalAttachSection = new ArrayList();
        List<Object> crossSectionalAttachObservation = new ArrayList();
        CrossSectionalDataStructureBean crossSectionalBean = null;
        if (buildFrom instanceof CrossSectionalDataStructureBean) {
            crossSectionalBean = (CrossSectionalDataStructureBean)buildFrom;
            crossSectionalAttachDataSet = crossSectionalBean.getCrossSectionalAttachDataSet(false, new SDMX_STRUCTURE_TYPE[0]);
            crossSectionalAttachGroup = crossSectionalBean.getCrossSectionalAttachGroup(false, new SDMX_STRUCTURE_TYPE[0]);
            crossSectionalAttachSection = crossSectionalBean.getCrossSectionalAttachObservation(new SDMX_STRUCTURE_TYPE[0]);
            crossSectionalAttachObservation = crossSectionalBean.getCrossSectionalAttachSection(false, new SDMX_STRUCTURE_TYPE[0]);
            if (componentsType == null) {
                componentsType = builtObj.addNewComponents();
            }
            for (CrossSectionalMeasureBean currentMeasure : crossSectionalBean.getCrossSectionalMeasures()) {
                componentsType.getCrossSectionalMeasureList().add(this.crossSectionalXmlBeanBuilder.build(currentMeasure));
            }
        }
        if (ObjectUtil.validCollection(buildFrom.getDimensions(SDMX_STRUCTURE_TYPE.DIMENSION, SDMX_STRUCTURE_TYPE.MEASURE_DIMENSION))) {
            if (componentsType == null) {
                componentsType = builtObj.addNewComponents();
            }
            for (DimensionBean currentDim : buildFrom.getDimensions(SDMX_STRUCTURE_TYPE.DIMENSION, SDMX_STRUCTURE_TYPE.MEASURE_DIMENSION)) {
                DimensionType newDimension = this.dimensionXmlBeanBuilder.build(currentDim);
                if (crossSectionalBean != null && currentDim.isMeasureDimension()) {
                    CrossReferenceBean xsRef = crossSectionalBean.getCodelistForMeasureDimension(currentDim.getId());
                    newDimension.setCodelist(xsRef.getMaintainableReference().getMaintainableId());
                    newDimension.setCodelistAgency(xsRef.getMaintainableReference().getAgencyId());
                    newDimension.setCodelistVersion(xsRef.getMaintainableReference().getVersion());
                }
                if (crossSectionalAttachDataSet.contains(currentDim)) {
                    newDimension.setCrossSectionalAttachDataSet(true);
                }
                if (crossSectionalAttachGroup.contains(currentDim)) {
                    newDimension.setCrossSectionalAttachGroup(true);
                }
                if (crossSectionalAttachSection.contains(currentDim)) {
                    newDimension.setCrossSectionalAttachSection(true);
                }
                if (crossSectionalAttachObservation.contains(currentDim)) {
                    newDimension.setCrossSectionalAttachObservation(true);
                }
                componentsType.getDimensionList().add(newDimension);
            }
        }
        if (buildFrom.getTimeDimension() != null) {
            if (componentsType == null) {
                componentsType = builtObj.addNewComponents();
            }
            TimeDimensionType newDimension = this.timeDimensionXmlBeanBuilder.build(buildFrom.getTimeDimension());
            if (crossSectionalAttachDataSet.contains(buildFrom.getTimeDimension())) {
                newDimension.setCrossSectionalAttachDataSet(true);
            }
            if (crossSectionalAttachGroup.contains(buildFrom.getTimeDimension())) {
                newDimension.setCrossSectionalAttachGroup(true);
            }
            if (crossSectionalAttachSection.contains(buildFrom.getTimeDimension())) {
                newDimension.setCrossSectionalAttachSection(true);
            }
            if (crossSectionalAttachObservation.contains(buildFrom.getTimeDimension())) {
                newDimension.setCrossSectionalAttachObservation(true);
            }
            componentsType.setTimeDimension(newDimension);
        }
        if (ObjectUtil.validCollection(buildFrom.getGroups())) {
            if (componentsType == null) {
                componentsType = builtObj.addNewComponents();
            }
            for (GroupBean currentGroup : buildFrom.getGroups()) {
                componentsType.getGroupList().add(this.groupXmlBeansBuilder.build(currentGroup));
            }
        }
        if (buildFrom.getPrimaryMeasure() != null) {
            if (componentsType == null) {
                componentsType = builtObj.addNewComponents();
            }
            componentsType.setPrimaryMeasure(this.primaryMeasureXmlBeanBuilder.build(buildFrom.getPrimaryMeasure()));
        }
        if (ObjectUtil.validCollection(buildFrom.getAttributes())) {
            if (componentsType == null) {
                componentsType = builtObj.addNewComponents();
            }
            for (AttributeBean currentAttr : buildFrom.getAttributes()) {
                AttributeType newAttribute = this.attributeXmlBeanBuilder.build(currentAttr);
                if (currentAttr.getAttachmentLevel() == ATTRIBUTE_ATTACHMENT_LEVEL.DIMENSION_GROUP) {
                    List<String> dimensionReferences = currentAttr.getDimensionReferences();
                    for (GroupBean grp : buildFrom.getGroups()) {
                        if (!grp.getDimensionRefs().containsAll(dimensionReferences) || !dimensionReferences.containsAll(grp.getDimensionRefs())) continue;
                        newAttribute.setAttachmentLevel(AttachmentLevelType.GROUP);
                        newAttribute.addAttachmentGroup(grp.getId());
                        break;
                    }
                }
                if (crossSectionalAttachDataSet.contains(currentAttr)) {
                    newAttribute.setCrossSectionalAttachDataSet(true);
                }
                if (crossSectionalAttachGroup.contains(currentAttr)) {
                    newAttribute.setCrossSectionalAttachGroup(true);
                }
                if (crossSectionalAttachSection.contains(currentAttr)) {
                    newAttribute.setCrossSectionalAttachSection(true);
                }
                if (crossSectionalAttachObservation.contains(currentAttr)) {
                    newAttribute.setCrossSectionalAttachObservation(true);
                }
                if (crossSectionalBean != null) {
                    for (CrossSectionalMeasureBean crossSectionalMeasure : crossSectionalBean.getAttachmentMeasures(currentAttr)) {
                        IDType idType = newAttribute.addNewAttachmentMeasure();
                        idType.setStringValue(crossSectionalMeasure.getId());
                    }
                }
                componentsType.getAttributeList().add(newAttribute);
            }
        }
        return builtObj;
    }
}

