/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2;

import java.math.BigInteger;
import org.sdmx.resources.sdmxml.schemas.v20.structure.HierarchyType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.LevelType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.TextFormatType;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.beans.codelist.LevelBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.AbstractBuilder;
import org.springframework.stereotype.Service;

@Service(value="LevelXmlBeansBuilderV2")
public class LevelXmlBeansBuilder
extends AbstractBuilder {
    public void buildList(HierarchyType hierarchyType, LevelBean buildFrom, int order) throws SdmxException {
        LevelType builtObj = hierarchyType.addNewLevel();
        if (this.validString(buildFrom.getId())) {
            builtObj.setId(buildFrom.getId());
        }
        if (this.validString(buildFrom.getUrn())) {
            builtObj.setUrn(buildFrom.getUrn());
        }
        if (this.validCollection(buildFrom.getNames())) {
            builtObj.setNameArray(this.getTextType(buildFrom.getNames()));
        }
        if (this.validCollection(buildFrom.getDescriptions())) {
            builtObj.setDescriptionArray(this.getTextType(buildFrom.getDescriptions()));
        }
        if (this.hasAnnotations(buildFrom)) {
            builtObj.setAnnotations(this.getAnnotationsType(buildFrom));
        }
        builtObj.setOrder(BigInteger.valueOf(order));
        if (buildFrom.getCodingFormat() != null) {
            TextFormatType textFormatType = TextFormatType.Factory.newInstance();
            this.populateTextFormatType(textFormatType, buildFrom.getCodingFormat());
            builtObj.setCodingType(textFormatType);
        }
        if (buildFrom.hasChild()) {
            this.buildList(hierarchyType, buildFrom.getChildLevel(), ++order);
        }
    }
}

