/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2;

import org.sdmx.resources.sdmxml.schemas.v20.registry.DataProviderRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.DataflowRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.MetadataflowRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.ProvisionAgreementType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.AbstractBuilder;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.stereotype.Service;

@Service(value="ProvisionAgreementXmlBeanBuilderV2")
public class ProvisionAgreementXmlBeanBuilder
extends AbstractBuilder {
    public static ProvisionAgreementXmlBeanBuilder INSTANCE = new ProvisionAgreementXmlBeanBuilder();

    private ProvisionAgreementXmlBeanBuilder() {
    }

    public ProvisionAgreementType build(ProvisionAgreementBean buildFrom) throws SdmxException {
        ProvisionAgreementType builtObj = ProvisionAgreementType.Factory.newInstance();
        if (ObjectUtil.validString(buildFrom.getId())) {
            builtObj.setId(buildFrom.getId());
        }
        if (buildFrom.getUri() != null) {
            builtObj.setUri(buildFrom.getUri().toString());
        } else if (buildFrom.getStructureURL() != null) {
            builtObj.setUri(buildFrom.getStructureURL().toString());
        } else if (buildFrom.getServiceURL() != null) {
            builtObj.setUri(buildFrom.getStructureURL().toString());
        }
        if (ObjectUtil.validString(buildFrom.getUrn())) {
            builtObj.setUrn(buildFrom.getUrn());
        }
        if (this.validCollection(buildFrom.getNames())) {
            builtObj.setNameArray(this.getTextType(buildFrom.getNames()));
        }
        if (this.validCollection(buildFrom.getDescriptions())) {
            builtObj.setDescriptionArray(this.getTextType(buildFrom.getDescriptions()));
        }
        if (this.hasAnnotations(buildFrom)) {
            builtObj.setAnnotations(this.getAnnotationsType(buildFrom));
        }
        if (buildFrom.getStructureUseage() != null) {
            if (buildFrom.getStructureUseage().getTargetReference() == SDMX_STRUCTURE_TYPE.DATAFLOW) {
                DataflowRefType dfRef = builtObj.addNewDataflowRef();
                this.populateDataflowRef(buildFrom.getStructureUseage(), dfRef);
            } else if (buildFrom.getStructureUseage().getTargetReference() == SDMX_STRUCTURE_TYPE.METADATA_FLOW) {
                MetadataflowRefType mdRef = builtObj.addNewMetadataflowRef();
                this.populateMetadataflowRef(buildFrom.getStructureUseage(), mdRef);
            }
        }
        if (buildFrom.getDataproviderRef() != null) {
            DataProviderRefType dpRef = builtObj.addNewDataProviderRef();
            this.populateDataproviderRef(buildFrom.getDataproviderRef(), dpRef);
        }
        return builtObj;
    }
}

