/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21;

import org.sdmx.resources.sdmxml.schemas.v21.common.ComponentValueSetType;
import org.sdmx.resources.sdmxml.schemas.v21.common.ContentConstraintTypeCodeType;
import org.sdmx.resources.sdmxml.schemas.v21.common.CubeRegionType;
import org.sdmx.resources.sdmxml.schemas.v21.common.MetadataTargetRegionType;
import org.sdmx.resources.sdmxml.schemas.v21.common.ReferencePeriodType;
import org.sdmx.resources.sdmxml.schemas.v21.common.SetReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.SimpleValueType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ContentConstraintType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ReleaseCalendarType;
import org.sdmxsource.sdmx.api.builder.Builder;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.beans.registry.ContentConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.CubeRegionBean;
import org.sdmxsource.sdmx.api.model.beans.registry.DataSetReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.KeyValues;
import org.sdmxsource.sdmx.api.model.beans.registry.MetadataTargetKeyValuesBean;
import org.sdmxsource.sdmx.api.model.beans.registry.MetadataTargetRegionBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ReferencePeriodBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ReleaseCalendarBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.ConstraintBeanAssembler;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.TimeRangeXmlAssembler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContentConstraintXmlBeanBuilder
extends ConstraintBeanAssembler
implements Builder<ContentConstraintType, ContentConstraintBean> {
    @Autowired
    private TimeRangeXmlAssembler timeRangeXmlAssembler;

    @Override
    public ContentConstraintType build(ContentConstraintBean buildFrom) throws SdmxException {
        ContentConstraintType returnType = ContentConstraintType.Factory.newInstance();
        super.assemble(returnType, buildFrom);
        if (buildFrom.isDefiningActualDataPresent()) {
            returnType.setType(ContentConstraintTypeCodeType.ACTUAL);
        } else {
            returnType.setType(ContentConstraintTypeCodeType.ALLOWED);
        }
        if (buildFrom.getIncludedCubeRegion() != null) {
            this.buildCubeRegion(returnType.addNewCubeRegion(), buildFrom.getIncludedCubeRegion(), true);
        }
        if (buildFrom.getExcludedCubeRegion() != null) {
            this.buildCubeRegion(returnType.addNewCubeRegion(), buildFrom.getExcludedCubeRegion(), false);
        }
        if (buildFrom.getReleaseCalendar() != null) {
            ReleaseCalendarBean calBean = buildFrom.getReleaseCalendar();
            ReleaseCalendarType calType = returnType.addNewReleaseCalendar();
            calType.setOffset(calBean.getOffset());
            calType.setPeriodicity(calBean.getPeriodicity());
            calType.setTolerance(calBean.getTolerance());
        }
        if (buildFrom.getReferencePeriod() != null) {
            ReferencePeriodBean refPeriodBean = buildFrom.getReferencePeriod();
            ReferencePeriodType refPeriodType = returnType.addNewReferencePeriod();
            if (refPeriodBean.getStartTime() != null) {
                refPeriodType.setStartTime(refPeriodBean.getStartTime().getDateAsCalendar());
            }
            if (refPeriodBean.getEndTime() != null) {
                refPeriodType.setEndTime(refPeriodBean.getEndTime().getDateAsCalendar());
            }
        }
        if (buildFrom.getMetadataTargetRegion() != null) {
            MetadataTargetRegionType mtRegionType = returnType.addNewMetadataTargetRegion();
            MetadataTargetRegionBean mtRegionBean = buildFrom.getMetadataTargetRegion();
            this.buildMetadataTargetRegion(mtRegionType, mtRegionBean);
        }
        return returnType;
    }

    private void buildMetadataTargetRegion(MetadataTargetRegionType mtRegionType, MetadataTargetRegionBean mtRegionBean) {
        mtRegionType.setInclude(mtRegionBean.isInclude());
        mtRegionType.setReport(mtRegionBean.getReport());
        mtRegionType.setMetadataTarget(mtRegionBean.getMetadataTarget());
        for (KeyValues keyValues : mtRegionBean.getAttributes()) {
            this.buildKeyValues(mtRegionType.addNewAttribute(), keyValues);
        }
        for (MetadataTargetKeyValuesBean metadataTargetKeyValuesBean : mtRegionBean.getKey()) {
            ComponentValueSetType cvst = mtRegionType.addNewKeyValue();
            this.buildKeyValues(cvst, metadataTargetKeyValuesBean);
            for (DataSetReferenceBean dsRef : metadataTargetKeyValuesBean.getDatasetReferences()) {
                SetReferenceType dsRefType = cvst.addNewDataSet();
                dsRefType.setID(dsRef.getDatasetId());
                super.setReference(dsRefType.addNewDataProvider().addNewRef(), dsRef.getDataProviderReference());
            }
        }
    }

    private void buildCubeRegion(CubeRegionType cubeRegionType, CubeRegionBean cubeRegionBean, boolean isIncluded) {
        cubeRegionType.setInclude(isIncluded);
        for (KeyValues currentKv : cubeRegionBean.getKeyValues()) {
            ComponentValueSetType cvst = cubeRegionType.addNewKeyValue();
            cvst.setId(currentKv.getId());
            if (currentKv.getTimeRange() != null) {
                this.timeRangeXmlAssembler.assemble(cvst.addNewTimeRange(), currentKv.getTimeRange());
            }
            for (String value : currentKv.getValues()) {
                SimpleValueType simpleValueType = cvst.addNewValue();
                simpleValueType.setStringValue(value);
                if (!currentKv.isCascadeValue(value)) continue;
                simpleValueType.setCascadeValues(true);
            }
        }
        for (KeyValues currentKv : cubeRegionBean.getAttributeValues()) {
            this.buildKeyValues(cubeRegionType.addNewAttribute(), currentKv);
        }
    }

    private void buildKeyValues(ComponentValueSetType cvst, KeyValues keyValues) {
        cvst.setId(keyValues.getId());
        if (keyValues.getTimeRange() != null) {
            this.timeRangeXmlAssembler.assemble(cvst.addNewTimeRange(), keyValues.getTimeRange());
        }
        for (String value : keyValues.getValues()) {
            SimpleValueType simpleValueType = cvst.addNewValue();
            simpleValueType.setStringValue(value);
            if (!keyValues.isCascadeValue(value)) continue;
            simpleValueType.setCascadeValues(true);
        }
    }
}

