/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21;

import java.util.Map;
import org.sdmx.resources.sdmxml.schemas.v21.common.ObjectTypeCodelistType;
import org.sdmx.resources.sdmxml.schemas.v21.common.PackageTypeCodelistType;
import org.sdmx.resources.sdmxml.schemas.v21.common.RefBaseType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ComponentMapType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.RepresentationMapType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.StructureMapType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ValueMapType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ValueMappingType;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.beans.mapping.ComponentMapBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.RepresentationMapRefBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.StructureMapBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.Assembler;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.NameableBeanAssembler;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.TextFormatAssembler;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.ToValueTypeTypeBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StructureMapBeanAssembler
extends NameableBeanAssembler
implements Assembler<StructureMapType, StructureMapBean> {
    @Autowired
    private TextFormatAssembler textFormatAssembler;
    @Autowired
    private ToValueTypeTypeBuilder toValueTypeTypeBuilder;

    protected void setComponentReference(RefBaseType ref, String partialReference) {
        ref.setId(partialReference);
        ref.setContainerID("DIMENSION_LIST");
        ref.setPackage(PackageTypeCodelistType.DATASTRUCTURE);
        ref.setClass1(ObjectTypeCodelistType.DIMENSION);
    }

    @Override
    public void assemble(StructureMapType assembleInto, StructureMapBean assembleFrom) throws SdmxException {
        this.assembleNameable(assembleInto, assembleFrom);
        assembleInto.setIsExtension(assembleFrom.isExtension());
        super.setReference(assembleInto.addNewSource().addNewRef(), assembleFrom.getSourceRef());
        super.setReference(assembleInto.addNewTarget().addNewRef(), assembleFrom.getTargetRef());
        for (ComponentMapBean eachMapBean : assembleFrom.getComponents()) {
            ComponentMapType newMap = assembleInto.addNewComponentMap();
            this.setComponentReference(newMap.addNewSource().addNewRef(), eachMapBean.getMapConceptRef());
            this.setComponentReference(newMap.addNewTarget().addNewRef(), eachMapBean.getMapTargetConceptRef());
            if (eachMapBean.getRepMapRef() == null) continue;
            RepresentationMapRefBean repMapRef = eachMapBean.getRepMapRef();
            RepresentationMapType repMap = newMap.addNewRepresentationMapping();
            if (repMapRef.getCodelistMap() != null) {
                RefBaseType codelistRef = repMap.addNewCodelistMap().addNewRef();
                codelistRef.setId(repMapRef.getCodelistMap().getChildReference().getId());
            }
            if (repMapRef.getToTextFormat() != null) {
                this.textFormatAssembler.assemble(repMap.addNewToTextFormat(), repMapRef.getToTextFormat());
            }
            if (repMapRef.getToValueType() != null) {
                repMap.setToValueType(this.toValueTypeTypeBuilder.build(repMapRef.getToValueType()));
            }
            if (repMapRef.getValueMappings().size() <= 0) continue;
            ValueMapType vmt = repMap.addNewValueMap();
            Map<String, String> valueMappings = repMapRef.getValueMappings();
            for (String currentKey : valueMappings.keySet()) {
                ValueMappingType vMappingType = vmt.addNewValueMapping();
                vMappingType.setSource(currentKey);
                vMappingType.setTarget(valueMappings.get(currentKey));
            }
        }
    }
}

