/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers;

import org.sdmx.resources.sdmxml.schemas.v21.common.CodeReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.LocalCodeReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.LocalLevelReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.RefBaseType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.HierarchicalCodeType;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodeBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.Assembler;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.IdentifiableBeanAssembler;
import org.springframework.stereotype.Service;

@Service
public class HierarchicalCodeBeanAssember
extends IdentifiableBeanAssembler
implements Assembler<HierarchicalCodeType, HierarchicalCodeBean> {
    @Override
    public void assemble(HierarchicalCodeType assembleInto, HierarchicalCodeBean assembleFrom) throws SdmxException {
        this.assembleIdentifiable(assembleInto, assembleFrom);
        if (assembleFrom.getCodelistAliasRef() != null) {
            assembleInto.setCodelistAliasRef(assembleFrom.getCodelistAliasRef());
            LocalCodeReferenceType localRef = assembleInto.addNewCodeID();
            RefBaseType ref = localRef.addNewRef();
            ref.setId(assembleFrom.getCodeId());
        } else {
            CrossReferenceBean crossReference = assembleFrom.getCodeReference();
            CodeReferenceType code = assembleInto.addNewCode();
            this.setReference(code.addNewRef(), crossReference);
        }
        if (assembleFrom.getLevel(false) != null) {
            LocalLevelReferenceType ref = assembleInto.addNewLevel();
            ref.addNewRef().setId(assembleFrom.getLevel(false).getFullIdPath(false));
        }
        for (HierarchicalCodeBean eachCodeRefBean : assembleFrom.getCodeRefs()) {
            HierarchicalCodeType eachHierarchicalCode = assembleInto.addNewHierarchicalCode();
            this.assemble(eachHierarchicalCode, eachCodeRefBean);
        }
    }
}

