/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers;

import org.sdmx.resources.sdmxml.schemas.v21.structure.ContactType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.OrganisationType;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.beans.base.ContactBean;
import org.sdmxsource.sdmx.api.model.beans.base.OrganisationBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.AbstractBeanAssembler;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.Assembler;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.stereotype.Service;

@Service
public class OrganisationXmlAssembler
extends AbstractBeanAssembler
implements Assembler<OrganisationType, OrganisationBean> {
    @Override
    public void assemble(OrganisationType assembleInto, OrganisationBean assembleFrom) throws SdmxException {
        for (ContactBean currentContact : assembleFrom.getContacts()) {
            ContactType contact = assembleInto.addNewContact();
            if (ObjectUtil.validString(currentContact.getId())) {
                contact.setId(currentContact.getId());
            }
            if (ObjectUtil.validCollection(currentContact.getDepartments())) {
                contact.setDepartmentArray(this.getTextType(currentContact.getDepartments()));
            }
            if (ObjectUtil.validCollection(currentContact.getName())) {
                contact.setNameArray(this.getTextType(currentContact.getName()));
            }
            if (ObjectUtil.validCollection(currentContact.getRole())) {
                contact.setRoleArray(this.getTextType(currentContact.getRole()));
            }
            if (ObjectUtil.validCollection(currentContact.getTelephone())) {
                contact.getTelephoneList().addAll(currentContact.getTelephone());
            }
            if (ObjectUtil.validCollection(currentContact.getFax())) {
                contact.getFaxList().addAll(currentContact.getFax());
            }
            if (ObjectUtil.validCollection(currentContact.getEmail())) {
                contact.getEmailList().addAll(currentContact.getEmail());
            }
            if (ObjectUtil.validCollection(currentContact.getUri())) {
                contact.getURIList().addAll(currentContact.getUri());
            }
            if (!ObjectUtil.validCollection(currentContact.getX400())) continue;
            contact.getX400List().addAll(currentContact.getX400());
        }
    }
}

