/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.rid;

import java.util.Collection;
import org.sdmx.resources.sdmxml.schemas.v21.common.ActionType;
import org.sdmx.resources.sdmxml.schemas.v21.message.RegistryInterfaceDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.RegistryInterfaceType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.SubmitSubscriptionsRequestType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.SubscriptionRequestType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.SubscriptionType;
import org.sdmxsource.sdmx.api.constants.DATASET_ACTION;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.beans.registry.SubscriptionBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v21.V2_1Helper;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.SubscriptionXmlBeanBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SubmitSubscriptionBuilder {
    @Autowired
    private SubscriptionXmlBeanBuilder subscriptionXmlBeanBuilder;

    public RegistryInterfaceDocument buildRegistryInterfaceDocument(Collection<SubscriptionBean> buildFrom, DATASET_ACTION action) throws SdmxException {
        RegistryInterfaceDocument rid = RegistryInterfaceDocument.Factory.newInstance();
        RegistryInterfaceType rit = rid.addNewRegistryInterface();
        V2_1Helper.setHeader(rit);
        SubmitSubscriptionsRequestType submitSubscriptionsRequest = rit.addNewSubmitSubscriptionsRequest();
        for (SubscriptionBean currentSubscription : buildFrom) {
            SubscriptionType subscriptionType = this.subscriptionXmlBeanBuilder.build(currentSubscription);
            SubscriptionRequestType subscriptionRequest = submitSubscriptionsRequest.addNewSubscriptionRequest();
            subscriptionRequest.setSubscription(subscriptionType);
            switch (action) {
                case APPEND: {
                    subscriptionRequest.setAction(ActionType.APPEND);
                    break;
                }
                case REPLACE: {
                    subscriptionRequest.setAction(ActionType.REPLACE);
                    break;
                }
                case DELETE: {
                    subscriptionRequest.setAction(ActionType.DELETE);
                    break;
                }
                case INFORMATION: {
                    subscriptionRequest.setAction(ActionType.INFORMATION);
                }
            }
        }
        return rid;
    }
}

