/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.engine.writing;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.xmlbeans.XmlObject;
import org.sdmxsource.sdmx.api.engine.ErrorWriterEngine;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.error.ErrorResponseBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ErrorWriterEngineV21
implements ErrorWriterEngine {
    @Autowired
    private ErrorResponseBuilder errorResponseBuilder;

    @Override
    public int writeError(Throwable th, OutputStream out) {
        XmlObject error;
        int statusCode;
        if (th instanceof SdmxException) {
            SdmxException ex = (SdmxException)th;
            statusCode = ex.getHttpRestErrorCode();
            error = this.errorResponseBuilder.buildErrorResponse(th, ex.getSdmxErrorCode().getClientErrorCode().toString());
        } else {
            th.printStackTrace(System.err);
            error = this.errorResponseBuilder.buildErrorResponse(th, "500");
            statusCode = 500;
        }
        try {
            error.save(out);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return statusCode;
    }
}

