/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.engine.writing;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.constants.SdmxConstants;
import org.sdmxsource.util.resourceBundle.PropertiesToMap;

public class SchemaLocationWriter {
    private Map<SDMX_SCHEMA, String> schemaLocationMap = new HashMap<SDMX_SCHEMA, String>();

    public void writeSchemaLocation(XmlObject doc, String ... namespaceUri) {
        if (namespaceUri == null) {
            return;
        }
        StringBuilder schemaLocation = new StringBuilder();
        String concat = "";
        String[] stringArray = namespaceUri;
        int n = namespaceUri.length;
        int n2 = 0;
        while (n2 < n) {
            String currentNamespaceUri = stringArray[n2];
            SDMX_SCHEMA schemaVersion = SdmxConstants.getSchemaVersion(currentNamespaceUri);
            String schemaBaseLocation = this.getSchemaLocation(schemaVersion);
            String schemaName = SdmxConstants.getSchemaName(currentNamespaceUri);
            schemaLocation.append(String.valueOf(concat) + currentNamespaceUri + " " + concat + schemaBaseLocation + schemaName);
            concat = System.getProperty("line.separator");
            ++n2;
        }
        XmlCursor cursor = doc.newCursor();
        if (cursor.toFirstChild()) {
            cursor.setAttributeText(new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation"), schemaLocation.toString());
        }
    }

    public String getSchemaLocation(SDMX_SCHEMA schemaVersion) {
        return this.schemaLocationMap.get((Object)schemaVersion);
    }

    public void setSchemaLocationProperties(Properties properties) {
        Map<String, String> propsMap = PropertiesToMap.createMap(properties);
        for (String schemaVersion : propsMap.keySet()) {
            this.schemaLocationMap.put(SDMX_SCHEMA.valueOf(schemaVersion), propsMap.get(schemaVersion));
        }
    }
}

