/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.factory;

import java.io.OutputStream;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.constants.STRUCTURE_OUTPUT_FORMAT;
import org.sdmxsource.sdmx.api.engine.StructureWriterEngine;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.factory.StructureWriterFactory;
import org.sdmxsource.sdmx.api.model.format.StructureFormat;
import org.sdmxsource.sdmx.structureparser.engine.writing.RegistryQueryResponseWritingEngineV2;
import org.sdmxsource.sdmx.structureparser.engine.writing.StructureWritingEngineEDI;
import org.sdmxsource.sdmx.structureparser.engine.writing.StructureWritingEngineV1;
import org.sdmxsource.sdmx.structureparser.engine.writing.StructureWritingEngineV2;
import org.sdmxsource.sdmx.structureparser.engine.writing.StructureWritingEngineV21;
import org.springframework.stereotype.Service;

@Service
public class SdmxStructureWriterFactory
implements StructureWriterFactory {
    @Override
    public StructureWriterEngine getStructureWriterEngine(StructureFormat sFormat, OutputStream out) {
        if (sFormat.getSdmxOutputFormat() != null) {
            STRUCTURE_OUTPUT_FORMAT outputFormat = sFormat.getSdmxOutputFormat();
            SDMX_SCHEMA schemaVersion = outputFormat.getOutputVersion();
            if (!outputFormat.isQueryResponse() && !outputFormat.isRegistryDocument()) {
                return this.getBeanEngine(schemaVersion, out);
            }
            if (outputFormat == STRUCTURE_OUTPUT_FORMAT.SDMX_V2_REGISTRY_QUERY_RESPONSE_DOCUMENT) {
                return new RegistryQueryResponseWritingEngineV2(out);
            }
        }
        return null;
    }

    private StructureWriterEngine getBeanEngine(SDMX_SCHEMA schemaVersion, OutputStream out) {
        switch (schemaVersion) {
            case VERSION_ONE: {
                return new StructureWritingEngineV1(out);
            }
            case VERSION_TWO: {
                return new StructureWritingEngineV2(out);
            }
            case EDI: {
                return new StructureWritingEngineEDI(out);
            }
            case VERSION_TWO_POINT_ONE: {
                return new StructureWritingEngineV21(out);
            }
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, (Object)((Object)schemaVersion) + " - StructureWritingManagerImpl.writeStructure");
    }
}

