/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.manager.parsing.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.sdmx.resources.sdmxml.schemas.v21.message.GenericDataQueryDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.GenericTimeSeriesDataQueryDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.StructureSpecificDataQueryDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.StructureSpecificTimeSeriesDataQueryDocument;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.QUERY_MESSAGE_TYPE;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.exception.SdmxSyntaxException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.data.query.DataQuery;
import org.sdmxsource.sdmx.api.model.data.query.complex.ComplexDataQuery;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.reference.RESTDataQueryImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.query.DataQueryImpl;
import org.sdmxsource.sdmx.structureparser.builder.query.DataQueryBuilder;
import org.sdmxsource.sdmx.structureparser.manager.parsing.DataQueryParseManager;
import org.sdmxsource.sdmx.util.sdmx.SdmxMessageUtil;
import org.sdmxsource.springutil.xml.XMLParser;
import org.sdmxsource.util.log.LoggingUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataQueryParseManagerImpl
implements DataQueryParseManager {
    private Logger log = Logger.getLogger(DataQueryParseManagerImpl.class);
    @Autowired
    private DataQueryBuilder dataQueryBuilder;

    @Override
    public DataQuery parseRESTQuery(String query, SdmxBeanRetrievalManager beanRetrievalManager) {
        if (!query.toLowerCase().startsWith("data/")) {
            throw new SdmxSemmanticException("Expecting REST Query for Data to start with 'data/'");
        }
        String[] split = query.split("\\?");
        String queryPrefix = split[0];
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        if (split.length > 1) {
            String[] queryPostFix = split[1].split("=");
            if (queryPostFix.length % 2 != 0) {
                throw new SdmxSemmanticException("Missing equals '=' in query parameters '" + split[1] + "'");
            }
            int i = 0;
            while (i < queryPostFix.length) {
                queryParameters.put(queryPostFix[i], queryPostFix[i + 1]);
                i += 2;
            }
        }
        RESTDataQueryImpl dataQuery = new RESTDataQueryImpl(queryPrefix.split("/"), queryParameters);
        return new DataQueryImpl(dataQuery, beanRetrievalManager);
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<DataQuery> buildDataQuery(ReadableDataLocation dataQueryLocation, SdmxBeanRetrievalManager beanRetrievalManager) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[SWITCH], 10[CASE]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<ComplexDataQuery> buildComplexDataQuery(ReadableDataLocation dataQueryLocation, SdmxBeanRetrievalManager beanRetrievalManager) {
        this.log.debug((Object)"DataParseManagerImpl.buildComplexDataQuery");
        InputStream stream = null;
        try {
            SDMX_SCHEMA schemaVersion = SdmxMessageUtil.getSchemaVersion(dataQueryLocation);
            LoggingUtil.debug(this.log, "Schema Version Determined to be : " + (Object)((Object)schemaVersion));
            XMLParser.validateXML(dataQueryLocation, schemaVersion, new ReadableDataLocation[0]);
            stream = dataQueryLocation.getInputStream();
            switch (schemaVersion) {
                case VERSION_ONE: {
                    throw new IllegalArgumentException("Build Complex Data Query concerns sdmx messages of schema version 2.1 ");
                }
                case VERSION_TWO: {
                    throw new IllegalArgumentException("Build Complex Data Query concerns sdmx messages of schema version 2.1 ");
                }
                case VERSION_TWO_POINT_ONE: {
                    List<QUERY_MESSAGE_TYPE> queryMessageTypes = SdmxMessageUtil.getQueryMessageTypes(dataQueryLocation);
                    QUERY_MESSAGE_TYPE queryMessageType = queryMessageTypes.get(0);
                    if (queryMessageType.equals((Object)QUERY_MESSAGE_TYPE.GENERIC_DATA_QUERY)) {
                        GenericDataQueryDocument queryV21 = GenericDataQueryDocument.Factory.parse(stream);
                        List<ComplexDataQuery> list = this.dataQueryBuilder.buildComplexDataQuery(queryV21.getGenericDataQuery().getQuery(), beanRetrievalManager);
                        return list;
                    }
                    if (queryMessageType.equals((Object)QUERY_MESSAGE_TYPE.GENERIC_TIME_SERIES_DATA_QUERY)) {
                        GenericTimeSeriesDataQueryDocument queryV21 = GenericTimeSeriesDataQueryDocument.Factory.parse(stream);
                        List<ComplexDataQuery> list = this.dataQueryBuilder.buildComplexDataQuery(queryV21.getGenericTimeSeriesDataQuery().getQuery(), beanRetrievalManager);
                        return list;
                    }
                    if (queryMessageType.equals((Object)QUERY_MESSAGE_TYPE.STRUCTURE_SPECIFIC_DATA_QUERY)) {
                        StructureSpecificDataQueryDocument queryV21 = StructureSpecificDataQueryDocument.Factory.parse(stream);
                        List<ComplexDataQuery> list = this.dataQueryBuilder.buildComplexDataQuery(queryV21.getStructureSpecificDataQuery().getQuery(), beanRetrievalManager);
                        return list;
                    }
                    if (!queryMessageType.equals((Object)QUERY_MESSAGE_TYPE.STRUCTURE_SPECIFIC_TIME_SERIES_DATA_QUERY)) break;
                    StructureSpecificTimeSeriesDataQueryDocument queryV21 = StructureSpecificTimeSeriesDataQueryDocument.Factory.parse(stream);
                    List<ComplexDataQuery> list = this.dataQueryBuilder.buildComplexDataQuery(queryV21.getStructureSpecificTimeSeriesDataQuery().getQuery(), beanRetrievalManager);
                    return list;
                }
            }
            try {
                throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "buildComplexDataQuery in version " + (Object)((Object)schemaVersion));
            }
            catch (XmlException e) {
                throw new SdmxSyntaxException(e);
            }
            catch (IOException e) {
                throw new SdmxException(e, "I/O error occured whilst trying to build data query from SDMX message");
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

