/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.manager.parsing.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.message.QueryMessageDocument;
import org.sdmx.resources.sdmxml.schemas.v20.message.QueryMessageDocument;
import org.sdmx.resources.sdmxml.schemas.v20.message.RegistryInterfaceDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.CategorisationQueryDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.CategorySchemeQueryDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.CodelistQueryDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.ConceptSchemeQueryDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.ConstraintQueryDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.DataStructureQueryDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.DataflowQueryDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.HierarchicalCodelistQueryDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.MetadataStructureQueryDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.MetadataflowQueryDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.OrganisationSchemeQueryDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.ProcessQueryDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.ProvisionAgreementQueryDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.RegistryInterfaceDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.ReportingTaxonomyQueryDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.StructureSetQueryDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.StructuresQueryDocument;
import org.sdmxsource.sdmx.api.constants.DATASET_ACTION;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.MESSAGE_TYPE;
import org.sdmxsource.sdmx.api.constants.QUERY_MESSAGE_TYPE;
import org.sdmxsource.sdmx.api.constants.REGISTRY_MESSAGE_TYPE;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.complex.ComplexStructureQuery;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.structureparser.builder.query.QueryBeanBuilder;
import org.sdmxsource.sdmx.structureparser.manager.parsing.QueryParsingManager;
import org.sdmxsource.sdmx.structureparser.workspace.QueryWorkspace;
import org.sdmxsource.sdmx.structureparser.workspace.impl.QueryWorkspaceImpl;
import org.sdmxsource.sdmx.util.exception.ParseException;
import org.sdmxsource.sdmx.util.sdmx.SdmxMessageUtil;
import org.sdmxsource.springutil.xml.XMLParser;
import org.sdmxsource.util.log.LoggingUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryParsingManagerImpl
implements QueryParsingManager {
    private Logger log = Logger.getLogger(QueryParsingManagerImpl.class);
    @Autowired
    private QueryBeanBuilder queryBeanBuilder;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public QueryWorkspace parseQueries(ReadableDataLocation dataLocation) throws ParseException {
        MESSAGE_TYPE messageType;
        InputStream stream;
        block23: {
            LoggingUtil.debug(this.log, "Parse Structure request, for xml at location: " + dataLocation.toString());
            stream = null;
            try {
                SDMX_SCHEMA schemaVersion = SdmxMessageUtil.getSchemaVersion(dataLocation);
                LoggingUtil.debug(this.log, "Schema Version Determined to be : " + (Object)((Object)schemaVersion));
                XMLParser.validateXML(dataLocation, schemaVersion, new ReadableDataLocation[0]);
                LoggingUtil.debug(this.log, "XML VALID");
                stream = dataLocation.getInputStream();
                messageType = SdmxMessageUtil.getMessageType(dataLocation);
                if (schemaVersion == SDMX_SCHEMA.VERSION_ONE || schemaVersion == SDMX_SCHEMA.VERSION_TWO) {
                    if (messageType == MESSAGE_TYPE.QUERY) {
                        QueryWorkspace queryWorkspace = this.processQueryMessage(stream, schemaVersion);
                        return queryWorkspace;
                    }
                    if (messageType != MESSAGE_TYPE.REGISTRY_INTERFACE) throw new IllegalArgumentException("Expecting a message type " + (Object)((Object)MESSAGE_TYPE.QUERY) + ". Got a " + (Object)((Object)messageType));
                    REGISTRY_MESSAGE_TYPE registryMessageType = SdmxMessageUtil.getRegistryMessageType(dataLocation);
                    if (!registryMessageType.isQueryRequest()) {
                        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "Expected query message - type found : " + (Object)((Object)registryMessageType));
                    }
                    try {
                        QueryWorkspace queryWorkspace = this.processRegistryQueryMessage(stream, schemaVersion, registryMessageType);
                        return queryWorkspace;
                    }
                    catch (Throwable th) {
                        throw new ParseException(th, DATASET_ACTION.INFORMATION, false, registryMessageType.getArtifactType(), new Object[0]);
                    }
                }
                if (schemaVersion == SDMX_SCHEMA.VERSION_TWO_POINT_ONE) break block23;
                throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{schemaVersion});
            }
            catch (XmlException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        List<QUERY_MESSAGE_TYPE> queryMessageTypes = SdmxMessageUtil.getQueryMessageTypes(dataLocation);
        QUERY_MESSAGE_TYPE queryMessageType = queryMessageTypes.get(0);
        if (messageType == MESSAGE_TYPE.QUERY) return this.processQueryMessage(stream, queryMessageType);
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "Not a structure query message:" + (Object)((Object)queryMessageType));
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private QueryWorkspace processQueryMessage(InputStream is, QUERY_MESSAGE_TYPE queryMessageType) throws XmlException, IOException {
        ComplexStructureQuery complexQuery = null;
        switch (queryMessageType) {
            case STRUCTURES_WHERE: {
                StructuresQueryDocument structuresQueryDocument = StructuresQueryDocument.Factory.parse(is);
                complexQuery = this.queryBeanBuilder.build(structuresQueryDocument.getStructuresQuery());
                break;
            }
            case DATAFLOW_WHERE: {
                DataflowQueryDocument dataflowQueryDocument = DataflowQueryDocument.Factory.parse(is);
                complexQuery = this.queryBeanBuilder.build(dataflowQueryDocument.getDataflowQuery());
                break;
            }
            case METADATAFLOW_WHERE: {
                MetadataflowQueryDocument metadataflowQueryDocument = MetadataflowQueryDocument.Factory.parse(is);
                complexQuery = this.queryBeanBuilder.build(metadataflowQueryDocument.getMetadataflowQuery());
                break;
            }
            case DSD_WHERE: {
                DataStructureQueryDocument dataStructureQueryDocument = DataStructureQueryDocument.Factory.parse(is);
                complexQuery = this.queryBeanBuilder.build(dataStructureQueryDocument.getDataStructureQuery());
                break;
            }
            case MDS_WHERE: {
                MetadataStructureQueryDocument metadataStructureQueryDocument = MetadataStructureQueryDocument.Factory.parse(is);
                complexQuery = this.queryBeanBuilder.build(metadataStructureQueryDocument.getMetadataStructureQuery());
                break;
            }
            case CATEGORY_SCHEME_WHERE: {
                CategorySchemeQueryDocument categorySchemeQueryDocument = CategorySchemeQueryDocument.Factory.parse(is);
                complexQuery = this.queryBeanBuilder.build(categorySchemeQueryDocument.getCategorySchemeQuery());
                break;
            }
            case CONCEPT_SCHEME_WHERE: {
                ConceptSchemeQueryDocument conceptSchemeQueryDocument = ConceptSchemeQueryDocument.Factory.parse(is);
                complexQuery = this.queryBeanBuilder.build(conceptSchemeQueryDocument.getConceptSchemeQuery());
                break;
            }
            case CODELIST_WHERE: {
                CodelistQueryDocument codelistQueryDocument = CodelistQueryDocument.Factory.parse(is);
                complexQuery = this.queryBeanBuilder.build(codelistQueryDocument.getCodelistQuery());
                break;
            }
            case HCL_WHERE: {
                HierarchicalCodelistQueryDocument hierarchicalCodelistQueryDocument = HierarchicalCodelistQueryDocument.Factory.parse(is);
                complexQuery = this.queryBeanBuilder.build(hierarchicalCodelistQueryDocument.getHierarchicalCodelistQuery());
                break;
            }
            case ORGANISATION_SCHEME_WHERE: {
                OrganisationSchemeQueryDocument organisationSchemeQueryDocument = OrganisationSchemeQueryDocument.Factory.parse(is);
                complexQuery = this.queryBeanBuilder.build(organisationSchemeQueryDocument.getOrganisationSchemeQuery());
                break;
            }
            case REPORTING_TAXONOMY_WHERE: {
                ReportingTaxonomyQueryDocument reportingTaxonomyQueryDocument = ReportingTaxonomyQueryDocument.Factory.parse(is);
                complexQuery = this.queryBeanBuilder.build(reportingTaxonomyQueryDocument.getReportingTaxonomyQuery());
                break;
            }
            case STRUCTURE_SET_WHERE: {
                StructureSetQueryDocument structureSetQueryDocument = StructureSetQueryDocument.Factory.parse(is);
                complexQuery = this.queryBeanBuilder.build(structureSetQueryDocument.getStructureSetQuery());
                break;
            }
            case PROCESS_WHERE: {
                ProcessQueryDocument processQueryDocument = ProcessQueryDocument.Factory.parse(is);
                complexQuery = this.queryBeanBuilder.build(processQueryDocument.getProcessQuery());
                break;
            }
            case CATEGORISATION_WHERE: {
                CategorisationQueryDocument categorisationQueryDocument = CategorisationQueryDocument.Factory.parse(is);
                complexQuery = this.queryBeanBuilder.build(categorisationQueryDocument.getCategorisationQuery());
                break;
            }
            case PROVISION_AGREEMENT_WHERE: {
                ProvisionAgreementQueryDocument provisionAgreementQueryDocument = ProvisionAgreementQueryDocument.Factory.parse(is);
                complexQuery = this.queryBeanBuilder.build(provisionAgreementQueryDocument.getProvisionAgreementQuery());
                break;
            }
            case CONSTRAINT_WHERE: {
                ConstraintQueryDocument constraintQueryDocument = ConstraintQueryDocument.Factory.parse(is);
                complexQuery = this.queryBeanBuilder.build(constraintQueryDocument.getConstraintQuery());
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a structure query message:" + (Object)((Object)queryMessageType));
            }
        }
        return new QueryWorkspaceImpl(complexQuery);
    }

    private QueryWorkspace processQueryMessage(InputStream is, SDMX_SCHEMA schemaVersion) throws IOException, XmlException {
        List<StructureReferenceBean> structureReferences = null;
        switch (schemaVersion) {
            case VERSION_ONE: {
                org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.message.QueryMessageDocument docV1 = QueryMessageDocument.Factory.parse(is);
                structureReferences = this.queryBeanBuilder.build(docV1.getQueryMessage());
                break;
            }
            case VERSION_TWO: {
                QueryMessageDocument docV2 = QueryMessageDocument.Factory.parse(is);
                structureReferences = this.queryBeanBuilder.build(docV2.getQueryMessage());
                break;
            }
            default: {
                throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{schemaVersion});
            }
        }
        return new QueryWorkspaceImpl(null, null, structureReferences, false);
    }

    private QueryWorkspace processRegistryQueryMessage(InputStream is, SDMX_SCHEMA schemaVersion, REGISTRY_MESSAGE_TYPE registryMessageType) throws IOException, XmlException {
        switch (registryMessageType) {
            case QUERY_PROVISION_REQUEST: {
                return this.processRegistryQueryMessageForProvision(is, schemaVersion);
            }
            case QUERY_REGISTRATION_REQUEST: {
                return this.processRegistryQueryMessageForRegistration(is, schemaVersion);
            }
            case QUERY_STRUCTURE_REQUEST: {
                return this.processRegistryQueryMessageForStructures(is, schemaVersion);
            }
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{registryMessageType});
    }

    private QueryWorkspace processRegistryQueryMessageForStructures(InputStream is, SDMX_SCHEMA schemaVersion) throws IOException, XmlException {
        switch (schemaVersion) {
            case VERSION_TWO: {
                RegistryInterfaceDocument doc = RegistryInterfaceDocument.Factory.parse(is);
                List<StructureReferenceBean> structureReferences = this.queryBeanBuilder.build(doc.getRegistryInterface().getQueryStructureRequest());
                boolean resolveRefernces = doc.getRegistryInterface().getQueryStructureRequest().getResolveReferences();
                return new QueryWorkspaceImpl(null, null, structureReferences, resolveRefernces);
            }
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{schemaVersion});
    }

    private QueryWorkspace processRegistryQueryMessageForProvision(InputStream is, SDMX_SCHEMA schemaVersion) throws IOException, XmlException {
        switch (schemaVersion) {
            case VERSION_TWO: {
                RegistryInterfaceDocument doc = RegistryInterfaceDocument.Factory.parse(is);
                StructureReferenceBean provisionReferences = this.queryBeanBuilder.build(doc.getRegistryInterface().getQueryProvisioningRequest());
                return new QueryWorkspaceImpl(provisionReferences, null, null, false);
            }
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{schemaVersion});
    }

    private QueryWorkspace processRegistryQueryMessageForRegistration(InputStream is, SDMX_SCHEMA schemaVersion) throws IOException, XmlException {
        StructureReferenceBean registrationReferences = null;
        switch (schemaVersion) {
            case VERSION_TWO: {
                RegistryInterfaceDocument doc = RegistryInterfaceDocument.Factory.parse(is);
                registrationReferences = this.queryBeanBuilder.build(doc.getRegistryInterface().getQueryRegistrationRequest());
                break;
            }
            case VERSION_TWO_POINT_ONE: {
                org.sdmx.resources.sdmxml.schemas.v21.message.RegistryInterfaceDocument doc2_1 = RegistryInterfaceDocument.Factory.parse(is);
                registrationReferences = this.queryBeanBuilder.build(doc2_1.getRegistryInterface().getQueryRegistrationRequest());
                break;
            }
            default: {
                throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{schemaVersion});
            }
        }
        return new QueryWorkspaceImpl(null, registrationReferences, null, false);
    }
}

