/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.manager.parsing.impl;

import java.io.ByteArrayOutputStream;
import org.sdmxsource.sdmx.api.constants.STRUCTURE_OUTPUT_FORMAT;
import org.sdmxsource.sdmx.api.factory.ReadableDataLocationFactory;
import org.sdmxsource.sdmx.api.manager.output.StructureWriterManager;
import org.sdmxsource.sdmx.api.manager.parse.StructureParsingManager;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.sdmxbeans.model.SdmxStructureFormat;
import org.sdmxsource.sdmx.structureparser.manager.parsing.StructureValidationManager;
import org.sdmxsource.util.io.StreamUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StructureValidationManagerImpl
implements StructureValidationManager {
    @Autowired
    private StructureParsingManager structureParsingManager;
    @Autowired
    private StructureWriterManager structureWritingManager;
    @Autowired
    private ReadableDataLocationFactory readableDataLocationFactory;

    @Override
    public void validateStructure(MaintainableBean maintainableBean) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.structureWritingManager.writeStructure(maintainableBean, null, new SdmxStructureFormat(STRUCTURE_OUTPUT_FORMAT.SDMX_V21_STRUCTURE_DOCUMENT), out);
        ReadableDataLocation dataLocation = this.readableDataLocationFactory.getReadableDataLocation(out.toByteArray());
        try {
            this.structureParsingManager.parseStructures(dataLocation);
        }
        catch (Throwable throwable) {
            dataLocation.close();
            StreamUtil.closeStream(out);
            throw throwable;
        }
        dataLocation.close();
        StreamUtil.closeStream(out);
    }
}

