/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.manager.parsing.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v21.message.RegistryInterfaceDocument;
import org.sdmx.resources.sdmxml.schemas.v21.registry.SubmitSubscriptionsRequestType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.model.beans.registry.SubscriptionBean;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.structureparser.builder.subscriptionbeans.SubscriptionBeansBuilder;
import org.sdmxsource.sdmx.structureparser.manager.parsing.SubscriptionParsingManager;
import org.sdmxsource.sdmx.util.sdmx.SdmxMessageUtil;
import org.sdmxsource.springutil.xml.XMLParser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SubscriptionParsingManagerImpl
implements SubscriptionParsingManager {
    @Autowired
    private SubscriptionBeansBuilder subscriptionBeansBuilder;

    @Override
    public List<SubscriptionBean> parseSubscriptionXML(ReadableDataLocation dataLocation) {
        SDMX_SCHEMA schemaVersion = SdmxMessageUtil.getSchemaVersion(dataLocation);
        XMLParser.validateXML(dataLocation, schemaVersion, new ReadableDataLocation[0]);
        InputStream stream = dataLocation.getInputStream();
        try {
            List<SubscriptionBean> returnList = new ArrayList<SubscriptionBean>();
            switch (schemaVersion) {
                case VERSION_TWO_POINT_ONE: {
                    RegistryInterfaceDocument rid = RegistryInterfaceDocument.Factory.parse(stream);
                    if (rid.getRegistryInterface().getSubmitSubscriptionsRequest() == null || rid.getRegistryInterface().getSubmitSubscriptionsRequest().getSubscriptionRequestList() == null) break;
                    SubmitSubscriptionsRequestType subscritpionRequestType = rid.getRegistryInterface().getSubmitSubscriptionsRequest();
                    returnList = (List)this.subscriptionBeansBuilder.build(subscritpionRequestType);
                    break;
                }
                default: {
                    throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "Subscription in version : " + schemaVersion.toString());
                }
            }
            ArrayList<SubscriptionBean> arrayList = returnList;
            return arrayList;
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

