/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureretrieval.manager;

import java.util.Set;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.exception.CrossReferenceException;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.base.AgencyBean;
import org.sdmxsource.sdmx.api.model.beans.base.AgencySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataConsumerSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.OrganisationUnitSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorisationBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.ReportingTaxonomyBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.StructureSetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataFlowBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataStructureDefinitionBean;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.AttachmentConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ContentConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.util.beans.MaintainableUtil;

public abstract class BaseSdmxBeanRetrievalManager
implements SdmxBeanRetrievalManager {
    private SdmxBeanRetrievalManager proxy;

    @Override
    public MaintainableBean getMaintainable(StructureReferenceBean query, boolean returnStub) throws CrossReferenceException {
        MaintainableRefBean ref = query.getMaintainableReference();
        switch (query.getMaintainableStructureType()) {
            case AGENCY_SCHEME: {
                return this.getAgencySchemeBean(ref, returnStub);
            }
            case ATTACHMENT_CONSTRAINT: {
                return this.getAttachmentConstraint(ref, returnStub);
            }
            case CONTENT_CONSTRAINT: {
                return this.getContentConstraint(ref, returnStub);
            }
            case DATA_CONSUMER_SCHEME: {
                return this.getDataConsumerSchemeBean(ref, returnStub);
            }
            case DATA_PROVIDER_SCHEME: {
                return this.getDataProviderSchemeBean(ref, returnStub);
            }
            case CATEGORISATION: {
                return this.getCategorisation(ref, returnStub);
            }
            case CATEGORY_SCHEME: {
                return this.getCategoryScheme(ref, returnStub);
            }
            case CODE_LIST: {
                return this.getCodelist(ref, returnStub);
            }
            case CONCEPT_SCHEME: {
                return this.getConceptScheme(ref, returnStub);
            }
            case DATAFLOW: {
                return this.getDataflow(ref, returnStub);
            }
            case HIERARCHICAL_CODELIST: {
                return this.getHierarchicCodeList(ref, returnStub);
            }
            case DSD: {
                return this.getDataStructure(ref, returnStub);
            }
            case METADATA_FLOW: {
                return this.getMetadataflow(ref, returnStub);
            }
            case MSD: {
                return this.getMetadataStructure(ref, returnStub);
            }
            case ORGANISATION_UNIT_SCHEME: {
                return this.getOrganisationUnitScheme(ref, returnStub);
            }
            case PROCESS: {
                return this.getProcessBean(ref, returnStub);
            }
            case REPORTING_TAXONOMY: {
                return this.getReportingTaxonomy(ref, returnStub);
            }
            case STRUCTURE_SET: {
                return this.getStructureSet(ref, returnStub);
            }
            case PROVISION_AGREEMENT: {
                return this.getProvisionAgreementBean(ref, returnStub);
            }
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{query.getTargetReference()});
    }

    public void setProxy(SdmxBeanRetrievalManager proxy) {
        this.proxy = proxy;
    }

    @Override
    public AgencyBean getAgency(String id) {
        for (AgencySchemeBean currentAgencySchemeBean : this.getAgencySchemeBeans(null, false)) {
            for (AgencyBean currentAgencyBean : currentAgencySchemeBean.getItems()) {
                if (!currentAgencyBean.getFullId().equals(id)) continue;
                return currentAgencyBean;
            }
        }
        return null;
    }

    @Override
    public AgencySchemeBean getAgencySchemeBean(MaintainableRefBean ref) {
        return this.getAgencySchemeBean(ref, false);
    }

    @Override
    public AttachmentConstraintBean getAttachmentConstraint(MaintainableRefBean ref) {
        return this.getAttachmentConstraint(ref, false);
    }

    @Override
    public CategorisationBean getCategorisation(MaintainableRefBean ref) {
        return this.getCategorisation(ref, false);
    }

    @Override
    public CodelistBean getCodelist(MaintainableRefBean ref) {
        return this.getCodelist(ref, false);
    }

    @Override
    public ConceptSchemeBean getConceptScheme(MaintainableRefBean ref) {
        return this.getConceptScheme(ref, false);
    }

    @Override
    public ContentConstraintBean getContentConstraint(MaintainableRefBean ref) {
        return this.getContentConstraint(ref, false);
    }

    @Override
    public CategorySchemeBean getCategoryScheme(MaintainableRefBean ref) {
        return this.getCategoryScheme(ref, false);
    }

    @Override
    public DataConsumerSchemeBean getDataConsumerSchemeBean(MaintainableRefBean ref) {
        return this.getDataConsumerSchemeBean(ref, false);
    }

    @Override
    public DataflowBean getDataflow(MaintainableRefBean ref) {
        return this.getDataflow(ref, false);
    }

    @Override
    public DataProviderSchemeBean getDataProviderSchemeBean(MaintainableRefBean ref) {
        return this.getDataProviderSchemeBean(ref, false);
    }

    @Override
    public HierarchicalCodelistBean getHierarchicCodeList(MaintainableRefBean ref) {
        return this.getHierarchicCodeList(ref, false);
    }

    @Override
    public MetadataFlowBean getMetadataflow(MaintainableRefBean ref) {
        return this.getMetadataflow(ref, false);
    }

    @Override
    public DataStructureBean getDataStructure(MaintainableRefBean ref) {
        return this.getDataStructure(ref, false);
    }

    @Override
    public MetadataStructureDefinitionBean getMetadataStructure(MaintainableRefBean ref) {
        return this.getMetadataStructure(ref, false);
    }

    @Override
    public OrganisationUnitSchemeBean getOrganisationUnitScheme(MaintainableRefBean ref) {
        return this.getOrganisationUnitScheme(ref, false);
    }

    @Override
    public ProcessBean getProcessBean(MaintainableRefBean ref) {
        return this.getProcessBean(ref, false);
    }

    @Override
    public ProvisionAgreementBean getProvisionAgreementBean(MaintainableRefBean ref) {
        return this.getProvisionAgreementBean(ref, false);
    }

    @Override
    public StructureSetBean getStructureSet(MaintainableRefBean ref) {
        return this.getStructureSet(ref, false);
    }

    @Override
    public ReportingTaxonomyBean getReportingTaxonomy(MaintainableRefBean ref) {
        return this.getReportingTaxonomy(ref, false);
    }

    @Override
    public Set<AttachmentConstraintBean> getAttachmentConstraints(MaintainableRefBean ref) {
        return this.getAttachmentConstraints(ref, false, false);
    }

    @Override
    public Set<CategorisationBean> getCategorisationBeans(MaintainableRefBean ref) {
        return this.getCategorisationBeans(ref, false);
    }

    @Override
    public Set<CodelistBean> getCodelistBeans(MaintainableRefBean ref) {
        return this.getCodelistBeans(ref, false, false);
    }

    @Override
    public Set<ConceptSchemeBean> getConceptSchemeBeans(MaintainableRefBean ref) {
        return this.getConceptSchemeBeans(ref, false, false);
    }

    @Override
    public Set<ContentConstraintBean> getContentConstraints(MaintainableRefBean ref) {
        return this.getContentConstraints(ref, false, false);
    }

    @Override
    public Set<CategorySchemeBean> getCategorySchemeBeans(MaintainableRefBean ref) {
        return this.getCategorySchemeBeans(ref, false, false);
    }

    @Override
    public Set<DataflowBean> getDataflowBeans(MaintainableRefBean ref) {
        return this.getDataflowBeans(ref, false, false);
    }

    @Override
    public Set<HierarchicalCodelistBean> getHierarchicCodeListBeans(MaintainableRefBean ref) {
        return this.getHierarchicCodeListBeans(ref, false, false);
    }

    @Override
    public Set<MetadataFlowBean> getMetadataflowBeans(MaintainableRefBean ref) {
        return this.getMetadataflowBeans(ref, false, false);
    }

    @Override
    public Set<DataStructureBean> getDataStructureBeans(MaintainableRefBean ref) {
        return this.getDataStructureBeans(ref, false, false);
    }

    @Override
    public Set<MetadataStructureDefinitionBean> getMetadataStructureBeans(MaintainableRefBean ref) {
        return this.getMetadataStructureBeans(ref, false, false);
    }

    @Override
    public Set<OrganisationUnitSchemeBean> getOrganisationUnitSchemeBeans(MaintainableRefBean ref) {
        return this.getOrganisationUnitSchemeBeans(ref, false, false);
    }

    @Override
    public Set<DataProviderSchemeBean> getDataProviderSchemeBeans(MaintainableRefBean ref) {
        return this.getDataProviderSchemeBeans(ref, false);
    }

    @Override
    public Set<DataConsumerSchemeBean> getDataConsumerSchemeBeans(MaintainableRefBean ref) {
        return this.getDataConsumerSchemeBeans(ref, false);
    }

    @Override
    public Set<AgencySchemeBean> getAgencySchemeBeans(MaintainableRefBean ref) {
        return this.getAgencySchemeBeans(ref, false);
    }

    @Override
    public Set<ProcessBean> getProcessBeans(MaintainableRefBean ref) {
        return this.getProcessBeans(ref, false, false);
    }

    @Override
    public Set<ProvisionAgreementBean> getProvisionAgreementBeans(MaintainableRefBean ref) {
        return this.getProvisionAgreementBeans(ref, false, false);
    }

    @Override
    public Set<ReportingTaxonomyBean> getReportingTaxonomyBeans(MaintainableRefBean ref) {
        return this.getReportingTaxonomyBeans(ref, false, false);
    }

    @Override
    public Set<StructureSetBean> getStructureSetBeans(MaintainableRefBean ref) {
        return this.getStructureSetBeans(ref, false, false);
    }

    @Override
    public Set<AttachmentConstraintBean> getAttachmentConstraints(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getAttachmentConstraints(ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "getAttachmentConstraints");
    }

    @Override
    public Set<CategorisationBean> getCategorisationBeans(MaintainableRefBean ref, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getCategorisationBeans(ref, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "getCategorisationBeans");
    }

    @Override
    public Set<CodelistBean> getCodelistBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getCodelistBeans(ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "getCodelistBeans");
    }

    @Override
    public Set<ConceptSchemeBean> getConceptSchemeBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getConceptSchemeBeans(ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "getConceptSchemeBeans");
    }

    @Override
    public Set<ContentConstraintBean> getContentConstraints(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getContentConstraints(ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "getContentConstraints");
    }

    @Override
    public Set<CategorySchemeBean> getCategorySchemeBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getCategorySchemeBeans(ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "getCategorySchemeBeans");
    }

    @Override
    public Set<DataflowBean> getDataflowBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getDataflowBeans(ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "getDataflowBeans");
    }

    @Override
    public Set<HierarchicalCodelistBean> getHierarchicCodeListBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getHierarchicCodeListBeans(ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "getHierarchicCodeListBeans");
    }

    @Override
    public Set<MetadataFlowBean> getMetadataflowBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getMetadataflowBeans(ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "getMetadataflowBeans");
    }

    @Override
    public Set<DataStructureBean> getDataStructureBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getDataStructureBeans(ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "getDataStructureBeans");
    }

    @Override
    public Set<MetadataStructureDefinitionBean> getMetadataStructureBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getMetadataStructureBeans(ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "getMetadataStructureBeans");
    }

    @Override
    public Set<OrganisationUnitSchemeBean> getOrganisationUnitSchemeBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getOrganisationUnitSchemeBeans(ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "getOrganisationUnitSchemeBeans");
    }

    @Override
    public Set<DataProviderSchemeBean> getDataProviderSchemeBeans(MaintainableRefBean ref, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getDataProviderSchemeBeans(ref, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "getDataProviderSchemeBeans");
    }

    @Override
    public Set<DataConsumerSchemeBean> getDataConsumerSchemeBeans(MaintainableRefBean ref, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getDataConsumerSchemeBeans(ref, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "getDataConsumerSchemeBeans");
    }

    @Override
    public Set<AgencySchemeBean> getAgencySchemeBeans(MaintainableRefBean ref, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getAgencySchemeBeans(ref, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "getAgencySchemeBeans");
    }

    @Override
    public Set<ProcessBean> getProcessBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getProcessBeans(ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "getProcessBeans");
    }

    @Override
    public Set<ProvisionAgreementBean> getProvisionAgreementBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getProvisionAgreementBeans(ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "getProvisionAgreementBeans");
    }

    @Override
    public Set<ReportingTaxonomyBean> getReportingTaxonomyBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getReportingTaxonomyBeans(ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "getReportingTaxonomyBeans");
    }

    @Override
    public Set<StructureSetBean> getStructureSetBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getStructureSetBeans(ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "getStructureSetBeans");
    }

    @Override
    public AgencySchemeBean getAgencySchemeBean(MaintainableRefBean ref, boolean returnStub) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getAgencySchemeBeans(ref, returnStub), ref);
        return (AgencySchemeBean)maint;
    }

    @Override
    public DataConsumerSchemeBean getDataConsumerSchemeBean(MaintainableRefBean ref, boolean returnStub) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getDataConsumerSchemeBeans(ref, returnStub), ref);
        return (DataConsumerSchemeBean)maint;
    }

    @Override
    public AttachmentConstraintBean getAttachmentConstraint(MaintainableRefBean ref, boolean returnStub) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getAttachmentConstraints(ref, false, returnStub), ref);
        return (AttachmentConstraintBean)maint;
    }

    @Override
    public ContentConstraintBean getContentConstraint(MaintainableRefBean ref, boolean returnStub) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getContentConstraints(ref, false, returnStub), ref);
        return (ContentConstraintBean)maint;
    }

    @Override
    public DataProviderSchemeBean getDataProviderSchemeBean(MaintainableRefBean ref, boolean returnStub) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getDataProviderSchemeBeans(ref, returnStub), ref);
        return (DataProviderSchemeBean)maint;
    }

    @Override
    public OrganisationUnitSchemeBean getOrganisationUnitScheme(MaintainableRefBean ref, boolean returnStub) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getOrganisationUnitSchemeBeans(ref, false, returnStub), ref);
        return (OrganisationUnitSchemeBean)maint;
    }

    @Override
    public CategorisationBean getCategorisation(MaintainableRefBean ref, boolean returnStub) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getCategorisationBeans(ref, returnStub), ref);
        return (CategorisationBean)maint;
    }

    @Override
    public CategorySchemeBean getCategoryScheme(MaintainableRefBean ref, boolean returnStub) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getCategorySchemeBeans(ref, false, returnStub), ref);
        return (CategorySchemeBean)maint;
    }

    @Override
    public CodelistBean getCodelist(MaintainableRefBean ref, boolean returnStub) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getCodelistBeans(ref, false, returnStub), ref);
        return (CodelistBean)maint;
    }

    @Override
    public ConceptSchemeBean getConceptScheme(MaintainableRefBean ref, boolean returnStub) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getConceptSchemeBeans(ref, false, returnStub), ref);
        return (ConceptSchemeBean)maint;
    }

    @Override
    public DataflowBean getDataflow(MaintainableRefBean ref, boolean returnStub) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getDataflowBeans(ref, false, returnStub), ref);
        return (DataflowBean)maint;
    }

    @Override
    public HierarchicalCodelistBean getHierarchicCodeList(MaintainableRefBean ref, boolean returnStub) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getHierarchicCodeListBeans(ref, false, returnStub), ref);
        return (HierarchicalCodelistBean)maint;
    }

    @Override
    public DataStructureBean getDataStructure(MaintainableRefBean ref, boolean returnStub) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getDataStructureBeans(ref, false, returnStub), ref);
        return (DataStructureBean)maint;
    }

    @Override
    public MetadataFlowBean getMetadataflow(MaintainableRefBean ref, boolean returnStub) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getMetadataflowBeans(ref, false, returnStub), ref);
        return (MetadataFlowBean)maint;
    }

    @Override
    public MetadataStructureDefinitionBean getMetadataStructure(MaintainableRefBean ref, boolean returnStub) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getMetadataStructureBeans(ref, false, returnStub), ref);
        return (MetadataStructureDefinitionBean)maint;
    }

    @Override
    public ProcessBean getProcessBean(MaintainableRefBean ref, boolean returnStub) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getProcessBeans(ref, false, returnStub), ref);
        return (ProcessBean)maint;
    }

    @Override
    public ProvisionAgreementBean getProvisionAgreementBean(MaintainableRefBean ref, boolean returnStub) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getProvisionAgreementBeans(ref, false, returnStub), ref);
        return (ProvisionAgreementBean)maint;
    }

    @Override
    public ReportingTaxonomyBean getReportingTaxonomy(MaintainableRefBean ref, boolean returnStub) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getReportingTaxonomyBeans(ref, false, returnStub), ref);
        return (ReportingTaxonomyBean)maint;
    }

    @Override
    public StructureSetBean getStructureSet(MaintainableRefBean ref, boolean returnStub) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getStructureSetBeans(ref, false, returnStub), ref);
        return (StructureSetBean)maint;
    }

    protected Set<? extends MaintainableBean> getMaintainables(StructureReferenceBean query) throws CrossReferenceException {
        if (!query.getTargetReference().isMaintainable()) {
            throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, (Object)((Object)query.getTargetReference()) + " is not maintainable");
        }
        MaintainableRefBean ref = query.getMaintainableReference();
        switch (query.getTargetReference()) {
            case AGENCY_SCHEME: {
                return this.getAgencySchemeBeans(ref, false);
            }
            case DATA_CONSUMER_SCHEME: {
                return this.getDataConsumerSchemeBeans(ref, false);
            }
            case ATTACHMENT_CONSTRAINT: {
                return this.getAttachmentConstraints(ref, false, false);
            }
            case CONTENT_CONSTRAINT: {
                return this.getContentConstraints(ref, false, false);
            }
            case DATA_PROVIDER_SCHEME: {
                return this.getDataProviderSchemeBeans(ref, false);
            }
            case CATEGORISATION: {
                return this.getCategorisationBeans(ref, false);
            }
            case CATEGORY_SCHEME: {
                return this.getCategorySchemeBeans(ref, false, false);
            }
            case CODE_LIST: {
                return this.getCodelistBeans(ref, false, false);
            }
            case CONCEPT_SCHEME: {
                return this.getConceptSchemeBeans(ref, false, false);
            }
            case DATAFLOW: {
                return this.getDataflowBeans(ref, false, false);
            }
            case HIERARCHICAL_CODELIST: {
                return this.getHierarchicCodeListBeans(ref, false, false);
            }
            case DSD: {
                return this.getDataStructureBeans(ref, false, false);
            }
            case METADATA_FLOW: {
                return this.getMetadataflowBeans(ref, false, false);
            }
            case MSD: {
                return this.getMetadataStructureBeans(ref, false, false);
            }
            case ORGANISATION_UNIT_SCHEME: {
                return this.getOrganisationUnitSchemeBeans(ref, false, false);
            }
            case PROCESS: {
                return this.getProcessBeans(ref, false, false);
            }
            case REPORTING_TAXONOMY: {
                return this.getReportingTaxonomyBeans(ref, false, false);
            }
            case STRUCTURE_SET: {
                return this.getStructureSetBeans(ref, false, false);
            }
            case PROVISION_AGREEMENT: {
                return this.getProvisionAgreementBeans(ref, false, false);
            }
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{query.getTargetReference()});
    }
}

