/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureretrieval.manager;

import java.net.MalformedURLException;
import java.net.URL;
import org.sdmxsource.sdmx.api.manager.retrieval.ServiceRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.springframework.beans.factory.annotation.Required;

public class DefaultServiceRetrievalManager
implements ServiceRetrievalManager {
    private String baseUrl;

    @Override
    public ServiceRetrievalManager.ArtefactURL getStructureOrServiceURL(MaintainableBean maint) {
        String fullRest = String.valueOf(this.baseUrl) + "/" + maint.getStructureType().getUrnClass().toLowerCase() + "/" + maint.getAgencyId() + "/" + maint.getId() + "/" + maint.getVersion();
        try {
            return new ServiceRetrievalManager.ArtefactURL(new URL(fullRest), false);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Could not return service URL for structure - bad URL syntax " + fullRest, e);
        }
    }

    @Override
    public MaintainableBean createStub(MaintainableBean maint) {
        ServiceRetrievalManager.ArtefactURL artefactUrl = this.getStructureOrServiceURL(maint);
        return maint.getStub(artefactUrl.getUrl(), artefactUrl.isSserviceUrl());
    }

    @Required
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }
}

