/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureretrieval.manager;

import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.manager.parse.StructureParsingManager;
import org.sdmxsource.sdmx.api.manager.persist.StructurePersistenceManager;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.ServiceRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.AgencySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataConsumerSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.OrganisationUnitSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorisationBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.ReportingTaxonomyBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.StructureSetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataFlowBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataStructureDefinitionBean;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.registry.AttachmentConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ContentConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.structureretrieval.manager.BaseSdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.util.beans.MaintainableUtil;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;
import org.sdmxsource.util.model.Listener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.aspectj.AbstractDependencyInjectionAspect;
import org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect;
import org.springframework.beans.factory.aspectj.ConfigurableObject;

@Configurable(preConstruction=true)
public class InMemoryRetrievalManager
extends BaseSdmxBeanRetrievalManager
implements SdmxBeanRetrievalManager,
StructurePersistenceManager,
Listener<ReadableDataLocation>,
ConfigurableObject {
    private static Logger LOG;
    protected SdmxBeans beans;
    ResultExtractor<AgencySchemeBean> agencySchemeExtractor;
    ResultExtractor<AttachmentConstraintBean> attachmentConstraintExtractor;
    ResultExtractor<CategorisationBean> categorisationExtractor;
    ResultExtractor<CodelistBean> codelistExtractor;
    ResultExtractor<ConceptSchemeBean> conceptSchemeExtractor;
    ResultExtractor<ContentConstraintBean> contentConstraintExtractor;
    ResultExtractor<CategorySchemeBean> categorySchemeExtractor;
    ResultExtractor<DataConsumerSchemeBean> dataConsumerSchemeExtractor;
    ResultExtractor<DataflowBean> dataflowExtractor;
    ResultExtractor<DataProviderSchemeBean> dataProviderSchemeExtractor;
    ResultExtractor<HierarchicalCodelistBean> hierarchicalCodelistExtractor;
    ResultExtractor<MetadataFlowBean> metadataFlowExtractor;
    ResultExtractor<DataStructureBean> dataStructureExtractor;
    ResultExtractor<MetadataStructureDefinitionBean> metadataStructureDefinitionExtractor;
    ResultExtractor<OrganisationUnitSchemeBean> organisationUnitSchemeExtractor;
    ResultExtractor<ProcessBean> processBeanExtractor;
    ResultExtractor<ProvisionAgreementBean> provisionAgreementExtractor;
    ResultExtractor<StructureSetBean> structureSetExtractor;
    ResultExtractor<ReportingTaxonomyBean> reportingTaxonomyExtractor;
    @Autowired(required=false)
    private StructureParsingManager structureParsingManager;
    protected ServiceRetrievalManager serviceRetrievalManager;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        Factory factory = new Factory("InMemoryRetrievalManager.java", Class.forName("org.sdmxsource.sdmx.structureretrieval.manager.InMemoryRetrievalManager"));
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.springframework.beans.factory.aspectj.ConfigurableObject", "", "", ""), 109);
        ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.springframework.beans.factory.aspectj.ConfigurableObject", "", "", ""), 115);
        ajc$tjp_2 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.springframework.beans.factory.aspectj.ConfigurableObject", "", "", ""), 119);
        ajc$tjp_3 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.sdmxsource.sdmx.structureretrieval.manager.InMemoryRetrievalManager", "", "", ""), 109);
        ajc$tjp_4 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.sdmxsource.sdmx.structureretrieval.manager.InMemoryRetrievalManager", "org.sdmxsource.sdmx.api.util.ReadableDataLocation:", "seed:", ""), 115);
        ajc$tjp_5 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.sdmxsource.sdmx.structureretrieval.manager.InMemoryRetrievalManager", "org.sdmxsource.sdmx.api.model.beans.SdmxBeans:", "beans:", ""), 119);
        LOG = Logger.getLogger(InMemoryRetrievalManager.class);
    }

    public InMemoryRetrievalManager() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$before$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$1$e854fa65((Object)this);
        }
        if ((this == null || !this.getClass().isAnnotationPresent(Configurable.class) || !AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) && this != null && this.getClass().isAnnotationPresent(Configurable.class) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint2)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
        this.beans = new SdmxBeansImpl();
        this.agencySchemeExtractor = new ResultExtractor();
        this.attachmentConstraintExtractor = new ResultExtractor(new MaintainableUtil());
        this.categorisationExtractor = new ResultExtractor();
        this.codelistExtractor = new ResultExtractor(new MaintainableUtil());
        this.conceptSchemeExtractor = new ResultExtractor(new MaintainableUtil());
        this.contentConstraintExtractor = new ResultExtractor(new MaintainableUtil());
        this.categorySchemeExtractor = new ResultExtractor(new MaintainableUtil());
        this.dataConsumerSchemeExtractor = new ResultExtractor();
        this.dataflowExtractor = new ResultExtractor(new MaintainableUtil());
        this.dataProviderSchemeExtractor = new ResultExtractor();
        this.hierarchicalCodelistExtractor = new ResultExtractor(new MaintainableUtil());
        this.metadataFlowExtractor = new ResultExtractor(new MaintainableUtil());
        this.dataStructureExtractor = new ResultExtractor(new MaintainableUtil());
        this.metadataStructureDefinitionExtractor = new ResultExtractor(new MaintainableUtil());
        this.organisationUnitSchemeExtractor = new ResultExtractor(new MaintainableUtil());
        this.processBeanExtractor = new ResultExtractor(new MaintainableUtil());
        this.provisionAgreementExtractor = new ResultExtractor(new MaintainableUtil());
        this.structureSetExtractor = new ResultExtractor(new MaintainableUtil());
        this.reportingTaxonomyExtractor = new ResultExtractor(new MaintainableUtil());
        if (!AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
    }

    public InMemoryRetrievalManager(ReadableDataLocation seed) {
        ReadableDataLocation readableDataLocation = seed;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)readableDataLocation);
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$before$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$1$e854fa65((Object)this);
        }
        if ((this == null || !this.getClass().isAnnotationPresent(Configurable.class) || !AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) && this != null && this.getClass().isAnnotationPresent(Configurable.class) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint2)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
        this.beans = new SdmxBeansImpl();
        this.agencySchemeExtractor = new ResultExtractor();
        this.attachmentConstraintExtractor = new ResultExtractor(new MaintainableUtil());
        this.categorisationExtractor = new ResultExtractor();
        this.codelistExtractor = new ResultExtractor(new MaintainableUtil());
        this.conceptSchemeExtractor = new ResultExtractor(new MaintainableUtil());
        this.contentConstraintExtractor = new ResultExtractor(new MaintainableUtil());
        this.categorySchemeExtractor = new ResultExtractor(new MaintainableUtil());
        this.dataConsumerSchemeExtractor = new ResultExtractor();
        this.dataflowExtractor = new ResultExtractor(new MaintainableUtil());
        this.dataProviderSchemeExtractor = new ResultExtractor();
        this.hierarchicalCodelistExtractor = new ResultExtractor(new MaintainableUtil());
        this.metadataFlowExtractor = new ResultExtractor(new MaintainableUtil());
        this.dataStructureExtractor = new ResultExtractor(new MaintainableUtil());
        this.metadataStructureDefinitionExtractor = new ResultExtractor(new MaintainableUtil());
        this.organisationUnitSchemeExtractor = new ResultExtractor(new MaintainableUtil());
        this.processBeanExtractor = new ResultExtractor(new MaintainableUtil());
        this.provisionAgreementExtractor = new ResultExtractor(new MaintainableUtil());
        this.structureSetExtractor = new ResultExtractor(new MaintainableUtil());
        this.reportingTaxonomyExtractor = new ResultExtractor(new MaintainableUtil());
        this.invoke(seed);
        if (!AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
    }

    public InMemoryRetrievalManager(SdmxBeans beans) {
        SdmxBeans sdmxBeans = beans;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)sdmxBeans);
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$before$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$1$e854fa65((Object)this);
        }
        if ((this == null || !this.getClass().isAnnotationPresent(Configurable.class) || !AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) && this != null && this.getClass().isAnnotationPresent(Configurable.class) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint2)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
        this.beans = new SdmxBeansImpl();
        this.agencySchemeExtractor = new ResultExtractor();
        this.attachmentConstraintExtractor = new ResultExtractor(new MaintainableUtil());
        this.categorisationExtractor = new ResultExtractor();
        this.codelistExtractor = new ResultExtractor(new MaintainableUtil());
        this.conceptSchemeExtractor = new ResultExtractor(new MaintainableUtil());
        this.contentConstraintExtractor = new ResultExtractor(new MaintainableUtil());
        this.categorySchemeExtractor = new ResultExtractor(new MaintainableUtil());
        this.dataConsumerSchemeExtractor = new ResultExtractor();
        this.dataflowExtractor = new ResultExtractor(new MaintainableUtil());
        this.dataProviderSchemeExtractor = new ResultExtractor();
        this.hierarchicalCodelistExtractor = new ResultExtractor(new MaintainableUtil());
        this.metadataFlowExtractor = new ResultExtractor(new MaintainableUtil());
        this.dataStructureExtractor = new ResultExtractor(new MaintainableUtil());
        this.metadataStructureDefinitionExtractor = new ResultExtractor(new MaintainableUtil());
        this.organisationUnitSchemeExtractor = new ResultExtractor(new MaintainableUtil());
        this.processBeanExtractor = new ResultExtractor(new MaintainableUtil());
        this.provisionAgreementExtractor = new ResultExtractor(new MaintainableUtil());
        this.structureSetExtractor = new ResultExtractor(new MaintainableUtil());
        this.reportingTaxonomyExtractor = new ResultExtractor(new MaintainableUtil());
        this.beans = beans;
        if (this.beans == null) {
            this.beans = new SdmxBeansImpl();
        }
        if (!AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
    }

    @Override
    public void invoke(ReadableDataLocation seed) {
        this.beans = new SdmxBeansImpl();
        if (seed != null) {
            if (this.structureParsingManager == null) {
                throw new RuntimeException("Can not create an InMemoryRetrievalManager, StructureParsingManager is either not registered as a Spring Bean or Aspects are not enabled");
            }
            try {
                this.saveStructures(this.structureParsingManager.parseStructures(seed).getStructureBeans(false));
            }
            finally {
                seed.close();
            }
        }
    }

    @Override
    public void saveStructure(MaintainableBean maintainable) {
        SdmxBeansImpl beans = new SdmxBeansImpl();
        beans.addIdentifiable(maintainable);
        this.saveStructures(beans);
    }

    @Override
    public void deleteStructure(MaintainableBean maintainable) {
        SdmxBeansImpl beans = new SdmxBeansImpl();
        beans.addIdentifiable(maintainable);
        this.deleteStructures(beans);
    }

    @Override
    public void saveStructures(SdmxBeans beans) {
        this.beans.merge(beans);
    }

    @Override
    public void deleteStructures(SdmxBeans beans) {
        for (MaintainableBean currentMaint : beans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0])) {
            this.beans.removeMaintainable(currentMaint);
        }
    }

    public SdmxBeans getBeans() {
        return new SdmxBeansImpl(this.beans);
    }

    @Override
    public Set<AttachmentConstraintBean> getAttachmentConstraints(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return ((ResultExtractor)this.attachmentConstraintExtractor).filterResults(this.beans.getAttachmentConstraints(ref), returnLatest, returnStub);
    }

    @Override
    public Set<ContentConstraintBean> getContentConstraints(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return ((ResultExtractor)this.contentConstraintExtractor).filterResults(this.beans.getContentConstraintBeans(ref), returnLatest, returnStub);
    }

    @Override
    public Set<OrganisationUnitSchemeBean> getOrganisationUnitSchemeBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return ((ResultExtractor)this.organisationUnitSchemeExtractor).filterResults(this.beans.getOrganisationUnitSchemes(ref), returnLatest, returnStub);
    }

    @Override
    public Set<DataProviderSchemeBean> getDataProviderSchemeBeans(MaintainableRefBean ref, boolean returnStub) {
        return ((ResultExtractor)this.dataProviderSchemeExtractor).filterResults(this.beans.getDataProviderSchemes(ref), false, returnStub);
    }

    @Override
    public Set<DataConsumerSchemeBean> getDataConsumerSchemeBeans(MaintainableRefBean ref, boolean returnStub) {
        return ((ResultExtractor)this.dataConsumerSchemeExtractor).filterResults(this.beans.getDataConsumerSchemes(ref), false, returnStub);
    }

    @Override
    public Set<AgencySchemeBean> getAgencySchemeBeans(MaintainableRefBean ref, boolean returnStub) {
        return ((ResultExtractor)this.agencySchemeExtractor).filterResults(this.beans.getAgenciesSchemes(ref), false, returnStub);
    }

    @Override
    public Set<CategorisationBean> getCategorisationBeans(MaintainableRefBean ref, boolean returnStub) {
        return ((ResultExtractor)this.categorisationExtractor).filterResults(this.beans.getCategorisations(ref), false, returnStub);
    }

    @Override
    public Set<CategorySchemeBean> getCategorySchemeBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return ((ResultExtractor)this.categorySchemeExtractor).filterResults(this.beans.getCategorySchemes(ref), returnLatest, returnStub);
    }

    @Override
    public Set<CodelistBean> getCodelistBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return ((ResultExtractor)this.codelistExtractor).filterResults(this.beans.getCodelists(ref), returnLatest, returnStub);
    }

    @Override
    public Set<ConceptSchemeBean> getConceptSchemeBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return ((ResultExtractor)this.conceptSchemeExtractor).filterResults(this.beans.getConceptSchemes(ref), returnLatest, returnStub);
    }

    @Override
    public Set<DataflowBean> getDataflowBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return ((ResultExtractor)this.dataflowExtractor).filterResults(this.beans.getDataflows(ref), returnLatest, returnStub);
    }

    @Override
    public Set<HierarchicalCodelistBean> getHierarchicCodeListBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return ((ResultExtractor)this.hierarchicalCodelistExtractor).filterResults(this.beans.getHierarchicalCodelists(ref), returnLatest, returnStub);
    }

    @Override
    public Set<DataStructureBean> getDataStructureBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return ((ResultExtractor)this.dataStructureExtractor).filterResults(this.beans.getDataStructures(ref), returnLatest, returnStub);
    }

    @Override
    public Set<MetadataFlowBean> getMetadataflowBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return ((ResultExtractor)this.metadataFlowExtractor).filterResults(this.beans.getMetadataflows(ref), returnLatest, returnStub);
    }

    @Override
    public Set<MetadataStructureDefinitionBean> getMetadataStructureBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return ((ResultExtractor)this.metadataStructureDefinitionExtractor).filterResults(this.beans.getMetadataStructures(ref), returnLatest, returnStub);
    }

    @Override
    public Set<ProcessBean> getProcessBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return ((ResultExtractor)this.processBeanExtractor).filterResults(this.beans.getProcesses(ref), returnLatest, returnStub);
    }

    @Override
    public Set<ReportingTaxonomyBean> getReportingTaxonomyBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return ((ResultExtractor)this.reportingTaxonomyExtractor).filterResults(this.beans.getReportingTaxonomys(ref), returnLatest, returnStub);
    }

    @Override
    public Set<StructureSetBean> getStructureSetBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return ((ResultExtractor)this.structureSetExtractor).filterResults(this.beans.getStructureSets(ref), returnLatest, returnStub);
    }

    @Override
    public Set<ProvisionAgreementBean> getProvisionAgreementBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return ((ResultExtractor)this.provisionAgreementExtractor).filterResults(this.beans.getProvisionAgreements(ref), returnLatest, returnStub);
    }

    public void setServiceRetrievalManager(ServiceRetrievalManager serviceRetrievalManager) {
        this.serviceRetrievalManager = serviceRetrievalManager;
    }

    private class ResultExtractor<T extends MaintainableBean> {
        private MaintainableUtil<T> maintainableUtil;

        public ResultExtractor() {
        }

        public ResultExtractor(MaintainableUtil<T> maintainableUtil) {
            this.maintainableUtil = maintainableUtil;
        }

        private Set<T> filterResults(Set<T> results, boolean returnLatest, boolean returnStub) {
            if (returnLatest && this.maintainableUtil != null) {
                results = this.maintainableUtil.filterCollectionGetLatestOfType(results);
            }
            if (returnStub && InMemoryRetrievalManager.this.serviceRetrievalManager != null) {
                HashSet<T> newSet = new HashSet<T>();
                for (MaintainableBean result : results) {
                    newSet.add(InMemoryRetrievalManager.this.serviceRetrievalManager.createStub(result));
                }
                results = newSet;
            }
            return results;
        }
    }
}

