/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureretrieval.manager;

import java.util.HashSet;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.manager.retrieval.ProvisionBeanRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataFlowBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.api.model.beans.registry.RegistrationBean;
import org.sdmxsource.util.ObjectUtil;

public class ProvisionRetrievalManagerFromBeanRetrieval
implements ProvisionBeanRetrievalManager {
    private SdmxBeanRetrievalManager beanRetrievalManager;

    public ProvisionRetrievalManagerFromBeanRetrieval(SdmxBeanRetrievalManager beanRetrievalManager) {
        this.beanRetrievalManager = beanRetrievalManager;
    }

    public Set<ProvisionAgreementBean> getProvisionsByDataStructure(StructureReferenceBean provisionRef) {
        Set<ProvisionAgreementBean> allProvision = this.beanRetrievalManager.getProvisionAgreementBeans(null);
        HashSet<ProvisionAgreementBean> returnSet = new HashSet<ProvisionAgreementBean>();
        Set<DataStructureBean> keyFamilies = this.beanRetrievalManager.getDataStructureBeans(null, false, false);
        Set<DataflowBean> dataflows = this.beanRetrievalManager.getDataflowBeans(null, false, false);
        for (MaintainableBean maintainableBean : keyFamilies) {
            if (!provisionRef.isMatch(maintainableBean)) continue;
            for (MaintainableBean maintainableBean2 : dataflows) {
                DataflowBean df = (DataflowBean)maintainableBean2;
                if (!df.getDataStructureRef().isMatch(maintainableBean)) continue;
                returnSet.addAll(this.getByReference(df, allProvision));
            }
        }
        return returnSet;
    }

    public Set<ProvisionAgreementBean> getProvisionsByDataFlow(StructureReferenceBean provisionRef) {
        Set<ProvisionAgreementBean> allProvision = this.beanRetrievalManager.getProvisionAgreementBeans(null);
        HashSet<ProvisionAgreementBean> returnSet = new HashSet<ProvisionAgreementBean>();
        Set<DataflowBean> dataflows = this.beanRetrievalManager.getDataflowBeans(null);
        for (MaintainableBean maintainableBean : dataflows) {
            returnSet.addAll(this.getByReference(maintainableBean, allProvision));
        }
        return returnSet;
    }

    public Set<ProvisionAgreementBean> getProvisionsByDataProvider(StructureReferenceBean provisionRef) {
        HashSet<ProvisionAgreementBean> returnSet = new HashSet<ProvisionAgreementBean>();
        Set<ProvisionAgreementBean> allProvisions = this.beanRetrievalManager.getProvisionAgreementBeans(null);
        Set<DataProviderSchemeBean> dataProviderSchemes = this.beanRetrievalManager.getDataProviderSchemeBeans(null);
        for (MaintainableBean maintainableBean : dataProviderSchemes) {
            if (!provisionRef.isMatch(maintainableBean)) continue;
            for (MaintainableBean maintainableBean2 : allProvisions) {
                ProvisionAgreementBean prov = (ProvisionAgreementBean)maintainableBean2;
                if (!prov.getDataproviderRef().equals(provisionRef)) continue;
                returnSet.add(prov);
            }
        }
        return returnSet;
    }

    public Set<ProvisionAgreementBean> getProvisionsByProvision(StructureReferenceBean provisionRef) {
        return this.beanRetrievalManager.getProvisionAgreementBeans(provisionRef.getMaintainableReference());
    }

    @Override
    public Set<ProvisionAgreementBean> getProvisions(StructureReferenceBean provisionRef) {
        SDMX_STRUCTURE_TYPE targetReference = provisionRef.getTargetReference();
        switch (targetReference) {
            case DSD: {
                return this.getProvisionsByDataStructure(provisionRef);
            }
            case DATAFLOW: {
                return this.getProvisionsByDataFlow(provisionRef);
            }
            case DATA_PROVIDER: {
                return this.getProvisionsByDataProvider(provisionRef);
            }
            case PROVISION_AGREEMENT: {
                return this.getProvisionsByProvision(provisionRef);
            }
        }
        throw new SdmxNotImplementedException("Can not get Provisons by stucture type:" + targetReference.getType());
    }

    @Override
    public ProvisionAgreementBean getProvision(RegistrationBean registration) {
        Set<ProvisionAgreementBean> provisions = this.getProvisions(registration.getProvisionAgreementRef());
        if (ObjectUtil.validCollection(provisions)) {
            if (provisions.size() > 1) {
                throw new RuntimeException("Only one provision agreement expected from reference : " + registration.getProvisionAgreementRef());
            }
            return (ProvisionAgreementBean)provisions.toArray()[0];
        }
        return null;
    }

    @Override
    public Set<ProvisionAgreementBean> getProvisions(DataflowBean dataflow) {
        Set<ProvisionAgreementBean> allProvisions = this.beanRetrievalManager.getProvisionAgreementBeans(null);
        return this.getByReference(dataflow, allProvisions);
    }

    @Override
    public Set<ProvisionAgreementBean> getProvisions(MetadataFlowBean metadataflow) {
        Set<ProvisionAgreementBean> allProvisions = this.beanRetrievalManager.getProvisionAgreementBeans(null);
        return this.getByReference(metadataflow, allProvisions);
    }

    private Set<ProvisionAgreementBean> getByReference(MaintainableBean bean, Set<ProvisionAgreementBean> allProvisions) {
        HashSet<ProvisionAgreementBean> returnSet = new HashSet<ProvisionAgreementBean>();
        for (MaintainableBean maintainableBean : allProvisions) {
            ProvisionAgreementBean provision = (ProvisionAgreementBean)maintainableBean;
            if (!this.isMatch(provision, bean)) continue;
            returnSet.add(provision);
        }
        return returnSet;
    }

    private boolean isMatch(ProvisionAgreementBean provision, MaintainableBean bean) {
        for (CrossReferenceBean currentRef : provision.getCrossReferences()) {
            if (!currentRef.isMatch(bean)) continue;
            return true;
        }
        return false;
    }
}

