/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureretrieval.manager;

import java.util.Set;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.STRUCTURE_QUERY_DETAIL;
import org.sdmxsource.sdmx.api.constants.STRUCTURE_REFERENCE_DETAIL;
import org.sdmxsource.sdmx.api.exception.CrossReferenceException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.StructureSearchManager;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.AgencyBean;
import org.sdmxsource.sdmx.api.model.beans.base.AgencySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataConsumerSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.OrganisationUnitSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorisationBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.ReportingTaxonomyBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.StructureSetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataFlowBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataStructureDefinitionBean;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.AttachmentConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ContentConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.reference.RESTStructureQueryImpl;
import org.sdmxsource.sdmx.util.beans.reference.MaintainableRefBeanImpl;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;

public class StructureSearchBeanRetrievalManager
implements SdmxBeanRetrievalManager {
    private StructureSearchManager structureSearchManager;

    public StructureSearchBeanRetrievalManager(StructureSearchManager structureSearchManager) {
        this.structureSearchManager = structureSearchManager;
    }

    @Override
    public MaintainableBean getMaintainable(StructureReferenceBean query, boolean returnStub) throws CrossReferenceException {
        STRUCTURE_QUERY_DETAIL queryDetail = returnStub ? STRUCTURE_QUERY_DETAIL.ALL_STUBS : STRUCTURE_QUERY_DETAIL.FULL;
        RESTStructureQueryImpl sQuery = new RESTStructureQueryImpl(queryDetail, STRUCTURE_REFERENCE_DETAIL.NONE, null, query, false);
        SdmxBeans beans = this.structureSearchManager.getMaintainables(sQuery);
        Set<MaintainableBean> allMaintainables = beans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]);
        if (allMaintainables.size() == 0) {
            return null;
        }
        if (allMaintainables.size() > 1) {
            throw new RuntimeException("Expected only one bean from query : " + query.toString());
        }
        return (MaintainableBean)allMaintainables.toArray()[0];
    }

    @Override
    public AgencyBean getAgency(String id) {
        AgencySchemeBean acySch = null;
        String schemeId = "AGENCIES";
        if (id.contains(".")) {
            int lastDotIdx = id.lastIndexOf(".");
            schemeId = id.substring(0, lastDotIdx);
            id = id.substring(lastDotIdx);
        }
        if ((acySch = this.getAgencySchemeBean(new MaintainableRefBeanImpl("SDMX", schemeId, "1.0"))) != null) {
            for (AgencyBean acy : acySch.getItems()) {
                if (!acy.getId().equals(id)) continue;
                return acy;
            }
        }
        return null;
    }

    @Override
    public AgencySchemeBean getAgencySchemeBean(MaintainableRefBean ref) {
        return this.getAgencySchemeBean(ref, false);
    }

    @Override
    public AgencySchemeBean getAgencySchemeBean(MaintainableRefBean ref, boolean returnStub) {
        return (AgencySchemeBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.AGENCY_SCHEME, false, returnStub).getBean();
    }

    @Override
    public Set<AgencySchemeBean> getAgencySchemeBeans(MaintainableRefBean ref) {
        return this.getAgencySchemeBeans(ref, false);
    }

    @Override
    public Set<AgencySchemeBean> getAgencySchemeBeans(MaintainableRefBean ref, boolean returnStub) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.AGENCY_SCHEME, false, returnStub).getBeans();
    }

    @Override
    public AttachmentConstraintBean getAttachmentConstraint(MaintainableRefBean ref) {
        return this.getAttachmentConstraint(ref, false);
    }

    @Override
    public Set<AttachmentConstraintBean> getAttachmentConstraints(MaintainableRefBean ref) {
        return this.getAttachmentConstraints(ref, false, false);
    }

    @Override
    public AttachmentConstraintBean getAttachmentConstraint(MaintainableRefBean ref, boolean returnStub) {
        return (AttachmentConstraintBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.ATTACHMENT_CONSTRAINT, false, returnStub).getBean();
    }

    @Override
    public Set<AttachmentConstraintBean> getAttachmentConstraints(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.ATTACHMENT_CONSTRAINT, returnLatest, returnStub).getBeans();
    }

    @Override
    public CategorisationBean getCategorisation(MaintainableRefBean ref) {
        return this.getCategorisation(ref, false);
    }

    @Override
    public CategorisationBean getCategorisation(MaintainableRefBean ref, boolean returnStub) {
        return (CategorisationBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.CATEGORISATION, false, returnStub).getBean();
    }

    @Override
    public Set<CategorisationBean> getCategorisationBeans(MaintainableRefBean ref, boolean returnStub) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.CATEGORISATION, false, returnStub).getBeans();
    }

    @Override
    public CodelistBean getCodelist(MaintainableRefBean ref) {
        return this.getCodelist(ref, false);
    }

    @Override
    public CodelistBean getCodelist(MaintainableRefBean ref, boolean returnStub) {
        return (CodelistBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.CODE_LIST, false, returnStub).getBean();
    }

    @Override
    public Set<CodelistBean> getCodelistBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.CODE_LIST, returnLatest, returnStub).getBeans();
    }

    @Override
    public Set<CodelistBean> getCodelistBeans(MaintainableRefBean ref) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.CODE_LIST).getBeans();
    }

    @Override
    public ConceptSchemeBean getConceptScheme(MaintainableRefBean ref) {
        return (ConceptSchemeBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME).getBean();
    }

    @Override
    public ContentConstraintBean getContentConstraint(MaintainableRefBean ref) {
        return (ContentConstraintBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.CONTENT_CONSTRAINT).getBean();
    }

    @Override
    public CategorySchemeBean getCategoryScheme(MaintainableRefBean ref) {
        return (CategorySchemeBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.CATEGORY_SCHEME).getBean();
    }

    @Override
    public DataConsumerSchemeBean getDataConsumerSchemeBean(MaintainableRefBean ref) {
        return (DataConsumerSchemeBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.DATA_CONSUMER_SCHEME).getBean();
    }

    @Override
    public DataflowBean getDataflow(MaintainableRefBean ref) {
        return (DataflowBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.DATAFLOW).getBean();
    }

    @Override
    public DataProviderSchemeBean getDataProviderSchemeBean(MaintainableRefBean ref) {
        return (DataProviderSchemeBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.DATA_PROVIDER_SCHEME).getBean();
    }

    @Override
    public HierarchicalCodelistBean getHierarchicCodeList(MaintainableRefBean ref) {
        return (HierarchicalCodelistBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST).getBean();
    }

    @Override
    public MetadataFlowBean getMetadataflow(MaintainableRefBean ref) {
        return (MetadataFlowBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.METADATA_FLOW).getBean();
    }

    @Override
    public DataStructureBean getDataStructure(MaintainableRefBean ref) {
        return (DataStructureBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.DSD).getBean();
    }

    @Override
    public MetadataStructureDefinitionBean getMetadataStructure(MaintainableRefBean ref) {
        return (MetadataStructureDefinitionBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.MSD).getBean();
    }

    @Override
    public OrganisationUnitSchemeBean getOrganisationUnitScheme(MaintainableRefBean ref) {
        return (OrganisationUnitSchemeBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.ORGANISATION_UNIT_SCHEME).getBean();
    }

    @Override
    public ProcessBean getProcessBean(MaintainableRefBean ref) {
        return (ProcessBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.PROCESS).getBean();
    }

    @Override
    public ProvisionAgreementBean getProvisionAgreementBean(MaintainableRefBean ref) {
        return (ProvisionAgreementBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.PROVISION_AGREEMENT).getBean();
    }

    @Override
    public StructureSetBean getStructureSet(MaintainableRefBean ref) {
        return (StructureSetBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.STRUCTURE_SET).getBean();
    }

    @Override
    public ReportingTaxonomyBean getReportingTaxonomy(MaintainableRefBean ref) {
        return (ReportingTaxonomyBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.REPORTING_TAXONOMY).getBean();
    }

    @Override
    public Set<CategorisationBean> getCategorisationBeans(MaintainableRefBean ref) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.CATEGORISATION).getBeans();
    }

    @Override
    public Set<ConceptSchemeBean> getConceptSchemeBeans(MaintainableRefBean ref) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME).getBeans();
    }

    @Override
    public ConceptSchemeBean getConceptScheme(MaintainableRefBean ref, boolean returnStub) {
        return (ConceptSchemeBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME, false, returnStub).getBean();
    }

    @Override
    public Set<ConceptSchemeBean> getConceptSchemeBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME, returnLatest, returnStub).getBeans();
    }

    @Override
    public Set<ContentConstraintBean> getContentConstraints(MaintainableRefBean ref) {
        return this.getContentConstraints(ref, false, false);
    }

    @Override
    public ContentConstraintBean getContentConstraint(MaintainableRefBean ref, boolean returnStub) {
        return (ContentConstraintBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.CONTENT_CONSTRAINT, false, returnStub).getBean();
    }

    @Override
    public Set<ContentConstraintBean> getContentConstraints(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.CONTENT_CONSTRAINT, returnLatest, returnStub).getBeans();
    }

    @Override
    public Set<CategorySchemeBean> getCategorySchemeBeans(MaintainableRefBean ref) {
        return this.getCategorySchemeBeans(ref, false, false);
    }

    @Override
    public CategorySchemeBean getCategoryScheme(MaintainableRefBean ref, boolean returnStub) {
        return (CategorySchemeBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.CATEGORY_SCHEME, false, returnStub).getBean();
    }

    @Override
    public Set<CategorySchemeBean> getCategorySchemeBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.CATEGORY_SCHEME, returnLatest, returnStub).getBeans();
    }

    @Override
    public Set<DataConsumerSchemeBean> getDataConsumerSchemeBeans(MaintainableRefBean ref) {
        return this.getDataConsumerSchemeBeans(ref, false);
    }

    @Override
    public DataConsumerSchemeBean getDataConsumerSchemeBean(MaintainableRefBean ref, boolean returnStub) {
        return (DataConsumerSchemeBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.DATA_CONSUMER_SCHEME, false, returnStub).getBean();
    }

    @Override
    public Set<DataConsumerSchemeBean> getDataConsumerSchemeBeans(MaintainableRefBean ref, boolean returnStub) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.DATA_CONSUMER_SCHEME, false, returnStub).getBeans();
    }

    @Override
    public Set<DataProviderSchemeBean> getDataProviderSchemeBeans(MaintainableRefBean ref) {
        return this.getDataProviderSchemeBeans(ref, false);
    }

    @Override
    public DataProviderSchemeBean getDataProviderSchemeBean(MaintainableRefBean ref, boolean returnStub) {
        return (DataProviderSchemeBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.DATA_PROVIDER_SCHEME, false, returnStub).getBean();
    }

    @Override
    public Set<DataProviderSchemeBean> getDataProviderSchemeBeans(MaintainableRefBean ref, boolean returnStub) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.DATA_PROVIDER_SCHEME, false, returnStub).getBeans();
    }

    @Override
    public Set<DataflowBean> getDataflowBeans(MaintainableRefBean ref) {
        return this.getDataflowBeans(ref, false, false);
    }

    @Override
    public DataflowBean getDataflow(MaintainableRefBean ref, boolean returnStub) {
        return (DataflowBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.DATAFLOW, false, returnStub).getBean();
    }

    @Override
    public Set<DataflowBean> getDataflowBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.DATAFLOW, returnLatest, returnStub).getBeans();
    }

    @Override
    public Set<DataStructureBean> getDataStructureBeans(MaintainableRefBean ref) {
        return this.getDataStructureBeans(ref, false, false);
    }

    @Override
    public DataStructureBean getDataStructure(MaintainableRefBean ref, boolean returnStub) {
        return (DataStructureBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.DSD, false, returnStub).getBean();
    }

    @Override
    public Set<DataStructureBean> getDataStructureBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.DSD, returnLatest, returnStub).getBeans();
    }

    @Override
    public Set<HierarchicalCodelistBean> getHierarchicCodeListBeans(MaintainableRefBean ref) {
        return this.getHierarchicCodeListBeans(ref, false, false);
    }

    @Override
    public HierarchicalCodelistBean getHierarchicCodeList(MaintainableRefBean ref, boolean returnStub) {
        return (HierarchicalCodelistBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST, false, returnStub).getBean();
    }

    @Override
    public Set<HierarchicalCodelistBean> getHierarchicCodeListBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST, returnLatest, returnStub).getBeans();
    }

    @Override
    public Set<MetadataFlowBean> getMetadataflowBeans(MaintainableRefBean ref) {
        return this.getMetadataflowBeans(ref, false, false);
    }

    @Override
    public MetadataFlowBean getMetadataflow(MaintainableRefBean ref, boolean returnStub) {
        return (MetadataFlowBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.METADATA_FLOW, false, returnStub).getBean();
    }

    @Override
    public Set<MetadataFlowBean> getMetadataflowBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.METADATA_FLOW, returnLatest, returnStub).getBeans();
    }

    @Override
    public Set<MetadataStructureDefinitionBean> getMetadataStructureBeans(MaintainableRefBean ref) {
        return this.getMetadataStructureBeans(ref, false, false);
    }

    @Override
    public MetadataStructureDefinitionBean getMetadataStructure(MaintainableRefBean ref, boolean returnStub) {
        return (MetadataStructureDefinitionBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.MSD, false, returnStub).getBean();
    }

    @Override
    public Set<MetadataStructureDefinitionBean> getMetadataStructureBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.MSD, returnLatest, returnStub).getBeans();
    }

    @Override
    public Set<OrganisationUnitSchemeBean> getOrganisationUnitSchemeBeans(MaintainableRefBean ref) {
        return this.getOrganisationUnitSchemeBeans(ref, false, false);
    }

    @Override
    public OrganisationUnitSchemeBean getOrganisationUnitScheme(MaintainableRefBean ref, boolean returnStub) {
        return (OrganisationUnitSchemeBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.ORGANISATION_UNIT_SCHEME, false, returnStub).getBean();
    }

    @Override
    public Set<OrganisationUnitSchemeBean> getOrganisationUnitSchemeBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.ORGANISATION_UNIT_SCHEME, returnLatest, returnStub).getBeans();
    }

    @Override
    public Set<ProcessBean> getProcessBeans(MaintainableRefBean ref) {
        return this.getProcessBeans(ref, false, false);
    }

    @Override
    public ProcessBean getProcessBean(MaintainableRefBean ref, boolean returnStub) {
        return (ProcessBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.PROCESS, false, returnStub).getBean();
    }

    @Override
    public Set<ProcessBean> getProcessBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.PROCESS, returnLatest, returnStub).getBeans();
    }

    @Override
    public Set<ProvisionAgreementBean> getProvisionAgreementBeans(MaintainableRefBean ref) {
        return this.getProvisionAgreementBeans(ref, false, false);
    }

    @Override
    public ProvisionAgreementBean getProvisionAgreementBean(MaintainableRefBean ref, boolean returnStub) {
        return (ProvisionAgreementBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.PROVISION_AGREEMENT, false, returnStub).getBean();
    }

    @Override
    public Set<ProvisionAgreementBean> getProvisionAgreementBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.PROVISION_AGREEMENT, returnLatest, returnStub).getBeans();
    }

    @Override
    public Set<ReportingTaxonomyBean> getReportingTaxonomyBeans(MaintainableRefBean ref) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.REPORTING_TAXONOMY).getBeans();
    }

    @Override
    public ReportingTaxonomyBean getReportingTaxonomy(MaintainableRefBean ref, boolean returnStub) {
        return (ReportingTaxonomyBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.REPORTING_TAXONOMY, false, returnStub).getBean();
    }

    @Override
    public Set<ReportingTaxonomyBean> getReportingTaxonomyBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.REPORTING_TAXONOMY, returnLatest, returnStub).getBeans();
    }

    @Override
    public Set<StructureSetBean> getStructureSetBeans(MaintainableRefBean ref) {
        return this.getStructureSetBeans(ref, false, false);
    }

    @Override
    public StructureSetBean getStructureSet(MaintainableRefBean ref, boolean returnStub) {
        return (StructureSetBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.STRUCTURE_SET, false, returnStub).getBean();
    }

    @Override
    public Set<StructureSetBean> getStructureSetBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.STRUCTURE_SET, returnLatest, returnStub).getBeans();
    }

    private class Resolver<T> {
        private StructureReferenceBean sRef;
        private boolean returnLatest;
        private boolean retrunStub;
        private SDMX_STRUCTURE_TYPE type;

        public Resolver(MaintainableRefBean ref, SDMX_STRUCTURE_TYPE type) {
            this(ref, type, false, false);
        }

        public Resolver(MaintainableRefBean ref, SDMX_STRUCTURE_TYPE type, boolean returnLatest, boolean returnStub) {
            if (returnLatest && ref.getVersion() != null) {
                ref = new MaintainableRefBeanImpl(ref.getAgencyId(), ref.getMaintainableId(), null);
            }
            this.sRef = new StructureReferenceBeanImpl(ref, type);
            this.type = type;
            this.returnLatest = returnLatest;
            this.retrunStub = returnStub;
        }

        private T getBean() {
            Set<T> beans = this.getBeans();
            if (beans.size() > 1) {
                throw new RuntimeException("Expected only one bean from query : " + this.sRef.toString());
            }
            if (beans.size() == 0) {
                return null;
            }
            return (T)beans.toArray()[0];
        }

        private Set<T> getBeans() {
            STRUCTURE_QUERY_DETAIL queryDetail = this.retrunStub ? STRUCTURE_QUERY_DETAIL.ALL_STUBS : STRUCTURE_QUERY_DETAIL.FULL;
            RESTStructureQueryImpl sQuery = new RESTStructureQueryImpl(queryDetail, STRUCTURE_REFERENCE_DETAIL.NONE, this.type, this.sRef, this.returnLatest);
            SdmxBeans beans = StructureSearchBeanRetrievalManager.this.structureSearchManager.getMaintainables(sQuery);
            return beans.getMaintainables(this.type);
        }
    }
}

