/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureretrieval.manager;

import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.STRUCTURE_QUERY_DETAIL;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.manager.retrieval.HeaderRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.RegistrationBeanRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.StructureSearchManager;
import org.sdmxsource.sdmx.api.manager.retrieval.crossreference.CrossReferencedRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.crossreference.CrossReferencingRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.api.model.query.RESTStructureQuery;
import org.sdmxsource.sdmx.structureretrieval.engine.impl.CrossReferenceResolverEngineImpl;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;
import org.springframework.beans.factory.annotation.Autowired;

public class StructureSearchManagerImpl
implements StructureSearchManager {
    private Logger LOG = Logger.getLogger(StructureSearchManagerImpl.class);
    protected CrossReferencedRetrievalManager crossReferenceRetrievalManager;
    protected CrossReferencingRetrievalManager crossReferencingRetrievalManager;
    protected SdmxBeanRetrievalManager sdmxBeanRetrievalManager;
    private RegistrationBeanRetrievalManager registrationRetrievalManager;
    @Autowired(required=false)
    private HeaderRetrievalManager headerRetrievalManager;

    public StructureSearchManagerImpl(SdmxBeanRetrievalManager sdmxBeanRetrievalManager, CrossReferencedRetrievalManager crossReferenceRetrievalManager, CrossReferencingRetrievalManager crossReferencingRetrievalManager) {
        if (sdmxBeanRetrievalManager == null) {
            throw new IllegalArgumentException("SdmxBeanRetrievalManager can not be null");
        }
        if (crossReferenceRetrievalManager == null) {
            throw new IllegalArgumentException("CrossReferenceControl can not be null");
        }
        this.sdmxBeanRetrievalManager = sdmxBeanRetrievalManager;
        this.crossReferenceRetrievalManager = crossReferenceRetrievalManager;
        this.crossReferencingRetrievalManager = crossReferencingRetrievalManager;
    }

    @Override
    public SdmxBeans getMaintainables(RESTStructureQuery complexQuery) {
        this.LOG.info((Object)("Query for maintainables: " + complexQuery));
        boolean isAllStubs = complexQuery.getStructureQueryMetadata().getStructureQueryDetail() == STRUCTURE_QUERY_DETAIL.ALL_STUBS;
        boolean isRefStubs = isAllStubs || complexQuery.getStructureQueryMetadata().getStructureQueryDetail() == STRUCTURE_QUERY_DETAIL.REFERENCED_STUBS;
        boolean isLatest = complexQuery.getStructureQueryMetadata().isReturnLatest();
        Set<MaintainableBean> queryResultMaintainables = this.retrieveStructures(complexQuery.getStructureReference().getMaintainableReference(), complexQuery.getStructureReference().getMaintainableStructureType(), false, isLatest, isAllStubs).getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]);
        this.LOG.info((Object)("Returned " + queryResultMaintainables.size() + " results"));
        HeaderBean header = null;
        if (this.headerRetrievalManager != null) {
            header = this.headerRetrievalManager.getHeader();
        }
        SdmxBeansImpl referencedBeans = new SdmxBeansImpl(header);
        SdmxBeansImpl referenceMerge = new SdmxBeansImpl();
        switch (complexQuery.getStructureQueryMetadata().getStructureReferenceDetail()) {
            case NONE: {
                this.LOG.info((Object)"Reference detail NONE");
                break;
            }
            case PARENTS: {
                this.LOG.info((Object)"Reference detail PARENTS");
                this.resolveParents(queryResultMaintainables, referencedBeans, isRefStubs);
                break;
            }
            case PARENTS_SIBLINGS: {
                this.LOG.info((Object)"Reference detail PARENTS_SIBLINGS");
                this.resolveParents(queryResultMaintainables, referencedBeans, isRefStubs);
                this.resolveChildren(referencedBeans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]), referenceMerge, isRefStubs);
                referencedBeans.merge(referenceMerge);
                break;
            }
            case CHILDREN: {
                this.LOG.info((Object)"Reference detail CHILDREN");
                this.resolveChildren(queryResultMaintainables, referencedBeans, isRefStubs);
                break;
            }
            case DESCENDANTS: {
                this.LOG.info((Object)"Reference detail DESCENDANTS");
                this.resolveDescendants(queryResultMaintainables, referencedBeans, isRefStubs);
                break;
            }
            case ALL: {
                this.LOG.info((Object)"Reference detail ALL");
                this.resolveParents(queryResultMaintainables, referencedBeans, isRefStubs);
                this.resolveDescendants(queryResultMaintainables, referenceMerge, isRefStubs);
                referencedBeans.merge(referenceMerge);
                break;
            }
            case SPECIFIC: {
                this.LOG.info((Object)"Reference detail Children");
                this.resolveSpecific(queryResultMaintainables, referencedBeans, complexQuery.getStructureQueryMetadata().getSpecificStructureReference(), isRefStubs);
            }
        }
        referencedBeans.addIdentifiables(queryResultMaintainables);
        this.LOG.info((Object)("Result Size : " + referencedBeans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]).size()));
        return referencedBeans;
    }

    private void resolveSpecific(Set<MaintainableBean> resolveFor, SdmxBeans referencedBeans, SDMX_STRUCTURE_TYPE specificType, boolean returnStub) {
        this.LOG.info((Object)"Resolving Child Structures");
        for (MaintainableBean currentMaintainable : resolveFor) {
            this.LOG.debug((Object)("Resolving Children of " + currentMaintainable.getUrn()));
            referencedBeans.addIdentifiables(this.crossReferenceRetrievalManager.getCrossReferencedStructures(currentMaintainable, returnStub, specificType));
            if (this.crossReferencingRetrievalManager == null) continue;
            referencedBeans.addIdentifiables(this.crossReferencingRetrievalManager.getCrossReferencingStructures(currentMaintainable, returnStub, specificType));
        }
        this.LOG.info((Object)(String.valueOf(referencedBeans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]).size()) + " children found"));
    }

    private void resolveDescendants(Set<MaintainableBean> resolveFor, SdmxBeans referencedBeans, boolean returnStub) {
        int numBeans = -2;
        while (numBeans != resolveFor.size()) {
            numBeans = referencedBeans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]).size();
            this.resolveChildren(resolveFor, referencedBeans, returnStub);
            resolveFor = referencedBeans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]);
        }
        this.LOG.info((Object)(String.valueOf(referencedBeans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]).size()) + " descendants found"));
    }

    private void resolveChildren(Set<MaintainableBean> resolveFor, SdmxBeans referencedBeans, boolean returnStub) {
        this.LOG.info((Object)"Resolving Child Structures");
        for (MaintainableBean currentMaintainable : resolveFor) {
            this.LOG.debug((Object)("Resolving Children of " + currentMaintainable.getUrn()));
            referencedBeans.addIdentifiables(this.crossReferenceRetrievalManager.getCrossReferencedStructures(currentMaintainable, returnStub, new SDMX_STRUCTURE_TYPE[0]));
        }
        this.LOG.info((Object)(String.valueOf(referencedBeans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]).size()) + " children found"));
    }

    private void resolveParents(Set<MaintainableBean> resolveFor, SdmxBeans referencedBeans, boolean returnStub) {
        this.LOG.info((Object)"Resolving Parents Structures");
        for (MaintainableBean currentMaintainable : resolveFor) {
            this.LOG.debug((Object)("Resolving Parents of " + currentMaintainable.getUrn()));
            if (this.crossReferencingRetrievalManager == null) {
                throw new SdmxNotImplementedException("Resolve parents not supported");
            }
            referencedBeans.addIdentifiables(this.crossReferencingRetrievalManager.getCrossReferencingStructures(currentMaintainable, returnStub, new SDMX_STRUCTURE_TYPE[0]));
        }
        this.LOG.info((Object)(String.valueOf(referencedBeans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]).size()) + " parents found"));
    }

    private SdmxBeans retrieveStructures(MaintainableRefBean ref, SDMX_STRUCTURE_TYPE structureType, boolean resolveReferences, boolean getLatest, boolean returnStub) {
        if (structureType == null) {
            structureType = SDMX_STRUCTURE_TYPE.ANY;
        }
        if (structureType != SDMX_STRUCTURE_TYPE.ANY && structureType != SDMX_STRUCTURE_TYPE.ORGANISATION_SCHEME && !structureType.isMaintainable()) {
            throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, (Object)((Object)structureType) + " is not maintainable");
        }
        SdmxBeansImpl returnBeans = new SdmxBeansImpl();
        Set<MaintainableBean> currentMaintainables = null;
        switch (structureType) {
            case ANY: {
                for (SDMX_STRUCTURE_TYPE currentMaintainable : SDMX_STRUCTURE_TYPE.getMaintainableStructureTypes()) {
                    if (currentMaintainable == SDMX_STRUCTURE_TYPE.REGISTRATION || currentMaintainable == SDMX_STRUCTURE_TYPE.SUBSCRIPTION) continue;
                    returnBeans.merge(this.retrieveStructures(ref, currentMaintainable, resolveReferences, getLatest, returnStub));
                }
                break;
            }
            case ORGANISATION_SCHEME: {
                returnBeans.merge(this.retrieveStructures(ref, SDMX_STRUCTURE_TYPE.AGENCY_SCHEME, resolveReferences, getLatest, returnStub));
                returnBeans.merge(this.retrieveStructures(ref, SDMX_STRUCTURE_TYPE.DATA_PROVIDER_SCHEME, resolveReferences, getLatest, returnStub));
                returnBeans.merge(this.retrieveStructures(ref, SDMX_STRUCTURE_TYPE.DATA_CONSUMER_SCHEME, resolveReferences, getLatest, returnStub));
                returnBeans.merge(this.retrieveStructures(ref, SDMX_STRUCTURE_TYPE.ORGANISATION_UNIT_SCHEME, resolveReferences, getLatest, returnStub));
                break;
            }
            case AGENCY_SCHEME: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getAgencySchemeBeans(ref, returnStub);
                break;
            }
            case DATA_PROVIDER_SCHEME: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getDataProviderSchemeBeans(ref, returnStub);
                break;
            }
            case DATA_CONSUMER_SCHEME: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getDataConsumerSchemeBeans(ref, returnStub);
                break;
            }
            case CATEGORISATION: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getCategorisationBeans(ref, returnStub);
                break;
            }
            case CATEGORY_SCHEME: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getCategorySchemeBeans(ref, getLatest, returnStub);
                break;
            }
            case CODE_LIST: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getCodelistBeans(ref, getLatest, returnStub);
                break;
            }
            case CONCEPT_SCHEME: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getConceptSchemeBeans(ref, getLatest, returnStub);
                break;
            }
            case DATAFLOW: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getDataflowBeans(ref, getLatest, returnStub);
                break;
            }
            case HIERARCHICAL_CODELIST: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getHierarchicCodeListBeans(ref, getLatest, returnStub);
                break;
            }
            case DSD: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getDataStructureBeans(ref, getLatest, returnStub);
                break;
            }
            case METADATA_FLOW: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getMetadataflowBeans(ref, getLatest, returnStub);
                break;
            }
            case MSD: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getMetadataStructureBeans(ref, getLatest, returnStub);
                break;
            }
            case ORGANISATION_UNIT_SCHEME: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getOrganisationUnitSchemeBeans(ref, getLatest, returnStub);
                break;
            }
            case PROCESS: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getProcessBeans(ref, getLatest, returnStub);
                break;
            }
            case STRUCTURE_SET: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getStructureSetBeans(ref, getLatest, returnStub);
                break;
            }
            case REPORTING_TAXONOMY: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getReportingTaxonomyBeans(ref, getLatest, returnStub);
                break;
            }
            case ATTACHMENT_CONSTRAINT: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getAttachmentConstraints(ref, getLatest, returnStub);
                break;
            }
            case CONTENT_CONSTRAINT: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getContentConstraints(ref, getLatest, returnStub);
                break;
            }
            case PROVISION_AGREEMENT: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getProvisionAgreementBeans(ref, getLatest, returnStub);
                break;
            }
            case REGISTRATION: {
                currentMaintainables = this.registrationRetrievalManager.getRegistrations(ref);
                break;
            }
            default: {
                throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "Unsupported query for : " + (Object)((Object)structureType));
            }
        }
        if (currentMaintainables != null) {
            for (MaintainableBean currentBean : currentMaintainables) {
                returnBeans.addIdentifiable(currentBean);
            }
        }
        if (resolveReferences) {
            this.resolveReferences(returnBeans);
        }
        return returnBeans;
    }

    void resolveReferences(SdmxBeans beans) {
        CrossReferenceResolverEngineImpl resolver = new CrossReferenceResolverEngineImpl();
        Map<IdentifiableBean, Set<IdentifiableBean>> crossReferenceMap = resolver.resolveReferences(beans, false, 0, this.sdmxBeanRetrievalManager);
        for (IdentifiableBean key : crossReferenceMap.keySet()) {
            beans.addIdentifiable(key);
            for (IdentifiableBean value : crossReferenceMap.get(key)) {
                beans.addIdentifiable(value);
            }
        }
    }

    public void setRegistrationRetrievalManager(RegistrationBeanRetrievalManager registrationRetrievalManager) {
        this.registrationRetrievalManager = registrationRetrievalManager;
    }
}

