/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureretrieval.manager.crossreference;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.crossreference.CrossReferencedRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;

public class BeanCrossReferencedRetrievalManager
implements CrossReferencedRetrievalManager {
    private SdmxBeanRetrievalManager beanRetrievalManager;

    public BeanCrossReferencedRetrievalManager(SdmxBeanRetrievalManager beanRetrievalManager) {
        this.beanRetrievalManager = beanRetrievalManager;
        if (beanRetrievalManager == null) {
            throw new SdmxException("BeanCrossReferencedRetrievalManager - SdmxBeanRetrievalManager is required and was not provided");
        }
    }

    @Override
    public List<MaintainableBean> getCrossReferencedStructures(StructureReferenceBean structureReference, boolean returnStub, SDMX_STRUCTURE_TYPE ... structures) {
        return this.getCrossReferencedStructures(this.beanRetrievalManager.getMaintainable(structureReference, false), returnStub, structures);
    }

    @Override
    public List<MaintainableBean> getCrossReferencedStructures(IdentifiableBean identifiable, boolean returnStub, SDMX_STRUCTURE_TYPE ... structures) {
        ArrayList<MaintainableBean> returnList = new ArrayList<MaintainableBean>();
        HashMap map = new HashMap();
        for (CrossReferenceBean currentCrossReference : identifiable.getCrossReferences()) {
            HashSet<MaintainableRefBean> references = (HashSet<MaintainableRefBean>)map.get((Object)currentCrossReference.getMaintainableStructureType());
            if (references == null) {
                references = new HashSet<MaintainableRefBean>();
                map.put(currentCrossReference.getMaintainableStructureType(), references);
            }
            if (references.contains(currentCrossReference.getMaintainableReference())) continue;
            references.add(currentCrossReference.getMaintainableReference());
            MaintainableBean maint = this.beanRetrievalManager.getMaintainable(currentCrossReference, returnStub);
            if (returnList.contains(maint)) continue;
            returnList.add(maint);
        }
        return returnList;
    }
}

