/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureretrieval.manager.crossreference;

import java.util.Map;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.exception.CrossReferenceException;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.crossreference.StructureWithReferencesManager;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.structureretrieval.engine.impl.CrossReferenceResolverEngineImpl;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;

public class BeanManagerStructureWithReferences
implements StructureWithReferencesManager {
    private SdmxBeanRetrievalManager beanRetrievalManager;

    public BeanManagerStructureWithReferences(SdmxBeanRetrievalManager beanRetrievalManager) {
        this.beanRetrievalManager = beanRetrievalManager;
        if (beanRetrievalManager == null) {
            throw new SdmxException("BeanManagerStructureWithReferences, constructor arg 'SdmxBeanRetrievalManager' can not be null");
        }
    }

    @Override
    public SdmxBeans getStructureWithReferences(StructureReferenceBean sRef) {
        Set<? extends MaintainableBean> maintainables = this.getMaintainables(sRef);
        SdmxBeansImpl beans = new SdmxBeansImpl();
        beans.addIdentifiables(maintainables);
        this.resolveReferences(beans);
        return beans;
    }

    protected Set<? extends MaintainableBean> getMaintainables(StructureReferenceBean query) throws CrossReferenceException {
        if (!query.getTargetReference().isMaintainable()) {
            throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, (Object)((Object)query.getTargetReference()) + " is not maintainable");
        }
        MaintainableRefBean ref = query.getMaintainableReference();
        switch (query.getTargetReference()) {
            case AGENCY_SCHEME: {
                return this.beanRetrievalManager.getAgencySchemeBeans(ref, false);
            }
            case DATA_CONSUMER_SCHEME: {
                return this.beanRetrievalManager.getDataConsumerSchemeBeans(ref, false);
            }
            case ATTACHMENT_CONSTRAINT: {
                return this.beanRetrievalManager.getAttachmentConstraints(ref, false, false);
            }
            case CONTENT_CONSTRAINT: {
                return this.beanRetrievalManager.getContentConstraints(ref, false, false);
            }
            case DATA_PROVIDER_SCHEME: {
                return this.beanRetrievalManager.getDataProviderSchemeBeans(ref, false);
            }
            case CATEGORISATION: {
                return this.beanRetrievalManager.getCategorisationBeans(ref, false);
            }
            case CATEGORY_SCHEME: {
                return this.beanRetrievalManager.getCategorySchemeBeans(ref, false, false);
            }
            case CODE_LIST: {
                return this.beanRetrievalManager.getCodelistBeans(ref, false, false);
            }
            case CONCEPT_SCHEME: {
                return this.beanRetrievalManager.getConceptSchemeBeans(ref, false, false);
            }
            case DATAFLOW: {
                return this.beanRetrievalManager.getDataflowBeans(ref, false, false);
            }
            case HIERARCHICAL_CODELIST: {
                return this.beanRetrievalManager.getHierarchicCodeListBeans(ref, false, false);
            }
            case DSD: {
                return this.beanRetrievalManager.getDataStructureBeans(ref, false, false);
            }
            case METADATA_FLOW: {
                return this.beanRetrievalManager.getMetadataflowBeans(ref, false, false);
            }
            case MSD: {
                return this.beanRetrievalManager.getMetadataStructureBeans(ref, false, false);
            }
            case ORGANISATION_UNIT_SCHEME: {
                return this.beanRetrievalManager.getOrganisationUnitSchemeBeans(ref, false, false);
            }
            case PROCESS: {
                return this.beanRetrievalManager.getProcessBeans(ref, false, false);
            }
            case REPORTING_TAXONOMY: {
                return this.beanRetrievalManager.getReportingTaxonomyBeans(ref, false, false);
            }
            case STRUCTURE_SET: {
                return this.beanRetrievalManager.getStructureSetBeans(ref, false, false);
            }
            case PROVISION_AGREEMENT: {
                return this.beanRetrievalManager.getProvisionAgreementBeans(ref, false, false);
            }
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{query.getTargetReference()});
    }

    private void resolveReferences(SdmxBeans beans) {
        CrossReferenceResolverEngineImpl resolver = new CrossReferenceResolverEngineImpl();
        Map<IdentifiableBean, Set<IdentifiableBean>> crossReferenceMap = resolver.resolveReferences(beans, false, 0, this.beanRetrievalManager);
        for (IdentifiableBean key : crossReferenceMap.keySet()) {
            beans.addIdentifiable(key);
            for (IdentifiableBean value : crossReferenceMap.get(key)) {
                beans.addIdentifiable(value);
            }
        }
    }
}

