/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.util.beans;

import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.util.beans.reference.CrossReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class ConceptRefUtil {
    public static String getConceptId(StructureReferenceBean sRef) {
        if (sRef.getTargetReference() == SDMX_STRUCTURE_TYPE.CONCEPT) {
            return sRef.getChildReference().getId();
        }
        throw new SdmxSemmanticException("Expecting a Concept Reference got : " + sRef.getTargetReference().getType());
    }

    public static CrossReferenceBean buildConceptRef(IdentifiableBean referencedFrom, String conceptSchemeAgency, String conceptSchemeId, String conceptSchemeVersion, String conceptAgency, String conceptId) {
        boolean isFreeStanding = false;
        if (!ObjectUtil.validString(conceptSchemeId)) {
            isFreeStanding = true;
        }
        if (ObjectUtil.validOneString(conceptId, conceptSchemeAgency, conceptSchemeId, conceptSchemeVersion)) {
            if (!ObjectUtil.validString(conceptSchemeAgency)) {
                conceptSchemeAgency = conceptAgency;
            }
            if (isFreeStanding) {
                return new CrossReferenceBeanImpl(referencedFrom, conceptSchemeAgency, "STANDALONE_CONCEPT_SCHEME", "1.0", SDMX_STRUCTURE_TYPE.CONCEPT, conceptId);
            }
            return new CrossReferenceBeanImpl(referencedFrom, conceptSchemeAgency, conceptSchemeId, conceptSchemeVersion, SDMX_STRUCTURE_TYPE.CONCEPT, conceptId);
        }
        throw new IllegalArgumentException("Concept Reference missing parameters");
    }
}

