/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.util.beans.container;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.model.superbeans.SuperBeans;
import org.sdmxsource.sdmx.api.model.superbeans.base.MaintainableSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.categoryscheme.CategorySchemeSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.codelist.CodelistSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.codelist.HierarchicalCodelistSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.conceptscheme.ConceptSchemeSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataStructureSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataflowSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.process.ProcessSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.registry.ProvisionAgreementSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.registry.RegistrationSuperBean;

public class SuperBeansImpl
implements SuperBeans {
    private Set<CategorySchemeSuperBean> categorySchemes = new HashSet<CategorySchemeSuperBean>();
    private Set<CodelistSuperBean> codelists = new HashSet<CodelistSuperBean>();
    private Set<ConceptSchemeSuperBean> conceptSchemes = new HashSet<ConceptSchemeSuperBean>();
    private Set<DataflowSuperBean> dataflows = new HashSet<DataflowSuperBean>();
    private Set<HierarchicalCodelistSuperBean> hcls = new HashSet<HierarchicalCodelistSuperBean>();
    private Set<DataStructureSuperBean> dataStructures = new HashSet<DataStructureSuperBean>();
    private Set<ProvisionAgreementSuperBean> provisionAgreement = new HashSet<ProvisionAgreementSuperBean>();
    private Set<ProcessSuperBean> processes = new HashSet<ProcessSuperBean>();
    private Set<RegistrationSuperBean> registrations = new HashSet<RegistrationSuperBean>();

    public SuperBeansImpl() {
    }

    public SuperBeansImpl(Collection<MaintainableSuperBean> allBeans) {
        if (allBeans != null) {
            for (MaintainableSuperBean currentBean : allBeans) {
                if (currentBean instanceof CategorySchemeSuperBean) {
                    this.categorySchemes.add((CategorySchemeSuperBean)currentBean);
                    continue;
                }
                if (currentBean instanceof CodelistSuperBean) {
                    this.codelists.add((CodelistSuperBean)currentBean);
                    continue;
                }
                if (currentBean instanceof ConceptSchemeSuperBean) {
                    this.conceptSchemes.add((ConceptSchemeSuperBean)currentBean);
                    continue;
                }
                if (currentBean instanceof DataflowSuperBean) {
                    this.dataflows.add((DataflowSuperBean)currentBean);
                    continue;
                }
                if (currentBean instanceof HierarchicalCodelistSuperBean) {
                    this.hcls.add((HierarchicalCodelistSuperBean)currentBean);
                    continue;
                }
                if (currentBean instanceof DataStructureSuperBean) {
                    this.dataStructures.add((DataStructureSuperBean)currentBean);
                    continue;
                }
                if (currentBean.getBuiltFrom().getStructureType() == SDMX_STRUCTURE_TYPE.PROVISION_AGREEMENT) {
                    this.provisionAgreement.add((ProvisionAgreementSuperBean)currentBean);
                    continue;
                }
                if (currentBean instanceof ProcessSuperBean) {
                    this.processes.add((ProcessSuperBean)currentBean);
                    continue;
                }
                if (!(currentBean instanceof RegistrationSuperBean)) continue;
                this.registrations.add((RegistrationSuperBean)currentBean);
            }
        }
    }

    public SuperBeansImpl(SuperBeans ... beans) {
        for (SuperBeans currentBean : beans) {
            this.categorySchemes.addAll(currentBean.getCategorySchemes());
            this.codelists.addAll(currentBean.getCodelists());
            this.conceptSchemes.addAll(currentBean.getConceptSchemes());
            this.dataflows.addAll(currentBean.getDataflows());
            this.hcls.addAll(currentBean.getHierarchicalCodelists());
            this.dataStructures.addAll(currentBean.getDataStructures());
            this.provisionAgreement.addAll(currentBean.getProvisions());
            this.processes.addAll(currentBean.getProcesses());
            this.registrations.addAll(currentBean.getRegistartions());
        }
    }

    @Override
    public void merge(SuperBeans superBeans) {
        for (MaintainableSuperBean currentSb : superBeans.getAllMaintainables()) {
            this.addMaintainable(currentSb);
        }
    }

    @Override
    public void addMaintainable(MaintainableSuperBean bean) {
        switch (bean.getBuiltFrom().getStructureType()) {
            case CATEGORY_SCHEME: {
                this.addCategoryScheme((CategorySchemeSuperBean)bean);
                break;
            }
            case CODE_LIST: {
                this.addCodelist((CodelistSuperBean)bean);
                break;
            }
            case CONCEPT_SCHEME: {
                this.addConceptScheme((ConceptSchemeSuperBean)bean);
                break;
            }
            case DATAFLOW: {
                this.addDataflow((DataflowSuperBean)bean);
                break;
            }
            case HIERARCHICAL_CODELIST: {
                this.addHierarchicalCodelist((HierarchicalCodelistSuperBean)bean);
                break;
            }
            case DSD: {
                this.addDataStructure((DataStructureSuperBean)bean);
                break;
            }
            case PROCESS: {
                this.addProcess((ProcessSuperBean)bean);
                break;
            }
            case PROVISION_AGREEMENT: {
                this.addHierarchicalCodelist((HierarchicalCodelistSuperBean)bean);
                break;
            }
            case REGISTRATION: {
                this.addRegistration((RegistrationSuperBean)bean);
                break;
            }
            default: {
                throw new SdmxNotImplementedException("SuperBeansImpl.addMaintainable of type : " + bean.getBuiltFrom().getStructureType().getType());
            }
        }
    }

    @Override
    public void addCategoryScheme(CategorySchemeSuperBean bean) {
        if (bean != null) {
            this.categorySchemes.remove(bean);
            this.categorySchemes.add(bean);
        }
    }

    @Override
    public void addCodelist(CodelistSuperBean bean) {
        if (bean != null) {
            this.codelists.remove(bean);
            this.codelists.add(bean);
        }
    }

    @Override
    public void addConceptScheme(ConceptSchemeSuperBean bean) {
        if (bean != null) {
            this.conceptSchemes.remove(bean);
            this.conceptSchemes.add(bean);
        }
    }

    @Override
    public void addDataflow(DataflowSuperBean bean) {
        if (bean != null) {
            this.dataflows.remove(bean);
            this.dataflows.add(bean);
        }
    }

    @Override
    public void addHierarchicalCodelist(HierarchicalCodelistSuperBean bean) {
        if (bean != null) {
            this.hcls.remove(bean);
            this.hcls.add(bean);
        }
    }

    @Override
    public void addDataStructure(DataStructureSuperBean bean) {
        if (bean != null) {
            this.dataStructures.remove(bean);
            this.dataStructures.add(bean);
        }
    }

    @Override
    public void addProvision(ProvisionAgreementSuperBean bean) {
        if (bean != null) {
            this.provisionAgreement.remove(bean);
            this.provisionAgreement.add(bean);
        }
    }

    @Override
    public void addProcess(ProcessSuperBean bean) {
        if (bean != null) {
            this.processes.remove(bean);
            this.processes.add(bean);
        }
    }

    @Override
    public void addRegistration(RegistrationSuperBean bean) {
        if (bean != null) {
            this.registrations.remove(bean);
            this.registrations.add(bean);
        }
    }

    @Override
    public Set<CategorySchemeSuperBean> getCategorySchemes() {
        return new HashSet<CategorySchemeSuperBean>(this.categorySchemes);
    }

    @Override
    public Set<CodelistSuperBean> getCodelists() {
        return new HashSet<CodelistSuperBean>(this.codelists);
    }

    @Override
    public Set<ConceptSchemeSuperBean> getConceptSchemes() {
        return new HashSet<ConceptSchemeSuperBean>(this.conceptSchemes);
    }

    @Override
    public Set<DataflowSuperBean> getDataflows() {
        return new HashSet<DataflowSuperBean>(this.dataflows);
    }

    @Override
    public Set<HierarchicalCodelistSuperBean> getHierarchicalCodelists() {
        return new HashSet<HierarchicalCodelistSuperBean>(this.hcls);
    }

    @Override
    public Set<DataStructureSuperBean> getDataStructures() {
        return new HashSet<DataStructureSuperBean>(this.dataStructures);
    }

    @Override
    public Set<ProvisionAgreementSuperBean> getProvisions() {
        return new HashSet<ProvisionAgreementSuperBean>(this.provisionAgreement);
    }

    @Override
    public Set<ProcessSuperBean> getProcesses() {
        return new HashSet<ProcessSuperBean>(this.processes);
    }

    @Override
    public Set<RegistrationSuperBean> getRegistartions() {
        return new HashSet<RegistrationSuperBean>(this.registrations);
    }

    @Override
    public void removeCategoryScheme(CategorySchemeSuperBean bean) {
        this.categorySchemes.remove(bean);
    }

    @Override
    public void removeCodelist(CodelistSuperBean bean) {
        this.codelists.remove(bean);
    }

    @Override
    public void removeConceptScheme(ConceptSchemeSuperBean bean) {
        this.conceptSchemes.remove(bean);
    }

    @Override
    public void removeDataflow(DataflowSuperBean bean) {
        this.dataflows.remove(bean);
    }

    @Override
    public void removeHierarchicalCodelist(HierarchicalCodelistSuperBean bean) {
        this.hcls.remove(bean);
    }

    @Override
    public void removeDataStructure(DataStructureSuperBean bean) {
        this.dataStructures.remove(bean);
    }

    @Override
    public void removeProvision(ProvisionAgreementSuperBean bean) {
        this.provisionAgreement.remove(bean);
    }

    @Override
    public void removeProcess(ProcessSuperBean bean) {
        this.processes.remove(bean);
    }

    @Override
    public void removeRegistration(RegistrationSuperBean bean) {
        this.registrations.remove(bean);
    }

    @Override
    public Set<MaintainableSuperBean> getAllMaintainables() {
        HashSet<MaintainableSuperBean> returnSet = new HashSet<MaintainableSuperBean>();
        returnSet.addAll(this.categorySchemes);
        returnSet.addAll(this.codelists);
        returnSet.addAll(this.conceptSchemes);
        returnSet.addAll(this.dataflows);
        returnSet.addAll(this.hcls);
        returnSet.addAll(this.dataStructures);
        returnSet.addAll(this.provisionAgreement);
        returnSet.addAll(this.processes);
        returnSet.addAll(this.registrations);
        return returnSet;
    }
}

