/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.util.beans.reference;

import java.util.Collection;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.reference.IdentifiableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.util.ObjectUtil;

public class IdentifiableRefBeanImpl
implements IdentifiableRefBean {
    private static final long serialVersionUID = -4595600685019168190L;
    private String id;
    private StructureReferenceBean maintainableParent;
    private SDMX_STRUCTURE_TYPE structureType;
    private IdentifiableRefBean childReference;
    private IdentifiableRefBean parentReference;

    public IdentifiableRefBeanImpl() {
    }

    private IdentifiableRefBeanImpl(IdentifiableRefBean parentReference, String[] id, int currentDepth, SDMX_STRUCTURE_TYPE targetStructureType) {
        this.parentReference = parentReference;
        this.id = id[currentDepth];
        this.setStructureType(targetStructureType, currentDepth);
        if (++currentDepth < id.length) {
            this.childReference = new IdentifiableRefBeanImpl(this, id, currentDepth, targetStructureType);
        }
        this.validate();
    }

    public IdentifiableRefBeanImpl(StructureReferenceBean maintainableParent, String id, SDMX_STRUCTURE_TYPE targetStructureType) {
        this.structureType = targetStructureType;
        this.maintainableParent = maintainableParent;
        this.id = id;
        this.validate();
    }

    IdentifiableRefBeanImpl(StructureReferenceBean maintainableParent, String[] idArr, SDMX_STRUCTURE_TYPE targetStructureType) {
        this.setStructureType(targetStructureType, 0);
        this.maintainableParent = maintainableParent;
        if (this.structureType.hasFixedId() && !idArr[0].equals(this.structureType.getFixedId())) {
            String[] tempArray = new String[idArr.length + 1];
            tempArray[0] = this.structureType.getFixedId();
            for (int i = 0; i < idArr.length; ++i) {
                tempArray[i + 1] = idArr[i];
            }
            idArr = tempArray;
        }
        this.id = idArr[0];
        if (idArr.length > 1) {
            this.childReference = new IdentifiableRefBeanImpl(this, idArr, 1, targetStructureType);
        }
        this.validate();
    }

    public IdentifiableRefBeanImpl(StructureReferenceBean maintainableParent, Collection<String> ids, SDMX_STRUCTURE_TYPE targetStructureType) {
        this.setStructureType(targetStructureType, 0);
        this.maintainableParent = maintainableParent;
        String[] idArr = new String[ids.size()];
        ids.toArray(idArr);
        this.id = idArr[0];
        if (idArr.length > 1) {
            this.childReference = new IdentifiableRefBeanImpl(this, idArr, 1, targetStructureType);
        }
        this.validate();
    }

    private void setStructureType(SDMX_STRUCTURE_TYPE targetStructureType, int currentDepth) {
        if (currentDepth < targetStructureType.getNestedDepth()) {
            for (SDMX_STRUCTURE_TYPE parentStructure = targetStructureType.getParentStructureType(); parentStructure != null; parentStructure = parentStructure.getParentStructureType()) {
                if (parentStructure.getNestedDepth() != currentDepth) continue;
                this.structureType = parentStructure;
                break;
            }
        } else {
            this.structureType = targetStructureType;
        }
    }

    private void validate() throws SdmxSemmanticException {
        if (this.structureType.hasFixedId() && ObjectUtil.validString(this.id) && !this.id.equals(this.structureType.getFixedId())) {
            throw new SdmxSemmanticException(this.structureType.getType() + " has a fixed id of '" + this.structureType.getFixedId() + "'.  Identifiable reference can not set this to '" + this.id + "'");
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public SDMX_STRUCTURE_TYPE getStructureType() {
        return this.structureType;
    }

    public void setStructureType(SDMX_STRUCTURE_TYPE structureType) {
        this.structureType = structureType;
    }

    @Override
    public IdentifiableRefBean getChildReference() {
        return this.childReference;
    }

    public void setChildReference(IdentifiableRefBean ref) {
        this.childReference = ref;
    }

    @Override
    public IdentifiableRefBean getParentIdentifiableReference() {
        return this.parentReference;
    }

    @Override
    public StructureReferenceBean getParentMaintainableReferece() {
        if (this.maintainableParent != null) {
            return this.maintainableParent;
        }
        return this.childReference.getParentMaintainableReferece();
    }

    public int hashCode() {
        return (this.structureType.getType() + this.toString()).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IdentifiableRefBean) {
            IdentifiableRefBean that = (IdentifiableRefBean)obj;
            if (this.getStructureType() == that.getStructureType() && ObjectUtil.equivalent(this.getId(), that.getId()) && ObjectUtil.equivalent(this.getChildReference(), that.getChildReference())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public IdentifiableBean getMatch(IdentifiableBean reference) {
        if (this.structureType != reference.getStructureType()) {
            return null;
        }
        if (ObjectUtil.validString(this.getId())) {
            if (this.getId().equals(reference.getId())) {
                return reference;
            }
            return null;
        }
        if (this.getChildReference() != null) {
            for (IdentifiableBean currentComposite : reference.getIdentifiableComposites()) {
                if (this.getChildReference().getMatch(currentComposite) == null) continue;
                return currentComposite;
            }
        }
        return null;
    }

    public String toString() {
        String concatString = "";
        if (this.getChildReference() != null) {
            concatString = "." + this.getChildReference().toString();
        }
        return this.getId() + concatString;
    }
}

