/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Date;
import org.apache.log4j.Logger;
import org.sdmxsource.util.io.URIUtil;

public class FileUtil {
    private static final Logger LOG = Logger.getLogger(FileUtil.class);
    private static final String TMP_FILE_DIR = System.getProperty("java.io.tmpdir");

    public static File createTemporaryFile(String prefix, String suffix) {
        File tmpDir = new File(TMP_FILE_DIR);
        if (!tmpDir.exists() && !tmpDir.mkdirs()) {
            throw new RuntimeException("Unable to create directory to store temporary files : " + tmpDir.getAbsolutePath());
        }
        try {
            return File.createTempFile(prefix, suffix);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create teporary file in directory : " + tmpDir.getAbsolutePath(), e);
        }
    }

    public static InputStream readFileAsStream(String filePath) {
        try {
            File f = new File(filePath);
            if (!f.exists()) {
                throw new IllegalArgumentException("File not found : " + filePath);
            }
            FileInputStream stream = new FileInputStream(f);
            return new BufferedInputStream(stream);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static OutputStream getOutputStream(String filePath) {
        try {
            File f = new File(filePath);
            if (!f.exists()) {
                FileUtil.createFile(f);
            }
            FileOutputStream stream = new FileOutputStream(f);
            return new BufferedOutputStream(stream);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String readFileAsString(String filePath) {
        File f = new File(filePath);
        BufferedReader br = null;
        try {
            String line;
            FileReader fr = new FileReader(f);
            br = new BufferedReader(fr);
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static boolean exists(String filePath) {
        File f = new File(filePath);
        return f.exists();
    }

    public static boolean deleteFile(String filePath) {
        File f = new File(filePath);
        return f.delete();
    }

    public static void createDirectory(String dir) {
        File f = new File(dir);
        if (!f.exists()) {
            f.mkdirs();
        } else if (!f.isDirectory()) {
            throw new IllegalArgumentException("Directory '" + dir + "' can not be created, it already exists as a file");
        }
    }

    public static File createFile(String fileStr) {
        File f = new File(fileStr);
        FileUtil.createFile(f);
        return f;
    }

    public static void createFile(File aFile) {
        boolean createdParentDirectories;
        if (aFile.exists()) {
            return;
        }
        File parentDir = aFile.getParentFile();
        if (!parentDir.exists() && !(createdParentDirectories = parentDir.mkdirs())) {
            throw new IllegalStateException("Unable to create directory structure: " + parentDir.getAbsolutePath());
        }
        try {
            aFile.createNewFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create file: " + aFile.getAbsolutePath());
        }
    }

    public static boolean deleteDirectory(String path) {
        return FileUtil.deleteDirectory(new File(path));
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    FileUtil.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    public static int countFiles(String directory) {
        File f = new File(directory);
        if (f.isDirectory()) {
            String[] list = f.list();
            if (list == null) {
                return 0;
            }
            return list.length;
        }
        throw new IllegalArgumentException(directory + " is not a directory");
    }

    public static String[] getFileNames(String directory) {
        File f = new File(directory);
        if (f.isDirectory()) {
            return f.list();
        }
        throw new IllegalArgumentException(directory + " is not a directory");
    }

    public static File[] getFiles(String directory) {
        File f = new File(directory);
        if (f.isDirectory()) {
            return f.listFiles();
        }
        throw new IllegalArgumentException(directory + " is not a directory");
    }

    public static void deleteFilesOlderThen(String directory, Date deleteFilesOlderThen) {
        File f = new File(directory);
        if (f.isDirectory()) {
            File[] files;
            for (File currentFile : files = f.listFiles()) {
                long lastModified = currentFile.lastModified();
                if (lastModified >= deleteFilesOlderThen.getTime()) continue;
                currentFile.delete();
            }
            return;
        }
        throw new IllegalArgumentException(directory + " is not a directory");
    }

    public static void deleteOldestFile(String directory) {
        long oldestFileTime = Long.MAX_VALUE;
        File oldestFile = null;
        File f = new File(directory);
        if (f.isDirectory()) {
            File[] files;
            for (File currentFile : files = f.listFiles()) {
                long lastModified = currentFile.lastModified();
                if (lastModified >= oldestFileTime) continue;
                oldestFileTime = lastModified;
                oldestFile = currentFile;
                System.out.println("OLDEST " + oldestFile + " :: " + oldestFileTime);
            }
            if (oldestFile != null) {
                oldestFile.delete();
            }
            return;
        }
        throw new IllegalArgumentException(directory + " is not a directory");
    }

    public static File getNewestFile(String directory) {
        long newestFileTime = Long.MIN_VALUE;
        File newestFile = null;
        File f = new File(directory);
        if (f.isDirectory()) {
            File[] files;
            for (File currentFile : files = f.listFiles()) {
                long lastModified = currentFile.lastModified();
                if (lastModified <= newestFileTime) continue;
                newestFileTime = lastModified;
                newestFile = currentFile;
            }
            return newestFile;
        }
        throw new IllegalArgumentException(directory + " is not a directory");
    }

    private static InputStream obtainInputStream(File aFile) {
        long proposedAbortTime = System.currentTimeMillis() + 180000L;
        while (true) {
            try {
                return new FileInputStream(aFile);
            }
            catch (FileNotFoundException e) {
                if (!aFile.exists()) {
                    return null;
                }
                LOG.warn((Object)"Unable to access the file - it appears to be locked!");
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (System.currentTimeMillis() <= proposedAbortTime) continue;
                System.out.println("Due to timeout, aborting attempting to get a lock on file: " + aFile);
                return null;
            }
            break;
        }
    }

    private static long readFile(InputStream is) {
        int size = 0;
        BufferedInputStream bis = new BufferedInputStream(is);
        byte[] ba = new byte[1024];
        try {
            while (bis.read(ba) != -1) {
                size += ba.length;
            }
        }
        catch (IOException e) {
            System.err.println("IO exception when trying to read input Stream: " + e);
            e.printStackTrace();
        }
        try {
            bis.close();
        }
        catch (IOException e) {
            System.err.println("IO exception when trying to close BufferedInputStream: " + e);
            e.printStackTrace();
        }
        try {
            is.close();
        }
        catch (IOException e) {
            System.err.println("IO exception when trying to close InputStream: " + e);
            e.printStackTrace();
        }
        return size;
    }

    public static void waitTillAvailableForWriting(File aFile) {
        if (!aFile.exists()) {
            return;
        }
        InputStream is = FileUtil.obtainInputStream(aFile);
        if (is == null) {
            return;
        }
        long priorSize = FileUtil.readFile(is);
        while (true) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            is = FileUtil.obtainInputStream(aFile);
            if (is == null) {
                return;
            }
            long currentSize = FileUtil.readFile(is);
            if (currentSize == priorSize) break;
            priorSize = currentSize;
        }
    }

    public static File ensureDirectoryExists(String directoryName) {
        File f = new File(directoryName);
        if (f.exists()) {
            if (!f.isDirectory()) {
                throw new RuntimeException("The specified directory is a file not a directory! Specified value: '" + directoryName + "'");
            }
            if (!f.canWrite()) {
                throw new RuntimeException("The specified directory does not have read permission! Specified value: '" + directoryName + "'");
            }
        } else {
            boolean successfulCreate = f.mkdirs();
            if (!successfulCreate) {
                throw new RuntimeException("Unable to create directory: " + directoryName);
            }
        }
        return f;
    }

    public static long getFileSize(File aFile) {
        return aFile.length();
    }

    public static long getFileSize(URI aURI) {
        return FileUtil.getFileSize(URIUtil.getFile(aURI));
    }

    public static void copyAllFilesInDir(File srcDir, File targetDir) throws IOException {
        if (!srcDir.exists()) {
            return;
        }
        File[] files = srcDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File aFile = files[i];
            File target = new File(targetDir, aFile.getName());
            if (aFile.isDirectory()) {
                target.mkdirs();
                FileUtil.copyAllFilesInDir(aFile, target);
                continue;
            }
            FileUtil.copyFile(aFile, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!sourceFile.exists()) {
            return;
        }
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }
}

