/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.util.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.util.io.StreamUtil;
import org.sdmxsource.util.io.URIUtil;

public class ReadableDataLocationTmp
implements ReadableDataLocation {
    private static final long serialVersionUID = 860775214722641122L;
    protected URI uri;
    protected boolean deleteOnClose = false;

    public ReadableDataLocationTmp(String uriStr) {
        if (uriStr == null) {
            throw new IllegalArgumentException("Can not create StreamSourceData - uriStr can not be null");
        }
        try {
            this.uri = new URI(uriStr);
            if (this.uri.isAbsolute() && !this.uri.getScheme().equals("file")) {
                this.uri = URIUtil.getURIUtil().getUri(this.uri.toURL().openStream());
                this.deleteOnClose = true;
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ReadableDataLocationTmp(File f) {
        if (f == null) {
            throw new IllegalArgumentException("Can not create StreamSourceData - file can not be null");
        }
        this.uri = f.toURI();
    }

    public ReadableDataLocationTmp(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Can not create StreamSourceData - url can not be null");
        }
        try {
            this.uri = URIUtil.getURIUtil().getUri(url.openStream());
            this.deleteOnClose = true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ReadableDataLocationTmp(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Can not create StreamSourceData - uri can not be null");
        }
        this.uri = uri;
    }

    public ReadableDataLocationTmp(InputStream is) {
        this.uri = URIUtil.getTemporaryURI();
        this.deleteOnClose = true;
        StreamUtil.copyStream(is, URIUtil.getOutputStream(this.uri));
        StreamUtil.closeStream(is);
    }

    @Override
    public InputStream getInputStream() {
        return URIUtil.getInputStream(this.uri);
    }

    @Override
    public void close() {
        if (this.deleteOnClose) {
            URIUtil.deleteUri(this.uri);
        }
    }

    public String toString() {
        return this.uri.toString();
    }
}

