/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.util.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.sdmxsource.util.io.FileUtil;
import org.sdmxsource.util.io.URIUtil;

public class SerializeUtil<T extends Serializable> {
    public List<byte[]> serializeAsChunkedByteArray(T serializable, int chunkLength) {
        ByteArrayOutputStream serialized = this.serializeAsByteArray(serializable);
        ArrayList<byte[]> byteList = new ArrayList<byte[]>();
        this.splitBytes(byteList, serialized.toByteArray(), chunkLength, 0);
        return byteList;
    }

    private void splitBytes(List<byte[]> list, byte[] bytes, int chunkLength, int offset) {
        int lengthTocopy = bytes.length - offset > chunkLength ? chunkLength : bytes.length - offset;
        byte[] dest = new byte[lengthTocopy];
        System.arraycopy(bytes, offset, dest, 0, lengthTocopy);
        list.add(dest);
        if (bytes.length - offset > chunkLength) {
            this.splitBytes(list, bytes, chunkLength, offset + lengthTocopy);
        }
    }

    public T deSerializeChunkedByteArray(List<byte[]> buffer) {
        int length = 0;
        for (byte[] currentArray : buffer) {
            length += currentArray.length;
        }
        byte[] merged = new byte[length];
        length = 0;
        for (byte[] currentArray : buffer) {
            System.arraycopy(currentArray, 0, merged, length, currentArray.length);
            length += currentArray.length;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(merged);
        return this.deSerialize(is);
    }

    public void serializeToOutputStream(T serializable, OutputStream output) {
        ObjectOutputStream obj_out = null;
        try {
            obj_out = new ObjectOutputStream(output);
            obj_out.writeObject(serializable);
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        finally {
            this.closeStream(output);
            this.closeStream(obj_out);
        }
    }

    public ByteArrayOutputStream serializeAsByteArray(T serializable) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.serializeToOutputStream(serializable, output);
        return output;
    }

    public void serialize(URI filelocation, T serializable) {
        File f = URIUtil.getFile(filelocation);
        this.serialize(f, serializable);
    }

    public void serialize(String fileName, T serializable) {
        this.serialize(new File(fileName), serializable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(File f, T Serializable2) {
        FileOutputStream f_out = null;
        ObjectOutputStream obj_out = null;
        try {
            if (f.exists()) {
                f.delete();
            }
            f.createNewFile();
            f_out = new FileOutputStream(f);
            obj_out = new ObjectOutputStream(f_out);
            obj_out.writeObject(Serializable2);
            this.closeStream(f_out);
            this.closeStream(obj_out);
        }
        catch (Throwable th) {
            try {
                System.out.println(th);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.closeStream(f_out);
                this.closeStream(obj_out);
            }
        }
    }

    public T deSerialize(InputStream inputStream) {
        ObjectInputStream obj_in = null;
        try {
            obj_in = new ObjectInputStream(inputStream);
            Object obj = obj_in.readObject();
            Serializable serializable = (Serializable)obj;
            return (T)serializable;
        }
        catch (Throwable th) {
            throw new IllegalArgumentException(th);
        }
        finally {
            this.closeStream(inputStream);
            this.closeStream(obj_in);
        }
    }

    public T deSerialize(String filePath) {
        Serializable serializable;
        FileInputStream f_in = null;
        ObjectInputStream obj_in = null;
        if (!FileUtil.exists(filePath)) {
            return null;
        }
        try {
            f_in = new FileInputStream(filePath);
            obj_in = new ObjectInputStream(f_in);
            Object obj = obj_in.readObject();
            serializable = (Serializable)obj;
            this.closeStream(f_in);
            this.closeStream(obj_in);
        }
        catch (Throwable th) {
            try {
                throw new IllegalArgumentException(th);
            }
            catch (Throwable throwable) {
                this.closeStream(f_in);
                this.closeStream(obj_in);
                throw throwable;
            }
        }
        return (T)serializable;
    }

    private void closeStream(OutputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void closeStream(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

