/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.sdmxsource.util.ObjectUtil;
import org.sdmxsource.util.io.FileUtil;
import org.sdmxsource.util.io.StreamUtil;
import org.sdmxsource.util.log.LoggingUtil;

public class URIUtil {
    private static Logger log = Logger.getLogger(URIUtil.class);
    private static URIUtil TEMPORARY_URI_UTIL = new URIUtil("resources/streams/tmp", "tmpFile", 1440000L, true);
    private static Set<String> uris = new HashSet<String>();
    private static Map<URI, List<OutputStream>> outputstreamMap = new HashMap<URI, List<OutputStream>>();
    private static Map<URI, List<InputStream>> inputstreamMap = new HashMap<URI, List<InputStream>>();
    private String fileBaseName = "tmp_file.";

    public static String formatStringForURI(String input) {
        return input.replaceAll(" ", "%20").replaceAll("\\\\", "/");
    }

    public static URIUtil getURIUtil() {
        return TEMPORARY_URI_UTIL;
    }

    public static URI getTemporaryURI() {
        URI uri = TEMPORARY_URI_UTIL.getUri();
        return uri;
    }

    public static URIUtil getURIUtil(String directoryName, String fileBaseName, boolean overwrite) {
        return new URIUtil(directoryName, fileBaseName, 0L, overwrite);
    }

    private URIUtil(String uriDirectory, String fileBaseName, long deleteFilesOlderThen, boolean overwright) {
        this.fileBaseName = fileBaseName;
    }

    public static void closeUri(URI uri) {
        if (uri != null) {
            uris.remove(uri.toString());
        }
    }

    public static String getFullPath(URI uri) {
        File file = new File(uri.getPath());
        return file.getAbsolutePath();
    }

    public static boolean deleteUri(URI uri) {
        if (uri == null) {
            return false;
        }
        if (outputstreamMap.containsKey(uri)) {
            for (OutputStream out : outputstreamMap.get(uri)) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        if (inputstreamMap.containsKey(uri)) {
            for (InputStream in : inputstreamMap.get(uri)) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        outputstreamMap.remove(uri);
        inputstreamMap.remove(uri);
        File file = new File(uri.getPath());
        boolean deleted = file.delete();
        URIUtil.closeUri(uri);
        return deleted;
    }

    public static void copyURIs(URI uriIn, URI uriOut) {
        try {
            StreamUtil.copyStream(new FileInputStream(uriIn.getPath()), new FileOutputStream(uriOut.getPath()));
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    public static InputStream getInputStream(URI uri) {
        try {
            InputStream stream;
            try {
                URL url = uri.toURL();
                stream = url.openStream();
            }
            catch (Throwable th) {
                String filePath = ObjectUtil.validString(uri.getPath()) ? uri.getPath() : uri.getSchemeSpecificPart();
                stream = new BufferedInputStream(new FileInputStream(filePath));
            }
            URIUtil.storeStream(uri, stream);
            return stream;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static void storeStream(URI uri, InputStream stream) {
        List<Object> streams = null;
        if (inputstreamMap.containsKey(uri)) {
            streams = inputstreamMap.get(uri);
        } else {
            streams = new ArrayList();
            inputstreamMap.put(uri, streams);
        }
        streams.add(stream);
    }

    public static OutputStream getOutputStream(URI uri) {
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(uri.getPath()));
            List<Object> streams = null;
            if (outputstreamMap.containsKey(uri)) {
                streams = outputstreamMap.get(uri);
            } else {
                streams = new ArrayList();
                outputstreamMap.put(uri, streams);
            }
            streams.add(out);
            return out;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized URI getUri() {
        try {
            File f = FileUtil.createTemporaryFile(this.fileBaseName, "sdmxsource_tmp");
            URI uri = f.toURI();
            if (!uris.contains(uri.toString())) {
                uris.add(uri.toString());
            }
            if (log.isDebugEnabled()) {
                Throwable t = new Throwable();
                StackTraceElement[] elements = t.getStackTrace();
                String callerMethodName = null;
                String callerClassName = null;
                for (int x = 0; x < elements.length; ++x) {
                    callerMethodName = elements[x].getMethodName();
                    callerClassName = elements[x].getClassName();
                    if (!callerClassName.equals(URIUtil.class.getName())) break;
                }
                LoggingUtil.debug(log, "getTemporaryURI request from (class.method)" + callerClassName + "." + callerMethodName);
                LoggingUtil.debug(log, "URI created " + uri.getPath());
            }
            return uri;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getByteArray(URI uri) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamUtil.copyStream(URIUtil.getInputStream(uri), bos);
        return bos.toByteArray();
    }

    public URI getUri(byte[] bytes) {
        URI uri = this.getUri();
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(uri.getPath()));
            bos.write(bytes, 0, bytes.length);
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        finally {
            try {
                if (bos != null) {
                    bos.flush();
                    bos.close();
                }
            }
            catch (Throwable th) {
                throw new RuntimeException(th);
            }
        }
        return uri;
    }

    public URI getUri(InputStream stream) {
        URI uri = this.getUri();
        try {
            StreamUtil.copyStream(stream, new BufferedOutputStream(new FileOutputStream(uri.getPath())));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return uri;
    }

    public static File getFile(URI uri) {
        return new File(uri.getPath());
    }
}

