/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.serviceplugin;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.codehaus.plexus.util.FileUtils;
import org.gcube.serviceplugin.AbstractServiceMojo;

public class GarGenMojo
extends AbstractServiceMojo {
    private File garDirectory;
    private File configurationDirectory;
    private File deploymentFile;
    private File deploymentNoSecFile;
    private File clientDeploymentFile;
    private File clientServerDeploymentFile;
    protected ArtifactHandler artifactHandler;
    private File wsdlOutputDirectory;
    private File jndiFile;
    private boolean skip;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping Gar generation");
            return;
        }
        try {
            this.preparePluginDirectory();
            if (this.garDirectory.exists()) {
                FileUtils.cleanDirectory((File)this.garDirectory);
            } else if (!this.garDirectory.mkdirs()) {
                throw new MojoExecutionException("Could not create directory " + this.garDirectory.getAbsolutePath());
            }
            File libDir = new File(this.garDirectory, "lib");
            Artifact mainArtifact = this.project().getArtifact();
            File mainArtifactFile = mainArtifact.getFile();
            if (mainArtifactFile.exists() && !mainArtifactFile.isDirectory() && mainArtifact.getArtifactHandler().isAddedToClasspath()) {
                FileUtils.copyFile((File)mainArtifactFile, (File)new File(libDir, mainArtifactFile.getName()));
            }
            File garFile = this.buildGar(libDir);
            FileUtils.copyFileToDirectory((File)garFile, (File)new File(this.project().getBuild().getDirectory()));
            DefaultArtifact artifact = new DefaultArtifact(this.project().getGroupId(), this.project().getArtifactId(), VersionRange.createFromVersion((String)this.project().getVersion()), null, "gar", null, this.artifactHandler);
            artifact.setFile(garFile);
            this.project().addAttachedArtifact((Artifact)artifact);
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Could not create gar artifact:", t);
        }
    }

    private File buildGar(File libDir) throws Exception {
        File buildFile = this.antBuildFile();
        String compileClasspath = this.compileClasspath();
        Project antproject = new Project();
        antproject.setBaseDir(this.pluginDirectory());
        antproject.setProperty("maven.compile.classpath", compileClasspath.toString());
        antproject.setProperty("wsdl.target.dir", this.wsdlOutputDirectory.getAbsolutePath());
        antproject.setProperty("lib.dir", libDir.getAbsolutePath());
        antproject.setProperty("config.dir", this.configurationDirectory.getAbsolutePath());
        antproject.setProperty("service.id", this.getServiceId());
        this.deploymentFile = this.deploymentFile == null ? new File(this.configurationDirectory, "deploy-server.wsdd") : this.deploymentFile;
        antproject.setProperty("deploymentFile", this.deploymentFile.getAbsolutePath());
        this.deploymentNoSecFile = this.deploymentNoSecFile == null ? new File(this.configurationDirectory, "deploy-server.wsdd_NOSEC") : this.deploymentNoSecFile;
        antproject.setProperty("deploymentNOSECFile", this.deploymentNoSecFile.getAbsolutePath());
        this.clientDeploymentFile = this.clientDeploymentFile == null ? new File(this.configurationDirectory, "deploy-client.wsdd") : this.clientDeploymentFile;
        antproject.setProperty("clientdeploymentFile", this.clientDeploymentFile.getAbsolutePath());
        this.clientServerDeploymentFile = this.clientServerDeploymentFile == null ? new File(this.configurationDirectory, "deploy-client-server.wsdd") : this.clientServerDeploymentFile;
        antproject.setProperty("clientserverdeploymentFile", this.clientServerDeploymentFile.getAbsolutePath());
        this.jndiFile = this.jndiFile == null ? new File(this.configurationDirectory, "deploy-jndi-config.xml") : this.jndiFile;
        antproject.setProperty("jndiFile", this.jndiFile.getAbsolutePath());
        String garName = String.valueOf(this.project().getArtifactId()) + "-" + this.project().getVersion() + ".gar";
        antproject.setProperty("gar.name", garName);
        antproject.setProperty("gar.dest", this.garDirectory.getAbsolutePath());
        antproject.init();
        DefaultLogger consoleLogger = new DefaultLogger();
        consoleLogger.setErrorPrintStream(System.err);
        consoleLogger.setOutputPrintStream(System.out);
        consoleLogger.setMessageOutputLevel(2);
        antproject.addBuildListener((BuildListener)consoleLogger);
        ProjectHelper helper = ProjectHelper.getProjectHelper();
        antproject.addReference("ant.projectHelper", (Object)helper);
        helper.parse(antproject, (Object)buildFile);
        antproject.executeTarget("generateGar");
        return new File(this.pluginDirectory(), garName);
    }
}

