/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.serviceplugin;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.codehaus.plexus.util.FileUtils;
import org.gcube.serviceplugin.AbstractServiceMojo;
import org.gcube.serviceplugin.Wsdl;

public class StubGenMojo
extends AbstractServiceMojo {
    private File wsdlDirectory;
    private File outputDirectory;
    private File wsdlOutputDirectory;
    private Wsdl[] wsdls;
    private String basePackage;
    private File staleFile;

    public void execute() throws MojoExecutionException {
        if (!this.isOutputStale()) {
            this.getLog().info((CharSequence)"skipping stub generation, schemas have not changed");
            return;
        }
        try {
            this.preparePluginDirectory();
            if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
                throw new Exception("Could not create directory " + this.outputDirectory.getAbsolutePath());
            }
            File buildFile = this.antBuildFile();
            if (this.wsdls.length == 0) {
                new MojoExecutionException("No WSDL specified in plugin configuration");
            }
            String compileClasspath = this.compileClasspath();
            FileUtils.cleanDirectory((File)this.outputDirectory);
            Wsdl[] wsdlArray = this.wsdls;
            int n = this.wsdls.length;
            int n2 = 0;
            while (n2 < n) {
                Wsdl wsdl = wsdlArray[n2];
                Project antproject = new Project();
                antproject.setBaseDir(this.pluginDirectory());
                antproject.setProperty("maven.compile.classpath", compileClasspath.toString());
                antproject.setProperty("project.dir", this.project().getBasedir().getAbsolutePath());
                String targetDir = this.project().getBuild().getDirectory();
                antproject.setProperty("target.dir", targetDir);
                antproject.setProperty("wsdl.dir", this.wsdlDirectory.getAbsolutePath());
                antproject.setProperty("wsdl.target.dir", this.wsdlOutputDirectory.getAbsolutePath());
                antproject.setProperty("service.id", this.getServiceId());
                antproject.setProperty("stubs.dir", this.outputDirectory.getAbsolutePath());
                antproject.setProperty("wsdl", wsdl.getName());
                antproject.setProperty("namespace", wsdl.getNamespace().toExternalForm());
                if (wsdl.getAdditionalMappings() != null && !wsdl.getAdditionalMappings().isEmpty() && wsdl.getAdditionalMappings().compareTo("null") != 0) {
                    antproject.setProperty("additionalMappings", wsdl.getAdditionalMappings());
                }
                String relativePackage = wsdl.getRelativePackage() == null ? "stubs" : wsdl.getRelativePackage();
                antproject.setProperty("package", String.valueOf(this.basePackage) + "." + relativePackage);
                antproject.init();
                DefaultLogger consoleLogger = new DefaultLogger();
                consoleLogger.setErrorPrintStream(System.err);
                consoleLogger.setOutputPrintStream(System.out);
                consoleLogger.setMessageOutputLevel(2);
                antproject.addBuildListener((BuildListener)consoleLogger);
                ProjectHelper helper = ProjectHelper.getProjectHelper();
                antproject.addReference("ant.projectHelper", (Object)helper);
                helper.parse(antproject, (Object)buildFile);
                antproject.executeTarget(antproject.getDefaultTarget());
                ++n2;
            }
            this.touchStaleFile();
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Error generating stubs:", t);
        }
        this.getLog().info((CharSequence)("adding source folder " + this.outputDirectory.getAbsolutePath()));
        this.project().addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
    }

    private boolean isOutputStale() {
        boolean stale;
        boolean bl = stale = !this.staleFile.exists();
        if (!stale) {
            long staleMod = this.staleFile.lastModified();
            Wsdl[] wsdlArray = this.wsdls;
            int n = this.wsdls.length;
            int n2 = 0;
            while (n2 < n) {
                Wsdl wsdl = wsdlArray[n2];
                File wsdlFile = new File(this.wsdlDirectory, String.valueOf(wsdl.getName()) + ".wsdl");
                if (wsdlFile.lastModified() > staleMod) {
                    this.getLog().debug((CharSequence)(String.valueOf(wsdlFile.getName()) + " is newer than the stale flag file"));
                    stale = true;
                }
                ++n2;
            }
        }
        return stale;
    }

    private void touchStaleFile() throws IOException {
        if (!this.staleFile.exists()) {
            this.staleFile.createNewFile();
            this.getLog().debug((CharSequence)"created stale flag file");
        } else {
            this.staleFile.setLastModified(System.currentTimeMillis());
        }
    }
}

