/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.serviceplugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.Expand;
import org.codehaus.plexus.util.IOUtil;
import org.gcube.serviceplugin.Constants;

public abstract class AbstractServiceMojo
extends AbstractMojo {
    private MavenProject project;
    private File pluginDirectory;
    private String serviceId;

    protected void preparePluginDirectory() throws Exception {
        if (this.pluginDirectory.exists() && this.pluginDirectory.listFiles().length > 0) {
            return;
        }
        this.getLog().info((CharSequence)"preparing build resources...");
        if (!this.pluginDirectory.exists() && !this.pluginDirectory.mkdirs()) {
            throw new Exception("Could not create directory " + this.pluginDirectory.getAbsolutePath());
        }
        try {
            this.getLog().info((CharSequence)"unpacking build resources...");
            File zip = new File(this.pluginDirectory, Constants.BUILD_RESOURCES_BUNDLE);
            IOUtil.copy((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/" + Constants.BUILD_RESOURCES_BUNDLE), (OutputStream)new FileOutputStream(zip));
            Expand expander = new Expand();
            expander.setSrc(zip);
            expander.setDest(this.pluginDirectory);
            expander.execute();
        }
        catch (Throwable e) {
            throw new Exception("Error copying build resources in " + this.pluginDirectory.getAbsolutePath(), e);
        }
    }

    public MavenProject project() {
        return this.project;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public File pluginDirectory() {
        return this.pluginDirectory;
    }

    public File antBuildFile() {
        return new File(this.pluginDirectory, "build.xml");
    }

    public String compileClasspath() throws Exception {
        StringBuilder compileClasspath = new StringBuilder();
        for (Object element : this.project().getCompileClasspathElements()) {
            compileClasspath.append(element).append(File.pathSeparator);
        }
        this.getLog().info((CharSequence)("bulding with classpath: " + compileClasspath.toString()));
        return compileClasspath.toString();
    }
}

