/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.serviceplugin;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;
import org.gcube.serviceplugin.AbstractServiceMojo;

public class LocalDeployMojo
extends AbstractServiceMojo {
    private File location;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (!(this.location.exists() && this.location.isDirectory() && this.location.canWrite())) {
                throw new MojoExecutionException(this.location + " does not exist, is not a directory, or is write-protected");
            }
            this.copyArtifacts(this.location);
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Could not deploy artifact and its dependencies", t);
        }
    }

    protected void copyArtifacts(File location) throws Exception {
        Artifact mainArtifact = this.project().getArtifact();
        File mainArtifactFile = mainArtifact.getFile();
        if (mainArtifactFile.exists() && !mainArtifactFile.isDirectory() && mainArtifact.getArtifactHandler().isAddedToClasspath()) {
            this.getLog().info((CharSequence)("copying main artifact " + mainArtifact + " to " + location));
            FileUtils.copyFile((File)mainArtifactFile, (File)new File(location, mainArtifactFile.getName()));
        }
        for (Artifact artifact : this.project().getAttachedArtifacts()) {
            if (!artifact.getArtifactHandler().isAddedToClasspath()) continue;
            this.getLog().info((CharSequence)("copying attached artefact " + artifact + " to " + location));
            FileUtils.copyFile((File)artifact.getFile(), (File)new File(location, artifact.getFile().getName()));
        }
        for (Object object : this.project().getArtifacts()) {
            Artifact artifact = (Artifact)object;
            this.getLog().info((CharSequence)("copying dependency " + artifact + " to " + location));
            FileUtils.copyFile((File)artifact.getFile(), (File)new File(location, artifact.getFile().getName()));
        }
    }
}

