/*
 * Decompiled with CFR 0.152.
 */
package org.gdal.gdal;

import java.awt.Color;
import java.awt.image.IndexColorModel;
import org.gdal.gdal.gdalJNI;

public class ColorTable
implements Cloneable {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    private Object parentReference;

    protected ColorTable(long cPtr, boolean cMemoryOwn) {
        if (cPtr == 0L) {
            throw new RuntimeException();
        }
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(ColorTable obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            gdalJNI.delete_ColorTable(this.swigCPtr);
        }
        this.swigCPtr = 0L;
    }

    protected void addReference(Object reference) {
        this.parentReference = reference;
    }

    public Object clone() {
        return this.Clone();
    }

    public IndexColorModel getIndexColorModel(int bits) {
        int size = this.GetCount();
        byte[] reds = new byte[size];
        byte[] greens = new byte[size];
        byte[] blues = new byte[size];
        byte[] alphas = new byte[size];
        int noAlphas = 0;
        int zeroAlphas = 0;
        int lastAlphaIndex = -1;
        Color entry = null;
        for (int i = 0; i < size; ++i) {
            entry = this.GetColorEntry(i);
            reds[i] = (byte)(entry.getRed() & 0xFF);
            greens[i] = (byte)(entry.getGreen() & 0xFF);
            blues[i] = (byte)(entry.getBlue() & 0xFF);
            byte alpha = (byte)(entry.getAlpha() & 0xFF);
            if (alpha == 255) {
                ++noAlphas;
            } else if (alpha == 0) {
                ++zeroAlphas;
                lastAlphaIndex = i;
            }
            alphas[i] = alpha;
        }
        if (noAlphas == size) {
            return new IndexColorModel(bits, size, reds, greens, blues);
        }
        if (noAlphas == size - 1 && zeroAlphas == 1) {
            return new IndexColorModel(bits, size, reds, greens, blues, lastAlphaIndex);
        }
        return new IndexColorModel(bits, size, reds, greens, blues, alphas);
    }

    public ColorTable(int palette) {
        this(gdalJNI.new_ColorTable__SWIG_0(palette), true);
    }

    public ColorTable() {
        this(gdalJNI.new_ColorTable__SWIG_1(), true);
    }

    public ColorTable Clone() {
        long cPtr = gdalJNI.ColorTable_Clone(this.swigCPtr);
        return cPtr == 0L ? null : new ColorTable(cPtr, true);
    }

    public int GetPaletteInterpretation() {
        return gdalJNI.ColorTable_GetPaletteInterpretation(this.swigCPtr);
    }

    public int GetCount() {
        return gdalJNI.ColorTable_GetCount(this.swigCPtr);
    }

    public Color GetColorEntry(int entry) {
        return gdalJNI.ColorTable_GetColorEntry(this.swigCPtr, entry);
    }

    public void SetColorEntry(int entry, Color centry) {
        gdalJNI.ColorTable_SetColorEntry(this.swigCPtr, entry, centry);
    }

    public void CreateColorRamp(int nStartIndex, Color startcolor, int nEndIndex, Color endcolor) {
        gdalJNI.ColorTable_CreateColorRamp(this.swigCPtr, nStartIndex, startcolor, nEndIndex, endcolor);
    }
}

