/*
 * Decompiled with CFR 0.152.
 */
package org.gdal.ogr;

import java.util.Vector;
import org.gdal.ogr.Driver;
import org.gdal.ogr.Geometry;
import org.gdal.ogr.Layer;
import org.gdal.ogr.ogrJNI;
import org.gdal.osr.SpatialReference;

public class DataSource {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected DataSource(long cPtr, boolean cMemoryOwn) {
        if (cPtr == 0L) {
            throw new RuntimeException();
        }
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(DataSource obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            ogrJNI.delete_DataSource(this.swigCPtr);
        }
        this.swigCPtr = 0L;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof DataSource) {
            equal = ((DataSource)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public Layer GetLayer(int index) {
        return this.GetLayerByIndex(index);
    }

    public Layer GetLayer(String layerName) {
        return this.GetLayerByName(layerName);
    }

    public String getName() {
        return ogrJNI.DataSource_name_get(this.swigCPtr);
    }

    public int GetRefCount() {
        return ogrJNI.DataSource_GetRefCount(this.swigCPtr);
    }

    public int GetSummaryRefCount() {
        return ogrJNI.DataSource_GetSummaryRefCount(this.swigCPtr);
    }

    public int GetLayerCount() {
        return ogrJNI.DataSource_GetLayerCount(this.swigCPtr);
    }

    public Driver GetDriver() {
        long cPtr = ogrJNI.DataSource_GetDriver(this.swigCPtr);
        return cPtr == 0L ? null : new Driver(cPtr, false);
    }

    public String GetName() {
        return ogrJNI.DataSource_GetName(this.swigCPtr);
    }

    public int DeleteLayer(int index) {
        return ogrJNI.DataSource_DeleteLayer(this.swigCPtr, index);
    }

    public Layer CreateLayer(String name, SpatialReference srs, int geom_type, Vector options) {
        long cPtr = ogrJNI.DataSource_CreateLayer__SWIG_0(this.swigCPtr, name, SpatialReference.getCPtr(srs), geom_type, options);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer CreateLayer(String name, SpatialReference srs, int geom_type) {
        long cPtr = ogrJNI.DataSource_CreateLayer__SWIG_1(this.swigCPtr, name, SpatialReference.getCPtr(srs), geom_type);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer CreateLayer(String name, SpatialReference srs) {
        long cPtr = ogrJNI.DataSource_CreateLayer__SWIG_2(this.swigCPtr, name, SpatialReference.getCPtr(srs));
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer CreateLayer(String name) {
        long cPtr = ogrJNI.DataSource_CreateLayer__SWIG_3(this.swigCPtr, name);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer CopyLayer(Layer src_layer, String new_name, Vector options) {
        long cPtr = ogrJNI.DataSource_CopyLayer__SWIG_0(this.swigCPtr, Layer.getCPtr(src_layer), new_name, options);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer CopyLayer(Layer src_layer, String new_name) {
        long cPtr = ogrJNI.DataSource_CopyLayer__SWIG_1(this.swigCPtr, Layer.getCPtr(src_layer), new_name);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer GetLayerByIndex(int index) {
        long cPtr = ogrJNI.DataSource_GetLayerByIndex(this.swigCPtr, index);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer GetLayerByName(String layer_name) {
        long cPtr = ogrJNI.DataSource_GetLayerByName(this.swigCPtr, layer_name);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public boolean TestCapability(String cap) {
        return ogrJNI.DataSource_TestCapability(this.swigCPtr, cap);
    }

    public Layer ExecuteSQL(String statement, Geometry spatialFilter, String dialect) {
        long cPtr = ogrJNI.DataSource_ExecuteSQL__SWIG_0(this.swigCPtr, statement, Geometry.getCPtr(spatialFilter), dialect);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer ExecuteSQL(String statement, Geometry spatialFilter) {
        long cPtr = ogrJNI.DataSource_ExecuteSQL__SWIG_1(this.swigCPtr, statement, Geometry.getCPtr(spatialFilter));
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer ExecuteSQL(String statement) {
        long cPtr = ogrJNI.DataSource_ExecuteSQL__SWIG_2(this.swigCPtr, statement);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public void ReleaseResultSet(Layer layer) {
        ogrJNI.DataSource_ReleaseResultSet(this.swigCPtr, Layer.getCPtrAndDisown(layer));
    }
}

