/*
 * Decompiled with CFR 0.152.
 */
package org.gdal.ogr;

import java.util.Vector;
import org.gdal.ogr.GeometryNative;
import org.gdal.ogr.ogr;
import org.gdal.ogr.ogrJNI;
import org.gdal.osr.CoordinateTransformation;
import org.gdal.osr.SpatialReference;

public class Geometry
implements Cloneable {
    private long swigCPtr;
    private GeometryNative nativeObject;
    private Object parentReference;

    protected Geometry(long cPtr, boolean cMemoryOwn) {
        if (cPtr == 0L) {
            throw new RuntimeException();
        }
        this.swigCPtr = cPtr;
        if (cMemoryOwn) {
            this.nativeObject = new GeometryNative(this, cPtr);
        }
    }

    protected static long getCPtr(Geometry obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public void delete() {
        if (this.nativeObject != null) {
            this.nativeObject.delete();
            this.nativeObject = null;
        }
    }

    protected static long getCPtrAndDisown(Geometry obj) {
        if (obj != null) {
            if (obj.nativeObject == null) {
                throw new RuntimeException("Cannot disown an object that was not owned...");
            }
            obj.nativeObject.dontDisposeNativeResources();
            obj.nativeObject = null;
            obj.parentReference = null;
        }
        return Geometry.getCPtr(obj);
    }

    protected void addReference(Object reference) {
        this.parentReference = reference;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof Geometry) {
            equal = this.Equal((Geometry)obj);
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public Object clone() {
        return this.Clone();
    }

    public double[] GetPoint_2D(int iPoint) {
        double[] coords = new double[2];
        this.GetPoint_2D(iPoint, coords);
        return coords;
    }

    public double[] GetPoint(int iPoint) {
        double[] coords = new double[3];
        this.GetPoint(iPoint, coords);
        return coords;
    }

    public static Geometry CreateFromWkt(String wkt) {
        return ogr.CreateGeometryFromWkt(wkt);
    }

    public static Geometry CreateFromWkb(byte[] wkb) {
        return ogr.CreateGeometryFromWkb(wkb);
    }

    public static Geometry CreateFromGML(String gml) {
        return ogr.CreateGeometryFromGML(gml);
    }

    public static Geometry CreateFromJson(String json) {
        return ogr.CreateGeometryFromJson(json);
    }

    public int ExportToWkb(byte[] wkbArray, int byte_order) {
        if (wkbArray == null) {
            throw new NullPointerException();
        }
        byte[] srcArray = this.ExportToWkb(byte_order);
        if (wkbArray.length < srcArray.length) {
            throw new RuntimeException("Array too small");
        }
        System.arraycopy(srcArray, 0, wkbArray, 0, srcArray.length);
        return 0;
    }

    public int ExportToWkt(String[] argout) {
        return ogrJNI.Geometry_ExportToWkt__SWIG_0(this.swigCPtr, argout);
    }

    public byte[] ExportToWkb(int byte_order) {
        return ogrJNI.Geometry_ExportToWkb__SWIG_0(this.swigCPtr, byte_order);
    }

    public byte[] ExportToWkb() {
        return ogrJNI.Geometry_ExportToWkb__SWIG_1(this.swigCPtr);
    }

    public String ExportToGML(Vector options) {
        return ogrJNI.Geometry_ExportToGML__SWIG_0(this.swigCPtr, options);
    }

    public String ExportToGML() {
        return ogrJNI.Geometry_ExportToGML__SWIG_1(this.swigCPtr);
    }

    public String ExportToKML(String altitude_mode) {
        return ogrJNI.Geometry_ExportToKML__SWIG_0(this.swigCPtr, altitude_mode);
    }

    public String ExportToKML() {
        return ogrJNI.Geometry_ExportToKML__SWIG_1(this.swigCPtr);
    }

    public String ExportToJson() {
        return ogrJNI.Geometry_ExportToJson(this.swigCPtr);
    }

    public void AddPoint(double x, double y, double z) {
        ogrJNI.Geometry_AddPoint__SWIG_0(this.swigCPtr, x, y, z);
    }

    public void AddPoint(double x, double y) {
        ogrJNI.Geometry_AddPoint__SWIG_1(this.swigCPtr, x, y);
    }

    public void AddPoint_2D(double x, double y) {
        ogrJNI.Geometry_AddPoint_2D(this.swigCPtr, x, y);
    }

    public int AddGeometryDirectly(Geometry other_disown) {
        int ret = ogrJNI.Geometry_AddGeometryDirectly(this.swigCPtr, Geometry.getCPtrAndDisown(other_disown));
        if (other_disown != null) {
            other_disown.addReference(this);
        }
        return ret;
    }

    public int AddGeometry(Geometry other) {
        return ogrJNI.Geometry_AddGeometry(this.swigCPtr, Geometry.getCPtr(other));
    }

    public Geometry Clone() {
        long cPtr = ogrJNI.Geometry_Clone(this.swigCPtr);
        return cPtr == 0L ? null : new Geometry(cPtr, true);
    }

    public int GetGeometryType() {
        return ogrJNI.Geometry_GetGeometryType(this.swigCPtr);
    }

    public String GetGeometryName() {
        return ogrJNI.Geometry_GetGeometryName(this.swigCPtr);
    }

    public double Length() {
        return ogrJNI.Geometry_Length(this.swigCPtr);
    }

    public double Area() {
        return ogrJNI.Geometry_Area(this.swigCPtr);
    }

    public double GetArea() {
        return ogrJNI.Geometry_GetArea(this.swigCPtr);
    }

    public int GetPointCount() {
        return ogrJNI.Geometry_GetPointCount(this.swigCPtr);
    }

    public double GetX(int point) {
        return ogrJNI.Geometry_GetX__SWIG_0(this.swigCPtr, point);
    }

    public double GetX() {
        return ogrJNI.Geometry_GetX__SWIG_1(this.swigCPtr);
    }

    public double GetY(int point) {
        return ogrJNI.Geometry_GetY__SWIG_0(this.swigCPtr, point);
    }

    public double GetY() {
        return ogrJNI.Geometry_GetY__SWIG_1(this.swigCPtr);
    }

    public double GetZ(int point) {
        return ogrJNI.Geometry_GetZ__SWIG_0(this.swigCPtr, point);
    }

    public double GetZ() {
        return ogrJNI.Geometry_GetZ__SWIG_1(this.swigCPtr);
    }

    public void GetPoint(int iPoint, double[] argout) {
        ogrJNI.Geometry_GetPoint(this.swigCPtr, iPoint, argout);
    }

    public void GetPoint_2D(int iPoint, double[] argout) {
        ogrJNI.Geometry_GetPoint_2D(this.swigCPtr, iPoint, argout);
    }

    public int GetGeometryCount() {
        return ogrJNI.Geometry_GetGeometryCount(this.swigCPtr);
    }

    public void SetPoint(int point, double x, double y, double z) {
        ogrJNI.Geometry_SetPoint__SWIG_0(this.swigCPtr, point, x, y, z);
    }

    public void SetPoint(int point, double x, double y) {
        ogrJNI.Geometry_SetPoint__SWIG_1(this.swigCPtr, point, x, y);
    }

    public void SetPoint_2D(int point, double x, double y) {
        ogrJNI.Geometry_SetPoint_2D(this.swigCPtr, point, x, y);
    }

    public Geometry GetGeometryRef(int geom) {
        long cPtr = ogrJNI.Geometry_GetGeometryRef(this.swigCPtr, geom);
        Geometry ret = null;
        if (cPtr != 0L) {
            ret = new Geometry(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Geometry Simplify(double tolerance) {
        long cPtr = ogrJNI.Geometry_Simplify(this.swigCPtr, tolerance);
        return cPtr == 0L ? null : new Geometry(cPtr, true);
    }

    public Geometry Boundary() {
        long cPtr = ogrJNI.Geometry_Boundary(this.swigCPtr);
        return cPtr == 0L ? null : new Geometry(cPtr, true);
    }

    public Geometry GetBoundary() {
        long cPtr = ogrJNI.Geometry_GetBoundary(this.swigCPtr);
        return cPtr == 0L ? null : new Geometry(cPtr, true);
    }

    public Geometry ConvexHull() {
        long cPtr = ogrJNI.Geometry_ConvexHull(this.swigCPtr);
        return cPtr == 0L ? null : new Geometry(cPtr, true);
    }

    public Geometry Buffer(double distance, int quadsecs) {
        long cPtr = ogrJNI.Geometry_Buffer__SWIG_0(this.swigCPtr, distance, quadsecs);
        return cPtr == 0L ? null : new Geometry(cPtr, true);
    }

    public Geometry Buffer(double distance) {
        long cPtr = ogrJNI.Geometry_Buffer__SWIG_1(this.swigCPtr, distance);
        return cPtr == 0L ? null : new Geometry(cPtr, true);
    }

    public Geometry Intersection(Geometry other) {
        long cPtr = ogrJNI.Geometry_Intersection(this.swigCPtr, Geometry.getCPtr(other));
        return cPtr == 0L ? null : new Geometry(cPtr, true);
    }

    public Geometry Union(Geometry other) {
        long cPtr = ogrJNI.Geometry_Union(this.swigCPtr, Geometry.getCPtr(other));
        return cPtr == 0L ? null : new Geometry(cPtr, true);
    }

    public Geometry UnionCascaded() {
        long cPtr = ogrJNI.Geometry_UnionCascaded(this.swigCPtr);
        return cPtr == 0L ? null : new Geometry(cPtr, true);
    }

    public Geometry Difference(Geometry other) {
        long cPtr = ogrJNI.Geometry_Difference(this.swigCPtr, Geometry.getCPtr(other));
        return cPtr == 0L ? null : new Geometry(cPtr, true);
    }

    public Geometry SymDifference(Geometry other) {
        long cPtr = ogrJNI.Geometry_SymDifference(this.swigCPtr, Geometry.getCPtr(other));
        return cPtr == 0L ? null : new Geometry(cPtr, true);
    }

    public Geometry SymmetricDifference(Geometry other) {
        long cPtr = ogrJNI.Geometry_SymmetricDifference(this.swigCPtr, Geometry.getCPtr(other));
        return cPtr == 0L ? null : new Geometry(cPtr, true);
    }

    public double Distance(Geometry other) {
        return ogrJNI.Geometry_Distance(this.swigCPtr, Geometry.getCPtr(other));
    }

    public void Empty() {
        ogrJNI.Geometry_Empty(this.swigCPtr);
    }

    public boolean IsEmpty() {
        return ogrJNI.Geometry_IsEmpty(this.swigCPtr);
    }

    public boolean IsValid() {
        return ogrJNI.Geometry_IsValid(this.swigCPtr);
    }

    public boolean IsSimple() {
        return ogrJNI.Geometry_IsSimple(this.swigCPtr);
    }

    public boolean IsRing() {
        return ogrJNI.Geometry_IsRing(this.swigCPtr);
    }

    public boolean Intersects(Geometry other) {
        return ogrJNI.Geometry_Intersects(this.swigCPtr, Geometry.getCPtr(other));
    }

    public boolean Intersect(Geometry other) {
        return ogrJNI.Geometry_Intersect(this.swigCPtr, Geometry.getCPtr(other));
    }

    public boolean Equals(Geometry other) {
        return ogrJNI.Geometry_Equals(this.swigCPtr, Geometry.getCPtr(other));
    }

    public boolean Equal(Geometry other) {
        return ogrJNI.Geometry_Equal(this.swigCPtr, Geometry.getCPtr(other));
    }

    public boolean Disjoint(Geometry other) {
        return ogrJNI.Geometry_Disjoint(this.swigCPtr, Geometry.getCPtr(other));
    }

    public boolean Touches(Geometry other) {
        return ogrJNI.Geometry_Touches(this.swigCPtr, Geometry.getCPtr(other));
    }

    public boolean Crosses(Geometry other) {
        return ogrJNI.Geometry_Crosses(this.swigCPtr, Geometry.getCPtr(other));
    }

    public boolean Within(Geometry other) {
        return ogrJNI.Geometry_Within(this.swigCPtr, Geometry.getCPtr(other));
    }

    public boolean Contains(Geometry other) {
        return ogrJNI.Geometry_Contains(this.swigCPtr, Geometry.getCPtr(other));
    }

    public boolean Overlaps(Geometry other) {
        return ogrJNI.Geometry_Overlaps(this.swigCPtr, Geometry.getCPtr(other));
    }

    public int TransformTo(SpatialReference reference) {
        return ogrJNI.Geometry_TransformTo(this.swigCPtr, SpatialReference.getCPtr(reference));
    }

    public int Transform(CoordinateTransformation trans) {
        return ogrJNI.Geometry_Transform(this.swigCPtr, CoordinateTransformation.getCPtr(trans));
    }

    public SpatialReference GetSpatialReference() {
        long cPtr = ogrJNI.Geometry_GetSpatialReference(this.swigCPtr);
        return cPtr == 0L ? null : new SpatialReference(cPtr, true);
    }

    public void AssignSpatialReference(SpatialReference reference) {
        ogrJNI.Geometry_AssignSpatialReference(this.swigCPtr, SpatialReference.getCPtr(reference));
    }

    public void CloseRings() {
        ogrJNI.Geometry_CloseRings(this.swigCPtr);
    }

    public void FlattenTo2D() {
        ogrJNI.Geometry_FlattenTo2D(this.swigCPtr);
    }

    public void Segmentize(double dfMaxLength) {
        ogrJNI.Geometry_Segmentize(this.swigCPtr, dfMaxLength);
    }

    public void GetEnvelope(double[] argout) {
        ogrJNI.Geometry_GetEnvelope(this.swigCPtr, argout);
    }

    public int WkbSize() {
        return ogrJNI.Geometry_WkbSize(this.swigCPtr);
    }

    public int GetCoordinateDimension() {
        return ogrJNI.Geometry_GetCoordinateDimension(this.swigCPtr);
    }

    public void SetCoordinateDimension(int dimension) {
        ogrJNI.Geometry_SetCoordinateDimension(this.swigCPtr, dimension);
    }

    public int GetDimension() {
        return ogrJNI.Geometry_GetDimension(this.swigCPtr);
    }

    public Geometry(int type, String wkt, byte[] nLen, String gml) {
        this(ogrJNI.new_Geometry__SWIG_0(type, wkt, nLen, gml), true);
    }

    public Geometry(int type) {
        this(ogrJNI.new_Geometry__SWIG_1(type), true);
    }

    public String ExportToWkt() {
        return ogrJNI.Geometry_ExportToWkt__SWIG_1(this.swigCPtr);
    }

    public Geometry Centroid() {
        long cPtr = ogrJNI.Geometry_Centroid(this.swigCPtr);
        return cPtr == 0L ? null : new Geometry(cPtr, true);
    }
}

