/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.profile;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.glite.authz.common.model.Action;
import org.glite.authz.common.model.Attribute;
import org.glite.authz.common.model.AttributeAssignment;
import org.glite.authz.common.model.Environment;
import org.glite.authz.common.model.Obligation;
import org.glite.authz.common.model.Request;
import org.glite.authz.common.model.Resource;
import org.glite.authz.common.model.Response;
import org.glite.authz.common.model.Result;
import org.glite.authz.common.model.Subject;
import org.glite.authz.common.model.util.Strings;
import org.glite.authz.common.profile.AuthorizationProfileConstants;
import org.glite.authz.common.security.PEMUtils;
import org.glite.authz.pep.profile.Profile;
import org.glite.authz.pep.profile.ProfileException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AuthorizationProfile
extends AuthorizationProfileConstants
implements Profile {
    private String profileId_;

    public Request createRequest(Subject subject, Resource resource, Action action, Environment environment) {
        Request request = new Request();
        if (subject != null) {
            request.getSubjects().add(subject);
        }
        if (resource != null) {
            request.getResources().add(resource);
        }
        if (action != null) {
            request.setAction(action);
        }
        if (environment != null) {
            request.setEnvironment(environment);
        }
        return request;
    }

    public Resource createResourceId(String resourceId) {
        Resource resource = new Resource();
        Attribute attrResourceId = new Attribute();
        attrResourceId.setId("urn:oasis:names:tc:xacml:1.0:resource:resource-id");
        attrResourceId.setDataType("http://www.w3.org/2001/XMLSchema#string");
        attrResourceId.getValues().add(resourceId);
        resource.getAttributes().add(attrResourceId);
        return resource;
    }

    public Action createActionId(String actionId) {
        Action action = new Action();
        Attribute attrActionId = new Attribute();
        attrActionId.setId("urn:oasis:names:tc:xacml:1.0:action:action-id");
        attrActionId.setDataType("http://www.w3.org/2001/XMLSchema#string");
        attrActionId.getValues().add(actionId);
        action.getAttributes().add(attrActionId);
        return action;
    }

    public Request createRequest(Subject subject, Resource resource, Action action) {
        return this.createRequest(subject, resource, action, this.createEnvironmentProfileId(this.getProfileId()));
    }

    public Obligation getObligation(Response response, int decision, String obligationId) throws ProfileException {
        List results = response.getResults();
        Iterator i$ = results.iterator();
        if (i$.hasNext()) {
            Result result = (Result)i$.next();
            if (result.getDecision() == decision) {
                List obligations = result.getObligations();
                for (Obligation obligation : obligations) {
                    String id = obligation.getId();
                    if (obligation.getFulfillOn() != decision || !obligationId.equals(id)) continue;
                    return obligation;
                }
                throw new ProfileException("No obligation " + obligationId + " found");
            }
            throw new ProfileException("No decision " + Result.decisionToString((int)decision) + " found: " + result.getDecisionString());
        }
        return null;
    }

    protected AuthorizationProfile(String profileId) {
        this.profileId_ = Strings.safeTrimOrNullString((String)profileId);
    }

    @Override
    public String getProfileId() {
        return this.profileId_;
    }

    public Environment createEnvironmentProfileId(String profileId) {
        Environment environment = new Environment();
        Attribute attrProfileId = new Attribute();
        attrProfileId.setId("http://glite.org/xacml/attribute/profile-id");
        attrProfileId.setDataType("http://www.w3.org/2001/XMLSchema#anyURI");
        attrProfileId.getValues().add(profileId);
        environment.getAttributes().add(attrProfileId);
        return environment;
    }

    public Request createRequest(X509Certificate[] certs, String resourceid, String actionid) throws ProfileException {
        Subject subject = this.createSubjectKeyInfo(certs);
        Resource resource = this.createResourceId(resourceid);
        Action action = this.createActionId(actionid);
        Request request = this.createRequest(subject, resource, action);
        return request;
    }

    public Subject createSubjectKeyInfo(X509Certificate cert) throws ProfileException {
        return this.createSubjectKeyInfo(cert, null);
    }

    public Subject createSubjectKeyInfo(X509Certificate[] certs) throws ProfileException {
        return this.createSubjectKeyInfo(null, certs);
    }

    public Subject createSubjectKeyInfo(X509Certificate cert, X509Certificate[] chain) throws ProfileException {
        String keyInfo;
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        if (cert != null) {
            certs.add(cert);
        }
        if (chain != null) {
            for (X509Certificate chainCert : chain) {
                certs.add(chainCert);
            }
        }
        try {
            keyInfo = PEMUtils.certificatesToPEMString(certs);
        }
        catch (IOException e) {
            throw new ProfileException("Can not convert certificate to PEM format", e);
        }
        Subject subject = new Subject();
        Attribute attrKeyInfo = new Attribute();
        attrKeyInfo.setId("urn:oasis:names:tc:xacml:1.0:subject:key-info");
        attrKeyInfo.setDataType("http://www.w3.org/2001/XMLSchema#string");
        attrKeyInfo.getValues().add(keyInfo);
        subject.getAttributes().add(attrKeyInfo);
        return subject;
    }

    public Obligation getObligationPosixMapping(Response response) throws ProfileException {
        Obligation posixMappingObligation = this.getObligation(response, 1, "http://glite.org/xacml/obligation/local-environment-map/posix");
        return posixMappingObligation;
    }

    public String getAttributeAssignmentUserId(Obligation posixMappingObligation) throws ProfileException {
        if (!"http://glite.org/xacml/obligation/local-environment-map/posix".equals(posixMappingObligation.getId())) {
            throw new ProfileException("Obligation is not http://glite.org/xacml/obligation/local-environment-map/posix but " + posixMappingObligation.getId());
        }
        List attributes = posixMappingObligation.getAttributeAssignments();
        for (AttributeAssignment attribute : attributes) {
            String id = attribute.getAttributeId();
            if (!"http://glite.org/xacml/attribute/user-id".equals(id)) continue;
            String userId = Strings.safeTrimOrNullString((String)attribute.getValue());
            if (userId == null) {
                throw new ProfileException("Attribute assignment http://glite.org/xacml/attribute/user-id found in obligation, but with an empty or null value");
            }
            return userId;
        }
        throw new ProfileException("Mandatory attribute assignment http://glite.org/xacml/attribute/user-id not found in obligation http://glite.org/xacml/obligation/local-environment-map/posix");
    }

    public List<String> getAttributeAssignmentGroupIds(Obligation posixMappingObligation) throws ProfileException {
        if (!"http://glite.org/xacml/obligation/local-environment-map/posix".equals(posixMappingObligation.getId())) {
            throw new ProfileException("Obligation is not http://glite.org/xacml/obligation/local-environment-map/posix");
        }
        ArrayList<String> groupIds = new ArrayList<String>();
        List attributes = posixMappingObligation.getAttributeAssignments();
        for (AttributeAssignment attribute : attributes) {
            String id = attribute.getAttributeId();
            if (!"http://glite.org/xacml/attribute/group-id".equals(id)) continue;
            groupIds.add(attribute.getValue());
        }
        return groupIds;
    }

    public String getAttributeAssignmentPrimaryGroupId(Obligation posixMappingObligation) throws ProfileException {
        if (!"http://glite.org/xacml/obligation/local-environment-map/posix".equals(posixMappingObligation.getId())) {
            throw new ProfileException("Obligation is not http://glite.org/xacml/obligation/local-environment-map/posix");
        }
        List attributes = posixMappingObligation.getAttributeAssignments();
        for (AttributeAssignment attribute : attributes) {
            String id = attribute.getAttributeId();
            if (!"http://glite.org/xacml/attribute/group-id/primary".equals(id)) continue;
            String groupId = attribute.getValue();
            return groupId;
        }
        return null;
    }
}

