/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.model;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import org.glite.authz.common.model.Action;
import org.glite.authz.common.model.Environment;
import org.glite.authz.common.model.Resource;
import org.glite.authz.common.model.Subject;
import org.glite.authz.common.model.util.LazySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Request
implements Serializable {
    private static final long serialVersionUID = 7263488106115027959L;
    private Set<Subject> subjects = new LazySet<Subject>();
    private Set<Resource> resources = new LazySet<Resource>();
    private Action action;
    private Environment environment;

    public Set<Subject> getSubjects() {
        return this.subjects;
    }

    public Set<Resource> getResources() {
        return this.resources;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action newAction) {
        this.action = newAction;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment newEnvironment) {
        this.environment = newEnvironment;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request{ ");
        stringBuilder.append("subjects:[");
        Iterator<Subject> iterator = this.subjects.iterator();
        while (iterator.hasNext()) {
            Subject subject = iterator.next();
            stringBuilder.append(subject);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("], ");
        stringBuilder.append("resources:[");
        Iterator<Resource> it = this.resources.iterator();
        while (it.hasNext()) {
            Resource resource = it.next();
            stringBuilder.append(resource);
            if (!it.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("], ");
        stringBuilder.append("action: ").append(this.action).append(", ");
        stringBuilder.append("environment: ").append(this.environment);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int hash = 13;
        hash = 31 * hash + (null == this.action ? 0 : this.action.hashCode());
        hash = 31 * hash + (null == this.environment ? 0 : this.environment.hashCode());
        hash = 31 * hash + ((Object)this.resources).hashCode();
        hash = 31 * hash + ((Object)this.subjects).hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Request otherRequest = (Request)obj;
        boolean actionsEqual = this.action == null ? otherRequest.getAction() == null : this.action.equals(otherRequest.getAction());
        boolean environmentsEqual = this.environment == null ? otherRequest.getEnvironment() == null : this.environment.equals(otherRequest.getEnvironment());
        return actionsEqual && environmentsEqual && ((Object)this.resources).equals(otherRequest.getResources()) && ((Object)this.subjects).equals(otherRequest.getSubjects());
    }
}

