/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.model;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.glite.authz.common.model.Obligation;
import org.glite.authz.common.model.Status;
import org.glite.authz.common.model.util.LazyList;
import org.glite.authz.common.model.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Result
implements Serializable {
    public static final int DECISION_DENY = 0;
    public static final int DECISION_PERMIT = 1;
    public static final int DECISION_INDETERMINATE = 2;
    public static final int DECISION_NOT_APPLICABLE = 3;
    private static final long serialVersionUID = 6419281476715041885L;
    private int decision;
    private String resourceId;
    private Status status;
    private List<Obligation> obligations = new LazyList<Obligation>();

    public int getDecision() {
        return this.decision;
    }

    public String getDecisionString() {
        return Result.decisionToString(this.decision);
    }

    public static String decisionToString(int decisionValue) {
        switch (decisionValue) {
            case 0: {
                return "Deny";
            }
            case 1: {
                return "Permit";
            }
            case 2: {
                return "Indeterminate";
            }
            case 3: {
                return "NotApplicable";
            }
        }
        return null;
    }

    public void setDecision(int newDecision) {
        if (newDecision != 0 && newDecision != 1 && newDecision != 2 && newDecision != 3) {
            throw new IllegalArgumentException("Invalid decision value");
        }
        this.decision = newDecision;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String id) {
        this.resourceId = Strings.safeTrimOrNullString(id);
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status newStatus) {
        this.status = newStatus;
    }

    public List<Obligation> getObligations() {
        return this.obligations;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Result{ ");
        stringBuilder.append("decision(").append(this.decision).append("): ").append(Result.decisionToString(this.decision)).append(", ");
        stringBuilder.append("resourceId: ").append(this.resourceId).append(", ");
        stringBuilder.append("status: ").append(this.status).append(", ");
        stringBuilder.append("obligations:[");
        Iterator<Obligation> iterator = this.obligations.iterator();
        while (iterator.hasNext()) {
            Obligation obligation = iterator.next();
            stringBuilder.append(obligation);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int hash = 13;
        hash = 31 * hash + this.decision;
        hash = 31 * hash + (null == this.resourceId ? 0 : this.resourceId.hashCode());
        hash = 31 * hash + ((Object)this.obligations).hashCode();
        hash = 31 * hash + (null == this.status ? 0 : this.status.hashCode());
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Result otherResult = (Result)obj;
        boolean statsEqual = this.status == null ? otherResult.getStatus() == null : this.status.equals(otherResult.getStatus());
        return this.decision == otherResult.getDecision() && Strings.safeEquals(this.resourceId, otherResult.getResourceId()) && ((Object)this.obligations).equals(otherResult.getObligations()) && statsEqual;
    }
}

