/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.model;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import org.glite.authz.common.model.Attribute;
import org.glite.authz.common.model.util.LazySet;
import org.glite.authz.common.model.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Subject
implements Serializable {
    private static final long serialVersionUID = 8938715874477342336L;
    private String category;
    private Set<Attribute> attributes = new LazySet<Attribute>();

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String newCategory) {
        this.category = Strings.safeTrimOrNullString(newCategory);
    }

    public Set<Attribute> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Subject{ ");
        stringBuilder.append("category: ").append(this.category).append(", ");
        stringBuilder.append("attributes:[");
        Iterator<Attribute> iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            stringBuilder.append(attribute);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int hash = 13;
        hash = 31 * hash + (null == this.category ? 0 : this.category.hashCode());
        hash = 31 * hash + ((Object)this.attributes).hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Subject otherSubject = (Subject)obj;
        return Strings.safeEquals(this.category, otherSubject.getCategory()) && ((Object)this.attributes).equals(otherSubject.getAttributes());
    }
}

