/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.actions.requests;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.glite.security.voms.admin.actionforms.ConfirmRequestForm;
import org.glite.security.voms.admin.actions.BaseAction;
import org.glite.security.voms.admin.common.NotFoundException;
import org.glite.security.voms.admin.common.VOMSConfiguration;
import org.glite.security.voms.admin.dao.RequestDAO;
import org.glite.security.voms.admin.database.AlreadyConfirmedRequestException;
import org.glite.security.voms.admin.database.ConfirmationRequestException;
import org.glite.security.voms.admin.model.VOMembershipRequest;

public class CancelRequestAction
extends BaseAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ConfirmRequestForm rForm = (ConfirmRequestForm)form;
        if (!VOMSConfiguration.instance().getBoolean("voms.request.webui.enabled", true)) {
            return mapping.findForward("registrationDisabled");
        }
        Long id = rForm.getRequestId();
        VOMembershipRequest req = RequestDAO.instance().findById(id);
        if (req == null) {
            throw new NotFoundException("Request with id:" + id + " not found in database!");
        }
        if (!req.getStatus().equals(VOMembershipRequest.SUBMITTED)) {
            throw new AlreadyConfirmedRequestException("Cannot cancel an already confirmed request!");
        }
        if (!rForm.getConfirmId().equals(req.getConfirmId())) {
            throw new ConfirmationRequestException("Wrong confirmation id for request #:" + id);
        }
        RequestDAO.instance().delete(req);
        return this.findSuccess(mapping);
    }
}

