/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.actions.requests;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.glite.security.voms.admin.actionforms.ConfirmRequestForm;
import org.glite.security.voms.admin.actions.BaseAction;
import org.glite.security.voms.admin.common.NotFoundException;
import org.glite.security.voms.admin.common.VOMSConfiguration;
import org.glite.security.voms.admin.dao.RequestDAO;
import org.glite.security.voms.admin.database.AlreadyConfirmedRequestException;
import org.glite.security.voms.admin.database.ConfirmationRequestException;
import org.glite.security.voms.admin.model.VOMSAdmin;
import org.glite.security.voms.admin.model.VOMembershipRequest;
import org.glite.security.voms.admin.notification.HandleRequestNotification;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;

public class ConfirmRequestAction
extends BaseAction {
    private static final Log log = LogFactory.getLog(ConfirmRequestAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ConfirmRequestForm rForm = (ConfirmRequestForm)form;
        if (!VOMSConfiguration.instance().getBoolean("voms.request.webui.enabled", true)) {
            return mapping.findForward("registrationDisabled");
        }
        Long id = rForm.getRequestId();
        VOMembershipRequest req = RequestDAO.instance().findById(id);
        if (req == null) {
            throw new NotFoundException("Request with id:" + id + " not found in database!");
        }
        log.debug((Object)("req id:" + id));
        log.debug((Object)("confirm id: {received: " + rForm.getConfirmId() + "} {expected: " + req.getConfirmId() + "}"));
        if (!req.getStatus().equals(VOMembershipRequest.SUBMITTED)) {
            throw new AlreadyConfirmedRequestException("Cannot confirm an already confirmed request!");
        }
        if (!rForm.getConfirmId().equals(req.getConfirmId())) {
            throw new ConfirmationRequestException("Wrong confirmation id for request #:" + id);
        }
        req.setStatus(VOMembershipRequest.CONFIRMED);
        RequestDAO.instance().save(req);
        ActionForward fw = mapping.findForward("pendingRequests");
        String reqManURL = this.getBaseContext(request) + fw.getPath();
        VOMSContext voContext = VOMSContext.getVoContext();
        Set c = voContext.getACL().getAdminsWithPermissions(VOMSPermission.getRequestsRWPermissions());
        HandleRequestNotification n = new HandleRequestNotification(req, reqManURL);
        if (c.isEmpty()) {
            log.debug((Object)"No admins found with required permissions!");
            String adminEmail = VOMSConfiguration.instance().getString("voms.notification.email-address");
            n.addRecipient(adminEmail);
            n.send();
        } else {
            for (VOMSAdmin a : c) {
                n.addAdminToRecipients(a);
            }
            if (n.getRecipientList().isEmpty()) {
                String adminEmail = VOMSConfiguration.instance().getString("voms.notification.email-address");
                n.addRecipient(adminEmail);
            }
            n.send();
        }
        return this.findSuccess(mapping);
    }
}

