/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.actions.requests;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.glite.security.voms.admin.actionforms.SubmitRequestActionForm;
import org.glite.security.voms.admin.actions.BaseAction;
import org.glite.security.voms.admin.common.VOMSConfiguration;
import org.glite.security.voms.admin.dao.RequestDAO;
import org.glite.security.voms.admin.model.VOMembershipRequest;
import org.glite.security.voms.admin.notification.ConfirmRequestNotification;
import org.glite.security.voms.admin.request.VOMSNotificationException;

public class SubmitRequestAction
extends BaseAction {
    private String buildConfirmURL(HttpServletRequest request, VOMembershipRequest membReq) {
        return this.getBaseContext(request) + "/ConfirmVOMembershipRequest.do?requestId=" + membReq.getId() + "&confirmId=" + membReq.getConfirmId();
    }

    private String buildCancelURL(HttpServletRequest request, VOMembershipRequest membReq) {
        return this.getBaseContext(request) + "/CancelVOMembershipRequest.do?requestId=" + membReq.getId() + "&confirmId=" + membReq.getConfirmId();
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubmitRequestActionForm sForm = (SubmitRequestActionForm)form;
        String emailAddress = sForm.getEmailAddress();
        VOMembershipRequest req = RequestDAO.instance().findFromAdmin();
        if (!VOMSConfiguration.instance().getBoolean("voms.request.webui.enabled", true)) {
            return mapping.findForward("registrationDisabled");
        }
        if (req != null) {
            return this.findSuccess(mapping);
        }
        req = RequestDAO.instance().createFromAdmin(emailAddress);
        String confirmURL = this.buildConfirmURL(request, req);
        String cancelURL = this.buildCancelURL(request, req);
        ConfirmRequestNotification n = new ConfirmRequestNotification(emailAddress, confirmURL, cancelURL);
        try {
            n.send();
        }
        catch (VOMSNotificationException e) {
            this.log.error((Object)"Error sending notification for request!", (Throwable)e);
            this.log.error((Object)"Request will be discarded.");
            RequestDAO.instance().delete(req);
        }
        return this.findSuccess(mapping);
    }
}

