/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.actions.role;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.glite.security.voms.admin.actionforms.RoleActionsForm;
import org.glite.security.voms.admin.actions.BaseAction;
import org.glite.security.voms.admin.common.VOMSConfiguration;
import org.glite.security.voms.admin.dao.SearchResults;
import org.glite.security.voms.admin.dao.VOMSAttributeDAO;
import org.glite.security.voms.admin.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.model.VOMSGroup;
import org.glite.security.voms.admin.model.VOMSRole;
import org.glite.security.voms.admin.operations.groups.ListGroupsOperation;
import org.glite.security.voms.admin.operations.groups.SearchMembersOperation;
import org.glite.security.voms.admin.operations.roles.FindRoleOperation;

public class LoadRoleAction
extends BaseAction {
    private static final Log log = LogFactory.getLog(LoadRoleAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RoleActionsForm rForm = (RoleActionsForm)form;
        log.debug((Object)rForm);
        VOMSRole r = this.getRoleFromRequest(request);
        if (r == null) {
            r = (VOMSRole)FindRoleOperation.instance(rForm.getId()).execute();
            this.storeRole(request, r);
        }
        List allGroups = (List)ListGroupsOperation.instance().execute();
        request.setAttribute("allGroups", (Object)allGroups);
        VOMSGroup g = this.getGroupFromRequest(request);
        if (g == null) {
            g = VOMSGroupDAO.instance().getVOGroup();
            this.storeGroup(request, g);
        }
        int maxResults = VOMSConfiguration.instance().getInt("voms.pagination.user.max.results.per.page", 15);
        SearchResults results = this.getResultsFromRequest(request);
        if (results == null) {
            results = (SearchResults)SearchMembersOperation.instance(g, r, null, 0, maxResults).execute();
        }
        this.storeResults(request, results);
        List attributeDescriptions = VOMSAttributeDAO.instance().getAllAttributeDescriptions();
        request.setAttribute("attributeDescriptions", (Object)attributeDescriptions);
        return this.findSuccess(mapping);
    }
}

