/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.actions.user;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.glite.security.voms.admin.actionforms.MembershipActionsForm;
import org.glite.security.voms.admin.actions.BaseDispatchAction;
import org.glite.security.voms.admin.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.dao.VOMSRoleDAO;
import org.glite.security.voms.admin.dao.VOMSUserDAO;
import org.glite.security.voms.admin.model.VOMSGroup;
import org.glite.security.voms.admin.model.VOMSRole;
import org.glite.security.voms.admin.model.VOMSUser;
import org.glite.security.voms.admin.operations.groups.AddMemberOperation;
import org.glite.security.voms.admin.operations.groups.RemoveMemberOperation;
import org.glite.security.voms.admin.operations.users.AssignRoleOperation;
import org.glite.security.voms.admin.operations.users.DismissRoleOperation;

public class MembershipActions
extends BaseDispatchAction {
    private static final Log log = LogFactory.getLog(MembershipActions.class);

    public ActionForward addToGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionMessages msgs = new ActionMessages();
        MembershipActionsForm mForm = (MembershipActionsForm)form;
        log.debug((Object)("mForm: " + (Object)((Object)mForm)));
        VOMSUser u = VOMSUserDAO.instance().findById(mForm.getUserId());
        VOMSGroup g = VOMSGroupDAO.instance().findById(mForm.getGroupId());
        this.storeUser(request, u);
        this.storeGroup(request, g);
        AddMemberOperation.instance(u, g).execute();
        msgs.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("confirm.user.add_to_group", (Object)u.getDn(), (Object)g.getName()));
        this.saveMessages(request, msgs);
        return this.findSuccess(mapping);
    }

    public ActionForward removeFromGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionMessages msgs = new ActionMessages();
        MembershipActionsForm mForm = (MembershipActionsForm)form;
        log.debug((Object)("mForm: " + (Object)((Object)mForm)));
        VOMSUser u = VOMSUserDAO.instance().findById(mForm.getUserId());
        VOMSGroup g = VOMSGroupDAO.instance().findById(mForm.getGroupId());
        this.storeUser(request, u);
        this.storeGroup(request, g);
        RemoveMemberOperation.instance(u, g).execute();
        msgs.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("confirm.user.remove_from_group", (Object)u.getDn(), (Object)g.getName()));
        this.saveMessages(request, msgs);
        return this.findSuccess(mapping);
    }

    public ActionForward assignRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MembershipActionsForm mForm = (MembershipActionsForm)form;
        log.debug((Object)("mForm: " + (Object)((Object)mForm)));
        VOMSUser u = VOMSUserDAO.instance().findById(mForm.getUserId());
        VOMSGroup g = VOMSGroupDAO.instance().findById(mForm.getGroupId());
        VOMSRole r = VOMSRoleDAO.instance().findById(mForm.getRoleId());
        this.storeUser(request, u);
        this.storeGroup(request, g);
        this.storeRole(request, r);
        AssignRoleOperation.instance(u, g, r).execute();
        ActionMessages msgs = new ActionMessages();
        msgs.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("confirm.user.assign_role", (Object)u.getDn(), (Object)r.getName(), (Object)g.getName()));
        this.saveMessages(request, msgs);
        return this.findSuccess(mapping);
    }

    public ActionForward dismissRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MembershipActionsForm mForm = (MembershipActionsForm)form;
        log.debug((Object)("mForm: " + (Object)((Object)mForm)));
        VOMSUser u = VOMSUserDAO.instance().findById(mForm.getUserId());
        VOMSGroup g = VOMSGroupDAO.instance().findById(mForm.getGroupId());
        VOMSRole r = VOMSRoleDAO.instance().findById(mForm.getRoleId());
        this.storeUser(request, u);
        this.storeGroup(request, g);
        this.storeRole(request, r);
        DismissRoleOperation.instance(u, g, r).execute();
        ActionMessages msgs = new ActionMessages();
        msgs.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("confirm.user.dismiss_role", (Object)u.getDn(), (Object)r.getName(), (Object)g.getName()));
        this.saveMessages(request, msgs);
        return this.findSuccess(mapping);
    }
}

