/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;

public class DNUtil {
    private static final String PROXY_PATTERN = "^CN=((limited )*proxy)$";
    private static final String[] OID_REGEX = new String[]{"^OID.1.2.840.113549.1.9.1=", "^OID.0.9.2342.19200300.100.1.25=", "^OID.0.9.2342.19200300.100.1.1="};
    private static final String[] OID_NAME = new String[]{"Email=", "DC=", "UID="};

    public static String getBCasX500(X500Principal principal) {
        String[] rdns = principal.getName("RFC1779").split(", ");
        StringBuffer name = new StringBuffer();
        for (int i = rdns.length - 1; i >= 0; --i) {
            if (rdns[i].matches(PROXY_PATTERN)) continue;
            for (int o = 0; o < OID_REGEX.length; ++o) {
                rdns[i] = rdns[i].replaceFirst(OID_REGEX[o], OID_NAME[o]);
            }
            name.append("/").append(rdns[i]);
        }
        return name.toString();
    }

    public static String normalizeEmailAddressInDN(String dn) {
        return dn.replaceAll("/(E|e|((E|e|)(mail|mailAddress|mailaddress|MAIL|MAILADDRESS)))=", "/Email=");
    }

    public static String normalizeUIDInDN(String dn) {
        return dn.replaceAll("/(UserId|USERID|userId|userid|uid|Uid)=", "/UID=");
    }

    public static String normalizeDN(String dn) {
        return DNUtil.normalizeUIDInDN(DNUtil.normalizeEmailAddressInDN(dn));
    }

    public static String getEmailAddressFromDN(String dn) {
        Pattern emailPattern = Pattern.compile("Email=([^/]*)");
        Matcher m = emailPattern.matcher(dn);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }
}

