/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.common;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import javax.servlet.ServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glite.security.SecurityContext;
import org.glite.security.voms.admin.common.DNUtil;
import org.glite.security.voms.admin.common.VOMSConfiguration;
import org.glite.security.voms.admin.common.VOMSSecurityException;

public class InitSecurityContext {
    protected static Log log = LogFactory.getLog(InitSecurityContext.class);

    public static void setContextFromRequest(ServletRequest req) {
        log.debug((Object)"Creating a new security context");
        SecurityContext sc = new SecurityContext();
        SecurityContext.setCurrentContext((SecurityContext)sc);
        String remote = req.getRemoteAddr();
        sc.setProperty("org.glite.security.voms.remote_address", remote);
        X509Certificate[] cert = null;
        try {
            cert = (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate");
        }
        catch (Exception e) {
            log.warn((Object)("Exception during certificate chain retrieval: " + e));
        }
        if (cert == null) {
            log.info((Object)("Unauthenticated connection from \"" + remote + "\""));
            if (VOMSConfiguration.instance().getBoolean("voms.localhost.defaults.to.local.admin", false) && remote != null && ("127.0.0.1".equals(remote) || "0:0:0:0:0:0:0:1".equals(remote))) {
                log.warn((Object)"*** Overriding null credentials from localhost with Local Database Admin ***");
                sc.setClientName("/O=VOMS/O=System/CN=Local Database Administrator");
                sc.setIssuerName("/O=VOMS/O=System/CN=Dummy Certificate Authority");
            } else {
                sc.setClientName("/O=VOMS/O=System/CN=Unauthenticated Client");
                sc.setIssuerName("/O=VOMS/O=System/CN=Dummy Certificate Authority");
            }
        } else {
            sc.setClientCertChain(cert);
            if (sc.getClientName() != null) {
                sc.setClientName(DNUtil.getBCasX500(sc.getClientCert().getSubjectX500Principal()));
            }
            if (sc.getIssuerName() != null) {
                sc.setIssuerName(DNUtil.getBCasX500(sc.getClientCert().getIssuerX500Principal()));
            }
            String clientName = sc.getClientName();
            String issuerName = sc.getIssuerName();
            BigInteger sn = sc.getClientCert().getSerialNumber();
            String serialNumber = sn == null ? "NULL" : sn.toString();
            log.info((Object)("Connection from \"" + remote + "\" by " + clientName + " (issued by \"" + issuerName + "\", " + "serial " + serialNumber + ")"));
            if (sc.getClientName() != null && sc.getClientName().startsWith("/O=VOMS/O=System")) {
                log.error((Object)("Client name starts with internal prefix, discarding credentials: " + sc.getClientName()));
                sc.setClientName("/O=VOMS/O=System/CN=Unauthenticated Client");
                sc.setIssuerName("/O=VOMS/O=System/CN=Dummy Certificate Authority");
            } else if (sc.getIssuerName() != null && sc.getIssuerName().startsWith("/O=VOMS/O=System")) {
                log.error((Object)("Client issuer starts with internal prefix, discarding credentials: " + sc.getClientName()));
                sc.setClientName("/O=VOMS/O=System/CN=Unauthenticated Client");
                sc.setIssuerName("/O=VOMS/O=System/CN=Dummy Certificate Authority");
            }
        }
    }

    public static void setDelegatedContext(String delegatedDN, String delegatedCA) throws VOMSSecurityException {
        log.info((Object)"Initializing the delegated security context");
        SecurityContext sc = SecurityContext.getCurrentContext();
        if (sc == null) {
            throw new VOMSSecurityException("No security context for delegation?");
        }
        String validDN = VOMSConfiguration.instance().getString("voms.fully.trusted.client.for.delegation.dn");
        if (validDN == null || validDN.equals("/O=VOMS/O=System/CN=Local Database Administrator")) {
            throw new VOMSSecurityException("No valid trusted DN is configured");
        }
        if (!validDN.equals(sc.getClientName())) {
            throw new VOMSSecurityException("Client is not trusted for delegation: " + sc.getClientName());
        }
        String validCA = VOMSConfiguration.instance().getString("voms.fully.trusted.client.for.delegation.ca");
        if (validCA == null || validCA.equals("/O=VOMS/O=System/CN=Dummy Certificate Authority")) {
            throw new VOMSSecurityException("No valid trusted CA is configured");
        }
        if (!validCA.equals(sc.getIssuerName())) {
            throw new VOMSSecurityException("CA is not trusted for delegation: " + sc.getIssuerName());
        }
        log.info((Object)("Trusted client (" + sc.getClientName() + ", " + sc.getIssuerName() + ") sets delegated credentials (" + delegatedDN + ", " + delegatedCA + ")"));
        sc.setClientName(delegatedDN);
        sc.setIssuerName(delegatedCA);
    }

    public static void setLocalContext(String host) {
        log.debug((Object)"Initializing the local admin's security context");
        SecurityContext sc = new SecurityContext();
        SecurityContext.setCurrentContext((SecurityContext)sc);
        sc.setClientName("/O=VOMS/O=System/CN=Local Database Administrator");
        sc.setIssuerName("/O=VOMS/O=System/CN=Dummy Certificate Authority");
        if (host != null) {
            sc.setProperty("org.glite.security.voms.remote_address", host);
        }
    }

    public static void setInternalContext() {
        log.debug((Object)"Initializing the internal admin's security context");
        SecurityContext sc = new SecurityContext();
        SecurityContext.setCurrentContext((SecurityContext)sc);
        sc.setClientName("/O=VOMS/O=System/CN=Internal VOMS Process");
        sc.setIssuerName("/O=VOMS/O=System/CN=Dummy Certificate Authority");
    }

    public static void setClearContext() {
        log.info((Object)"Clearing the security context");
        SecurityContext sc = new SecurityContext();
        SecurityContext.setCurrentContext((SecurityContext)sc);
        sc.setClientName("/O=VOMS/O=System/CN=Unauthenticated Client");
        sc.setIssuerName("/O=VOMS/O=System/CN=Dummy Certificate Authority");
    }
}

