/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glite.security.voms.admin.common.NullArgumentException;
import org.glite.security.voms.admin.common.VOMSConfiguration;
import org.glite.security.voms.admin.common.VOMSSyntaxException;

public class PathNamingScheme {
    public static final Log log = LogFactory.getLog(PathNamingScheme.class);
    public static final String containerSyntax = "^(/[\\w.-]+)+|((/[\\w.-]+)+/)?(Role=[\\w.-]+)|(Capability=[\\w\\s.-]+)$";
    public static final String groupSyntax = "^(/[\\w.-]+)+$";
    public static final String roleSyntax = "^Role=[\\w.-]+$";
    public static final String qualifiedRoleSyntax = "^(/[\\w.-]+)+/Role=[\\w.-]+$";
    public static final String capabilitySyntax = "^Capability=[\\w\\s.-]+$";
    public static final Pattern containerPattern = Pattern.compile("^(/[\\w.-]+)+|((/[\\w.-]+)+/)?(Role=[\\w.-]+)|(Capability=[\\w\\s.-]+)$");
    public static final Pattern groupPattern = Pattern.compile("^(/[\\w.-]+)+$");
    public static final Pattern rolePattern = Pattern.compile("^Role=[\\w.-]+$");
    public static final Pattern qualifiedRolePattern = Pattern.compile("^(/[\\w.-]+)+/Role=[\\w.-]+$");
    public static final Pattern capabilityPattern = Pattern.compile("^Capability=[\\w\\s.-]+$");

    public static void checkSyntax(String containerName) {
        if (containerName == null) {
            throw new NullArgumentException("containerName ==  null");
        }
        if (containerName.length() > 255) {
            throw new VOMSSyntaxException("containerName.length() > 255");
        }
        if (!containerPattern.matcher(containerName).matches()) {
            throw new VOMSSyntaxException("Syntax error in container name: " + containerName);
        }
    }

    public static void checkGroup(String groupName) {
        PathNamingScheme.checkSyntax(groupName);
        if (!groupPattern.matcher(groupName).matches()) {
            throw new VOMSSyntaxException("Syntax error in group name: " + groupName);
        }
    }

    public static void checkRole(String roleName) {
        if (roleName == null) {
            throw new NullArgumentException("roleName == null");
        }
        if (roleName.length() > 255) {
            throw new VOMSSyntaxException("roleName.length()>255");
        }
        if (!rolePattern.matcher(roleName).matches()) {
            throw new VOMSSyntaxException("Syntax error in role name: " + roleName);
        }
    }

    public static String getParentGroupName(String groupName) {
        PathNamingScheme.checkSyntax(groupName);
        if (StringUtils.countMatches((String)groupName, (String)"/") == 1) {
            return groupName;
        }
        return StringUtils.substringBeforeLast((String)groupName, (String)"/");
    }

    public static String[] getParentGroupChain(String groupName) {
        PathNamingScheme.checkSyntax(groupName);
        Object[] tmp = groupName.split("/");
        Object[] groupChain = (String[])ArrayUtils.subarray((Object[])tmp, (int)1, (int)tmp.length);
        if (groupChain.length == 1) {
            return new String[]{groupName};
        }
        String[] result = new String[groupChain.length - 1];
        if (result.length == 1) {
            result[0] = "/" + groupChain[0];
            return result;
        }
        for (int i = groupChain.length - 1; i > 0; --i) {
            result[i - 1] = "/" + StringUtils.join((Object[])ArrayUtils.subarray((Object[])groupChain, (int)0, (int)i), (String)"/");
        }
        return result;
    }

    public static boolean isGroup(String groupName) {
        PathNamingScheme.checkSyntax(groupName);
        String voName = "/" + VOMSConfiguration.instance().getString("voms.vo.name");
        if (!groupName.startsWith(voName)) {
            log.error((Object)("Group name : " + groupName + " does not start with vo name: " + voName));
            return false;
        }
        return groupPattern.matcher(groupName).matches();
    }

    public static boolean isRole(String roleName) {
        PathNamingScheme.checkSyntax(roleName);
        return rolePattern.matcher(roleName).matches();
    }

    public static boolean isQualifiedRole(String roleName) {
        PathNamingScheme.checkSyntax(roleName);
        return qualifiedRolePattern.matcher(roleName).matches();
    }

    public static String getRoleName(String containerName) {
        if (!PathNamingScheme.isRole(containerName) && !PathNamingScheme.isQualifiedRole(containerName)) {
            throw new VOMSSyntaxException("No role specified in \"" + containerName + "\" voms syntax.");
        }
        Matcher m = containerPattern.matcher(containerName);
        if (m.matches()) {
            String roleGroup = m.group(4);
            return roleGroup.substring(roleGroup.indexOf("=") + 1, roleGroup.length());
        }
        return null;
    }

    public static String getGroupName(String containerName) {
        PathNamingScheme.checkSyntax(containerName);
        if (!PathNamingScheme.isRole(containerName) && !PathNamingScheme.isQualifiedRole(containerName)) {
            return containerName;
        }
        Matcher m = containerPattern.matcher(containerName);
        if (m.matches()) {
            String groupName = m.group(2);
            if (groupName.endsWith("/")) {
                return groupName.substring(0, groupName.length() - 1);
            }
            return groupName;
        }
        return null;
    }
}

