/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.JNDIConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.glite.security.voms.admin.common.VOMSConfigurationException;
import org.glite.security.voms.admin.common.VOMSException;

public final class VOMSConfiguration {
    public static final String LOCALHOST_DEFAULTS_TO_LOCAL_ADMIN = "voms.localhost.defaults.to.local.admin";
    public static final String READONLY = "voms.readonly";
    public static final String CAFILES = "voms.cafiles";
    public static final String CAFILES_PERIOD = "voms.cafiles.period";
    public static final String AUDITING = "voms.auditing";
    public static final String AUDITING_INSERTS = "voms.auditing.inserts";
    public static final String AUDITING_UPDATES = "voms.auditing.updates";
    public static final String AUDITING_DELETIONS = "voms.auditing.deletions";
    public static final String SERVICE_EMAIL_ADDRESS = "voms.notification.email-address";
    public static final String SERVICE_SMTP_SERVER = "voms.notification.smtp-server";
    public static final String SERVICE_SMTP_SERVER_PORT = "voms.notification.smtp-server.port";
    public static final String VO_MEMBERSHIP_EXPIRATION_TIME = "voms.request.vo-membership-expiration-time";
    public static final String VO_NAME = "voms.vo.name";
    public static final String USER_MAX_RESULTS_PER_PAGE = "voms.pagination.user.max.results.per.page";
    public static final String ATTRIBUTES_MAX_RESULTS_PER_PAGE = "voms.pagination.attributes.max.results.per.page";
    public static final String GROUP_MAX_RESULTS_PER_PAGE = "voms.pagination.group.max.results.per.page";
    public static final String ROLE_MAX_RESULTS_PER_PAGE = "voms.pagination.role.max.results.per.page";
    public static final String REGISTRATION_SERVICE_ENABLED = "voms.request.webui.enabled";
    Log log = LogFactory.getLog(VOMSConfiguration.class);
    private static VOMSConfiguration instance = null;
    private ServletContext context;
    private CompositeConfiguration config;
    private static final String[] jndiProperties = new String[]{"VO_NAME", "GLITE_LOCATION", "GLITE_LOCATION_VAR", "VOMS_LOCATION"};

    private void configureLogging() {
        if (this.context != null) {
            try {
                Properties log4jProps = new Properties();
                InputStream is = this.context.getResourceAsStream("/WEB-INF/classes/log4j.runtime.properties");
                if (is == null) {
                    throw new VOMSConfigurationException("Error configuring logging system: log4j.runtime.properties not found in application context!");
                }
                log4jProps.load(is);
                log4jProps.setProperty("log4j.vo", this.getVOName());
                LogManager.resetConfiguration();
                PropertyConfigurator.configure((Properties)log4jProps);
            }
            catch (MalformedURLException e) {
                this.log.error((Object)("Error configuring logging properties! " + e.getMessage()), (Throwable)e);
            }
            catch (IOException e) {
                this.log.error((Object)("Error configuring logging properties! " + e.getMessage()), (Throwable)e);
                throw new VOMSConfigurationException(e.getMessage(), e);
            }
        }
    }

    private void loadDatabaseProperties() {
        try {
            PropertiesConfiguration vomsDatabaseProperties = new PropertiesConfiguration(this.getVomsDatabasePropertiesFileName());
            this.config.addConfiguration((Configuration)vomsDatabaseProperties);
        }
        catch (ConfigurationException e) {
            this.log.fatal((Object)("Error loading voms.database.properties: " + e.getMessage()));
            if (this.log.isDebugEnabled()) {
                this.log.fatal((Object)e.getMessage(), (Throwable)e);
            }
            throw new VOMSConfigurationException("Error loading voms.database.properties: " + e.getMessage(), e);
        }
        this.log.debug((Object)"VOMS Admin database properties loaded!");
    }

    private void loadServiceProperties() {
        String fileName = this.getVomsServicePropertiesFileName();
        try {
            PropertiesConfiguration vomsServiceProperties = new PropertiesConfiguration(this.getVomsServicePropertiesFileName());
            this.config.addConfiguration((Configuration)vomsServiceProperties);
        }
        catch (ConfigurationException e) {
            this.log.fatal((Object)("Error loading service properties from " + fileName));
            if (this.log.isDebugEnabled()) {
                this.log.fatal((Object)e.getMessage(), (Throwable)e);
            }
            throw new VOMSConfigurationException("Error loading service properties from " + fileName, e);
        }
        this.log.debug((Object)"VOMS Admin service properties loaded!");
    }

    private void loadJNDIProperties() {
        JNDIConfiguration jndiConfig;
        try {
            jndiConfig = new JNDIConfiguration();
        }
        catch (NamingException e) {
            this.log.fatal((Object)("Error accessing JNDI configuration properties: " + e.getMessage()));
            if (this.log.isDebugEnabled()) {
                this.log.fatal((Object)e.getMessage(), (Throwable)e);
            }
            throw new VOMSConfigurationException("Error accessing JNDI configuration properties: " + e.getMessage(), e);
        }
        jndiConfig.setPrefix("java:comp/env");
        this.checkJNDIProperties((Configuration)jndiConfig);
        this.config.addConfiguration((Configuration)jndiConfig);
        this.config.setProperty(VO_NAME, jndiConfig.getProperty("VO_NAME"));
    }

    private VOMSConfiguration(boolean useJNDI, ServletContext context) {
        this.context = context;
        this.config = new CompositeConfiguration();
        if (useJNDI) {
            this.loadJNDIProperties();
        } else {
            this.config.addConfiguration((Configuration)new SystemConfiguration());
        }
        this.configureLogging();
        if (!this.getVOName().equals("siblings")) {
            this.loadServiceProperties();
        }
        this.log.info((Object)"VOMS-Admin configuration loaded!");
    }

    private String getVomsServicePropertiesFileName() {
        String fileName = this.config.getString("GLITE_LOCATION_VAR") + "/etc/voms-admin/" + this.getVOName() + "/voms.service.properties";
        return fileName;
    }

    private String getVomsDatabasePropertiesFileName() {
        String fileName = this.config.getString("GLITE_LOCATION_VAR") + "/etc/voms-admin/" + this.getVOName() + "/voms.database.properties";
        this.log.debug((Object)("voms.database.properties=" + fileName));
        return fileName;
    }

    private void checkJNDIProperties(Configuration jndiConfig) {
        for (int i = 0; i < jndiProperties.length; ++i) {
            if (jndiConfig.containsKey(jndiProperties[i])) continue;
            throw new VOMSConfigurationException("Error loading voms-admin configuration: " + jndiProperties[i] + " jndi property not found!");
        }
    }

    public Properties getDatabaseProperties() {
        String propFileName = this.getString("GLITE_LOCATION_VAR") + "/etc/voms-admin/" + this.getVOName() + "/voms.database.properties";
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(propFileName));
        }
        catch (IOException e) {
            this.log.fatal((Object)("Error loading database properties: " + e.getMessage()), (Throwable)e);
            throw new VOMSException("Error loading database properties: " + e.getMessage(), e);
        }
        return props;
    }

    private String loadVomsesConfigurationString() {
        String vomsesConfFileName = this.getString("GLITE_LOCATION_VAR") + "/etc/voms-admin/" + this.getVOName() + "/vomses";
        try {
            int c;
            StringBuffer vomsesContent = new StringBuffer();
            FileReader vomsesFileReader = new FileReader(vomsesConfFileName);
            while ((c = vomsesFileReader.read()) != -1) {
                vomsesContent.append((char)c);
            }
            return vomsesContent.toString();
        }
        catch (IOException e) {
            this.log.fatal((Object)("Error loading vomses configuration file:" + e.getMessage()), (Throwable)e);
            throw new VOMSException("Error loading vomses configuration file:" + e.getMessage(), e);
        }
    }

    public static VOMSConfiguration instance() {
        return VOMSConfiguration.instance(true, null);
    }

    public static VOMSConfiguration instance(ServletContext context) {
        return VOMSConfiguration.instance(true, context);
    }

    public static VOMSConfiguration instance(boolean useJNDI, ServletContext context) {
        if (instance == null) {
            instance = new VOMSConfiguration(useJNDI, context);
        }
        return instance;
    }

    public void addProperty(String arg0, Object arg1) {
        this.config.addProperty(arg0, arg1);
    }

    public void clear() {
        this.config.clear();
    }

    public void clearProperty(String arg0) {
        this.config.clearProperty(arg0);
    }

    public boolean containsKey(String arg0) {
        return this.config.containsKey(arg0);
    }

    public BigDecimal getBigDecimal(String arg0, BigDecimal arg1) {
        return this.config.getBigDecimal(arg0, arg1);
    }

    public BigDecimal getBigDecimal(String arg0) {
        return this.config.getBigDecimal(arg0);
    }

    public BigInteger getBigInteger(String arg0, BigInteger arg1) {
        return this.config.getBigInteger(arg0, arg1);
    }

    public BigInteger getBigInteger(String arg0) {
        return this.config.getBigInteger(arg0);
    }

    public boolean getBoolean(String arg0, boolean arg1) {
        return this.config.getBoolean(arg0, arg1);
    }

    public Boolean getBoolean(String arg0, Boolean arg1) {
        return this.config.getBoolean(arg0, arg1);
    }

    public boolean getBoolean(String arg0) {
        return this.config.getBoolean(arg0);
    }

    public byte getByte(String arg0, byte arg1) {
        return this.config.getByte(arg0, arg1);
    }

    public Byte getByte(String arg0, Byte arg1) {
        return this.config.getByte(arg0, arg1);
    }

    public byte getByte(String arg0) {
        return this.config.getByte(arg0);
    }

    public double getDouble(String arg0, double arg1) {
        return this.config.getDouble(arg0, arg1);
    }

    public Double getDouble(String arg0, Double arg1) {
        return this.config.getDouble(arg0, arg1);
    }

    public double getDouble(String arg0) {
        return this.config.getDouble(arg0);
    }

    public float getFloat(String arg0, float arg1) {
        return this.config.getFloat(arg0, arg1);
    }

    public Float getFloat(String arg0, Float arg1) {
        return this.config.getFloat(arg0, arg1);
    }

    public float getFloat(String arg0) {
        return this.config.getFloat(arg0);
    }

    public int getInt(String arg0, int arg1) {
        return this.config.getInt(arg0, arg1);
    }

    public int getInt(String arg0) {
        return this.config.getInt(arg0);
    }

    public Integer getInteger(String arg0, Integer arg1) {
        return this.config.getInteger(arg0, arg1);
    }

    public Iterator getKeys() {
        return this.config.getKeys();
    }

    public Iterator getKeys(String arg0) {
        return this.config.getKeys(arg0);
    }

    public List getList(String arg0, List arg1) {
        return this.config.getList(arg0, arg1);
    }

    public List getList(String arg0) {
        return this.config.getList(arg0);
    }

    public long getLong(String arg0, long arg1) {
        return this.config.getLong(arg0, arg1);
    }

    public Long getLong(String arg0, Long arg1) {
        return this.config.getLong(arg0, arg1);
    }

    public long getLong(String arg0) {
        return this.config.getLong(arg0);
    }

    public Properties getProperties(String arg0) {
        return this.config.getProperties(arg0);
    }

    public Object getProperty(String arg0) {
        return this.config.getProperty(arg0);
    }

    public short getShort(String arg0, short arg1) {
        return this.config.getShort(arg0, arg1);
    }

    public Short getShort(String arg0, Short arg1) {
        return this.config.getShort(arg0, arg1);
    }

    public short getShort(String arg0) {
        return this.config.getShort(arg0);
    }

    public String getString(String arg0, String arg1) {
        return this.config.getString(arg0, arg1);
    }

    public String getString(String arg0) {
        return this.config.getString(arg0);
    }

    public String[] getStringArray(String arg0) {
        return this.config.getStringArray(arg0);
    }

    public boolean isEmpty() {
        return this.config.isEmpty();
    }

    public void setProperty(String arg0, Object arg1) {
        this.config.setProperty(arg0, arg1);
    }

    public Configuration subset(String arg0) {
        return this.config.subset(arg0);
    }

    public Map asMap() {
        HashMap returnValue = new HashMap();
        Iterator keys = this.config.getKeys();
        while (keys.hasNext()) {
            Object key = keys.next();
            Object property = this.config.getProperty((String)key);
            returnValue.put(key, property);
        }
        return returnValue;
    }

    public String getVOName() {
        return this.getString(VO_NAME);
    }

    public List getLocallyConfiguredVOs() {
        String configDirPath = this.getString("GLITE_LOCATION_VAR");
        if (configDirPath == null) {
            throw new VOMSConfigurationException("No value found for GLITE_LOCATION_VAR!");
        }
        ArrayList<String> voList = new ArrayList<String>();
        File configDir = new File(configDirPath + File.separator + "etc" + File.separator + "voms-admin");
        if (!configDir.exists()) {
            throw new VOMSConfigurationException("Voms configuration directory does not exist");
        }
        File[] filez = configDir.listFiles();
        if (filez != null) {
            for (int i = 0; i < filez.length; ++i) {
                if (!filez[i].isDirectory()) continue;
                this.log.debug((Object)("Found vo: " + filez[i].getName()));
                voList.add(filez[i].getName());
            }
        }
        return voList;
    }

    public String getVomsesConfigurationString() {
        if (this.getString("vomses.configuration") == null) {
            String vomsesConfString = this.loadVomsesConfigurationString();
            this.setProperty("vomses.configuration", vomsesConfString);
        }
        return this.getString("vomses.configuration");
    }

    public String getTemplatePath() {
        return this.getString("GLITE_LOCATION") + "/etc/voms-admin/templates/email";
    }

    public ServletContext getServletContext() {
        return this.context;
    }
}

